/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.tools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public abstract class AbstractSearchTool
implements ViewTool {
    public static final int DEFAULT_ITEMS_PER_PAGE = 10;
    public static final int DEFAULT_SLIP_SIZE = 20;
    protected static final String STORED_RESULTS_KEY = (class$org$apache$velocity$tools$view$tools$AbstractSearchTool$StoredResults == null ? (class$org$apache$velocity$tools$view$tools$AbstractSearchTool$StoredResults = AbstractSearchTool.class$("org.apache.velocity.tools.view.tools.AbstractSearchTool$StoredResults")) : class$org$apache$velocity$tools$view$tools$AbstractSearchTool$StoredResults).getName();
    private List results;
    private Object criteria;
    private int index = 0;
    private int slipSize = 20;
    private int itemsPerPage = 10;
    protected HttpSession session;
    static /* synthetic */ Class class$org$apache$velocity$tools$view$tools$AbstractSearchTool$StoredResults;

    public void init(Object object) {
        ViewContext viewContext = (ViewContext)object;
        HttpServletRequest httpServletRequest = viewContext.getRequest();
        this.session = httpServletRequest.getSession(false);
        this.setup(httpServletRequest);
    }

    public abstract void setup(HttpServletRequest var1);

    public void reset() {
        this.results = null;
        this.criteria = null;
        this.index = 0;
        this.itemsPerPage = 10;
    }

    public void setCriteria(Object object) {
        this.criteria = object;
        this.results = null;
    }

    public void setIndex(int n) {
        if (n < 0) {
            n = 0;
        }
        this.index = n;
    }

    public void setItemsPerPage(int n) {
        if (n < 1) {
            n = 10;
        }
        this.itemsPerPage = n;
    }

    public void setSlipSize(int n) {
        if (n < 2) {
            n = 20;
        }
        this.slipSize = n;
    }

    public Object getCriteria() {
        return this.criteria;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int getSlipSize() {
        return this.slipSize;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasResults() {
        return !this.getResults().isEmpty();
    }

    public List getResults() {
        if (this.results == null) {
            this.results = this.retrieveResults();
        }
        return this.results;
    }

    public Integer getNextIndex() {
        int n = this.index + this.itemsPerPage;
        if (n < this.getResults().size()) {
            return new Integer(n);
        }
        return null;
    }

    public Integer getPrevIndex() {
        int n = Math.min(this.index, this.getResults().size()) - this.itemsPerPage;
        if (this.index > 0) {
            return new Integer(Math.max(0, n));
        }
        return null;
    }

    public int getPagesAvailable() {
        return (int)Math.ceil((double)this.getResults().size() / (double)this.itemsPerPage);
    }

    public List getPage() {
        if (!this.hasResults()) {
            return null;
        }
        int n = Math.min(this.getResults().size() - 1, this.index);
        int n2 = Math.min(this.getResults().size(), this.index + this.itemsPerPage);
        return this.getResults().subList(n, n2);
    }

    public Integer getPageNumber(int n) {
        if (!this.hasResults()) {
            return null;
        }
        return new Integer(1 + n / this.itemsPerPage);
    }

    public Integer getPageNumber() {
        return this.getPageNumber(this.index);
    }

    public String getPageDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.index + 1;
        int n2 = this.getResults().size();
        if (n >= n2) {
            stringBuffer.append(n2);
            stringBuffer.append(" of ");
            stringBuffer.append(n2);
        } else {
            int n3 = Math.min(this.index + this.itemsPerPage, n2);
            stringBuffer.append(n);
            stringBuffer.append(" - ");
            stringBuffer.append(n3);
            stringBuffer.append(" of ");
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    public List getSlip() {
        int n;
        int n2 = this.getPagesAvailable();
        if (n2 <= 1) {
            return Collections.EMPTY_LIST;
        }
        int n3 = this.getPageNumber() - 1;
        int n4 = Math.max(0, n3 - (n = this.slipSize - 1) / 2);
        int n5 = Math.min(n2, n4 + n);
        if (n5 - n4 < n) {
            n4 = Math.max(0, n5 - n);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n5 - n4 + 1);
        for (int i = n4; i < n5; ++i) {
            arrayList.add(new Integer(i * this.itemsPerPage));
        }
        return arrayList;
    }

    private List retrieveResults() {
        if (this.criteria == null) {
            return Collections.EMPTY_LIST;
        }
        StoredResults storedResults = this.getStoredResults();
        if (storedResults != null && this.criteria.equals(storedResults.getCriteria())) {
            return storedResults.getList();
        }
        List list = this.executeQuery(this.criteria);
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        this.setStoredResults(new StoredResults(this.criteria, list));
        return list;
    }

    protected abstract List executeQuery(Object var1);

    protected StoredResults getStoredResults() {
        if (this.session != null) {
            return (StoredResults)this.session.getAttribute(STORED_RESULTS_KEY);
        }
        return null;
    }

    protected void setStoredResults(StoredResults storedResults) {
        if (this.session != null) {
            this.session.setAttribute(STORED_RESULTS_KEY, (Object)storedResults);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class StoredResults
    implements Serializable {
        private transient Object crit;
        private transient List list;

        public StoredResults(Object object, List list) {
            this.crit = object;
            this.list = list;
        }

        public Object getCriteria() {
            return this.crit;
        }

        public List getList() {
            return this.list;
        }
    }
}

