/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionFormBeans;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionForwards;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMappings;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class StrutsUtils {
    public static DataSource getDataSource(ServletContext servletContext) {
        return (DataSource)servletContext.getAttribute("org.apache.struts.action.DATA_SOURCE");
    }

    public static ActionFormBeans getActionFormBeans(ServletContext servletContext) {
        return (ActionFormBeans)servletContext.getAttribute("org.apache.struts.action.FORM_BEANS");
    }

    public static FormBeanConfig getFormBean(String string, ServletContext servletContext) {
        ActionFormBeans actionFormBeans = StrutsUtils.getActionFormBeans(servletContext);
        if (actionFormBeans == null) {
            return null;
        }
        return actionFormBeans.findFormBean(string);
    }

    public static ActionForwards getActionForwards(ServletContext servletContext) {
        return (ActionForwards)servletContext.getAttribute("org.apache.struts.action.FORWARDS");
    }

    public static ActionForward getActionForward(String string, ServletContext servletContext) {
        ActionForwards actionForwards = StrutsUtils.getActionForwards(servletContext);
        if (actionForwards == null) {
            return null;
        }
        return actionForwards.findForward(string);
    }

    public static ActionMappings getActionMappings(ServletContext servletContext) {
        return (ActionMappings)servletContext.getAttribute("org.apache.struts.action.MAPPINGS");
    }

    public static ActionMapping getActionMapping(String string, ServletContext servletContext) {
        ActionMappings actionMappings = StrutsUtils.getActionMappings(servletContext);
        if (actionMappings == null) {
            return null;
        }
        return actionMappings.findMapping(string);
    }

    public static MessageResources getMessageResources(ServletContext servletContext) {
        return (MessageResources)servletContext.getAttribute("org.apache.struts.action.MESSAGE");
    }

    public static MessageResources getMessageResources(HttpServletRequest httpServletRequest, ServletContext servletContext) {
        ModuleConfig moduleConfig = RequestUtils.getModuleConfig((HttpServletRequest)httpServletRequest, (ServletContext)servletContext);
        return (MessageResources)servletContext.getAttribute("org.apache.struts.action.MESSAGE" + moduleConfig.getPrefix());
    }

    public static MessageResources getMessageResources(HttpServletRequest httpServletRequest, ServletContext servletContext, String string) {
        MessageResources messageResources = null;
        ModuleConfig moduleConfig = RequestUtils.getModuleConfig((HttpServletRequest)httpServletRequest, (ServletContext)servletContext);
        if (string == null) {
            string = "org.apache.struts.action.MESSAGE";
        }
        if ((messageResources = (MessageResources)httpServletRequest.getAttribute(string + moduleConfig.getPrefix())) == null) {
            messageResources = (MessageResources)servletContext.getAttribute(string + moduleConfig.getPrefix());
        }
        return messageResources;
    }

    public static ModuleConfig selectModule(String string, ServletContext servletContext) {
        String string2 = RequestUtils.getModuleName((String)string, (ServletContext)servletContext);
        ModuleConfig moduleConfig = (ModuleConfig)servletContext.getAttribute("org.apache.struts.action.MODULE" + string2);
        return moduleConfig;
    }

    public static String getServletMapping(ServletContext servletContext) {
        return (String)servletContext.getAttribute("org.apache.struts.action.SERVLET_MAPPING");
    }

    public static Locale getLocale(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        Locale locale = null;
        if (httpSession != null) {
            locale = (Locale)httpSession.getAttribute("org.apache.struts.action.LOCALE");
        }
        if (locale == null) {
            locale = httpServletRequest.getLocale();
        }
        return locale;
    }

    public static String getToken(HttpSession httpSession) {
        if (httpSession == null) {
            return null;
        }
        return (String)httpSession.getAttribute("org.apache.struts.action.TOKEN");
    }

    public static ActionMessages getErrors(HttpServletRequest httpServletRequest) {
        return (ActionMessages)httpServletRequest.getAttribute("org.apache.struts.action.ERROR");
    }

    public static ActionMessages getMessages(HttpServletRequest httpServletRequest) {
        return (ActionMessages)httpServletRequest.getAttribute("org.apache.struts.action.ACTION_MESSAGE");
    }

    public static ActionErrors getActionErrors(HttpServletRequest httpServletRequest) {
        return (ActionErrors)StrutsUtils.getErrors(httpServletRequest);
    }

    public static ActionMessages getActionMessages(HttpServletRequest httpServletRequest) {
        return StrutsUtils.getMessages(httpServletRequest);
    }

    public static Throwable getException(HttpServletRequest httpServletRequest) {
        return (Throwable)httpServletRequest.getAttribute("org.apache.struts.action.EXCEPTION");
    }

    public static MultipartRequestWrapper getMultipartRequestWrapper(HttpServletRequest httpServletRequest) {
        return (MultipartRequestWrapper)httpServletRequest.getAttribute("org.apache.struts.action.mapping.multipartclass");
    }

    public static ActionForm getActionForm(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        ActionConfig actionConfig = (ActionConfig)httpServletRequest.getAttribute("org.apache.struts.action.mapping.instance");
        if (actionConfig == null) {
            return null;
        }
        String string = actionConfig.getAttribute();
        if (string == null) {
            return null;
        }
        if ("request".equals(actionConfig.getScope())) {
            return (ActionForm)httpServletRequest.getAttribute(string);
        }
        if (httpSession != null) {
            return (ActionForm)httpSession.getAttribute(string);
        }
        return null;
    }

    public static String getCancelName() {
        return "org.apache.struts.taglib.html.CANCEL";
    }

    public static String getGlobalErrorName() {
        return "org.apache.struts.action.GLOBAL_ERROR";
    }

    public static String getTokenName() {
        return "org.apache.struts.taglib.html.TOKEN";
    }

    public static String getActionMappingName(String string) {
        return RequestUtils.getActionMappingName((String)string);
    }

    public static String getActionMappingURL(ServletContext servletContext, HttpServletRequest httpServletRequest, String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(httpServletRequest.getContextPath());
        ModuleConfig moduleConfig = (ModuleConfig)httpServletRequest.getAttribute("org.apache.struts.action.MODULE");
        if (moduleConfig != null) {
            stringBuffer.append(moduleConfig.getPrefix());
        }
        if ((string2 = (String)servletContext.getAttribute("org.apache.struts.action.SERVLET_MAPPING")) != null) {
            String string3 = null;
            int n = string.indexOf("?");
            if (n >= 0) {
                string3 = string.substring(n);
            }
            String string4 = RequestUtils.getActionMappingName((String)string);
            if (string2.startsWith("*.")) {
                stringBuffer.append(string4);
                stringBuffer.append(string2.substring(1));
            } else if (string2.endsWith("/*")) {
                stringBuffer.append(string2.substring(0, string2.length() - 2));
                stringBuffer.append(string4);
            }
            if (string3 != null) {
                stringBuffer.append(string3);
            }
        } else {
            if (!string.startsWith("/")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String getForwardURL(HttpServletRequest httpServletRequest, ServletContext servletContext, String string) {
        ModuleConfig moduleConfig = RequestUtils.getModuleConfig((HttpServletRequest)httpServletRequest, (ServletContext)servletContext);
        ForwardConfig forwardConfig = moduleConfig.findForwardConfig(string);
        if (forwardConfig == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (forwardConfig.getPath().startsWith("/")) {
            stringBuffer.append(httpServletRequest.getContextPath());
            stringBuffer.append(RequestUtils.forwardURL((HttpServletRequest)httpServletRequest, (ForwardConfig)forwardConfig));
        } else {
            stringBuffer.append(forwardConfig.getPath());
        }
        return stringBuffer.toString();
    }

    public static String errorMarkup(String string, HttpServletRequest httpServletRequest, HttpSession httpSession, ServletContext servletContext) {
        return StrutsUtils.errorMarkup(string, null, httpServletRequest, httpSession, servletContext);
    }

    public static String errorMarkup(String string, String string2, HttpServletRequest httpServletRequest, HttpSession httpSession, ServletContext servletContext) {
        ActionErrors actionErrors = StrutsUtils.getActionErrors(httpServletRequest);
        if (actionErrors == null) {
            return "";
        }
        Iterator iterator = null;
        iterator = string == null ? actionErrors.get() : actionErrors.get(string);
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        String string4 = null;
        Locale locale = StrutsUtils.getLocale(httpServletRequest, httpSession);
        MessageResources messageResources = StrutsUtils.getMessageResources(httpServletRequest, servletContext, string2);
        if (messageResources != null) {
            string3 = messageResources.getMessage(locale, "errors.header");
            string4 = messageResources.getMessage(locale, "errors.footer");
        }
        if (string3 == null) {
            string3 = "errors.header";
        }
        if (string4 == null) {
            string4 = "errors.footer";
        }
        stringBuffer.append(string3);
        stringBuffer.append("\r\n");
        while (iterator.hasNext()) {
            String string5 = null;
            ActionMessage actionMessage = (ActionMessage)iterator.next();
            if (messageResources != null) {
                string5 = messageResources.getMessage(locale, actionMessage.getKey(), actionMessage.getValues());
            }
            if (string5 != null) {
                stringBuffer.append(string5);
                stringBuffer.append("\r\n");
                continue;
            }
            stringBuffer.append(actionMessage.getKey());
            stringBuffer.append("\r\n");
        }
        stringBuffer.append(string4);
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }
}

