/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.headerresource.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.headerresource.HeaderResource;
import org.apache.jetspeed.request.RequestContext;

public class HeaderResourceImpl
implements HeaderResource {
    private RequestContext requestContext;

    public HeaderResourceImpl(RequestContext context) {
        this.requestContext = context;
    }

    private Set getHeaderInfoSet() {
        LinkedHashSet headerInfoSet = (LinkedHashSet)this.requestContext.getAttribute("org.apache.jetspeed.headerresource");
        if (headerInfoSet == null) {
            headerInfoSet = new LinkedHashSet();
            this.requestContext.setAttribute("org.apache.jetspeed.headerresource", headerInfoSet);
        }
        return headerInfoSet;
    }

    public String toString() {
        Set headerInfoSet = this.getHeaderInfoSet();
        StringBuffer header = new StringBuffer();
        Iterator ite = headerInfoSet.iterator();
        while (ite.hasNext()) {
            header.append(((HeaderInfo)ite.next()).toString());
            header.append("\n");
        }
        return header.toString();
    }

    public void addHeaderInfo(String elementName, Map attributes, String text) {
        HeaderInfo headerInfo = new HeaderInfo(elementName, attributes, text);
        if (!this.containsHeaderInfo(headerInfo)) {
            Set headerInfoSet = this.getHeaderInfoSet();
            headerInfoSet.add(headerInfo);
        }
    }

    private boolean containsHeaderInfo(HeaderInfo headerInfo) {
        Set headerInfoSet = this.getHeaderInfoSet();
        Iterator ite = headerInfoSet.iterator();
        while (ite.hasNext()) {
            HeaderInfo hInfo = (HeaderInfo)ite.next();
            if (!headerInfo.equals(hInfo)) continue;
            return true;
        }
        return false;
    }

    public void addJavaScript(String path, boolean defer) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("src", path);
        attrs.put("type", "text/javascript");
        if (defer) {
            attrs.put("defer", "true");
        }
        this.addHeaderInfo("script", attrs, "");
    }

    public void addJavaScript(String path) {
        this.addJavaScript(path, false);
    }

    public void addStyleSheet(String path) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("rel", "stylesheet");
        attrs.put("href", path);
        attrs.put("type", "text/css");
        this.addHeaderInfo("link", attrs, null);
    }

    private class HeaderInfo {
        private String elementName;
        private Map attributes;
        private String text;

        public HeaderInfo(String elementName) {
            this(elementName, new HashMap());
        }

        public HeaderInfo(String elementName, Map attr) {
            this(elementName, attr, null);
        }

        public HeaderInfo(String elementName, Map attr, String text) {
            this.setElementName(elementName);
            this.setAttributes(attr);
            this.setText(text);
        }

        public void addAttribute(String key, String value) {
            this.attributes.put(key, value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("<");
            buf.append(this.getElementName());
            buf.append(" ");
            Set keySet = this.getAttributes().keySet();
            Iterator ite = keySet.iterator();
            while (ite.hasNext()) {
                String key = (String)ite.next();
                buf.append(key);
                buf.append("=\"");
                buf.append((String)this.getAttributes().get(key));
                buf.append("\" ");
            }
            if (this.getText() != null) {
                buf.append(">" + this.getText() + "</" + this.getElementName() + ">");
            } else {
                buf.append("/>");
            }
            return buf.toString();
        }

        public boolean equals(Object o) {
            HeaderInfo headerInfo;
            return o instanceof HeaderInfo && (headerInfo = (HeaderInfo)o).getElementName().equalsIgnoreCase(this.getElementName()) && this.compareString(headerInfo.getText(), this.getText()) && ((Object)headerInfo.getAttributes()).equals(this.getAttributes());
        }

        private boolean compareString(String str0, String str1) {
            return str0 == null ? str1 == null : str0.equals(str1);
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map attributes) {
            this.attributes = attributes;
        }

        public String getElementName() {
            return this.elementName;
        }

        public void setElementName(String elementName) {
            this.elementName = elementName;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

