/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.locator;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.locator.JetspeedTemplateDescriptor;
import org.apache.jetspeed.locator.LocatorDescriptor;
import org.apache.jetspeed.locator.TemplateDescriptor;
import org.apache.jetspeed.locator.TemplateLocator;
import org.apache.jetspeed.locator.TemplateLocatorException;

public class JetspeedTemplateLocator
implements TemplateLocator {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$locator$JetspeedTemplateLocator == null ? (class$org$apache$jetspeed$locator$JetspeedTemplateLocator = JetspeedTemplateLocator.class$("org.apache.jetspeed.locator.JetspeedTemplateLocator")) : class$org$apache$jetspeed$locator$JetspeedTemplateLocator));
    private static final String PATH_SEPARATOR = "/";
    private List roots;
    private String appRoot;
    private Class templateClass = class$org$apache$jetspeed$locator$JetspeedTemplateDescriptor == null ? (class$org$apache$jetspeed$locator$JetspeedTemplateDescriptor = JetspeedTemplateLocator.class$("org.apache.jetspeed.locator.JetspeedTemplateDescriptor")) : class$org$apache$jetspeed$locator$JetspeedTemplateDescriptor;
    private Class locatorClass = class$org$apache$jetspeed$locator$JetspeedLocatorDescriptor == null ? (class$org$apache$jetspeed$locator$JetspeedLocatorDescriptor = JetspeedTemplateLocator.class$("org.apache.jetspeed.locator.JetspeedLocatorDescriptor")) : class$org$apache$jetspeed$locator$JetspeedLocatorDescriptor;
    private String defaultLocatorType = "layout";
    private Map templateMap = null;
    private boolean useNameCache = true;
    static /* synthetic */ Class class$org$apache$jetspeed$locator$JetspeedTemplateLocator;
    static /* synthetic */ Class class$org$apache$jetspeed$locator$JetspeedTemplateDescriptor;
    static /* synthetic */ Class class$org$apache$jetspeed$locator$JetspeedLocatorDescriptor;

    private JetspeedTemplateLocator() {
    }

    public JetspeedTemplateLocator(List roots, String appRoot) throws FileNotFoundException {
        this.appRoot = appRoot;
        log.info((Object)("Locator application root " + new File(appRoot).getAbsolutePath()));
        this.roots = roots;
        Iterator itr = roots.iterator();
        while (itr.hasNext()) {
            String path = (String)itr.next();
            File checkFile = new File(path);
            if (checkFile.exists()) continue;
            throw new FileNotFoundException("Locator resource root " + checkFile.getAbsolutePath() + " does not exist.");
        }
    }

    public JetspeedTemplateLocator(List roots, String defaultLocatorType, String appRoot) throws FileNotFoundException {
        this(roots, appRoot);
        this.defaultLocatorType = defaultLocatorType;
    }

    public JetspeedTemplateLocator(List roots, List omClasses, String defaultLocatorType, String appRoot) throws FileNotFoundException {
        this(roots, defaultLocatorType, appRoot);
        if (omClasses.size() > 0) {
            this.templateClass = (Class)omClasses.get(0);
            if (omClasses.size() > 1) {
                this.locatorClass = (Class)omClasses.get(1);
            }
        }
    }

    public TemplateDescriptor locateTemplate(LocatorDescriptor locator) {
        for (int ix = 0; ix < this.roots.size(); ++ix) {
            TemplateDescriptor template = this.locateTemplate(locator, (String)this.roots.get(ix));
            if (null == template) {
                this.useNameCache = false;
                template = this.locateTemplate(locator, (String)this.roots.get(ix));
                if (null != template) {
                    this.templateMap.put(template.getAbsolutePath(), null);
                }
                this.useNameCache = true;
            }
            if (template == null) continue;
            return template;
        }
        return null;
    }

    private TemplateDescriptor locateTemplate(LocatorDescriptor locator, String root) {
        int pt;
        String templateName = locator.getName();
        String path = locator.toPath();
        int last = path.lastIndexOf(PATH_SEPARATOR);
        path = last > -1 ? path.substring(0, last) : null;
        String basePath = root;
        String realPath = null;
        String workingPath = null;
        do {
            workingPath = path + PATH_SEPARATOR + templateName;
            realPath = root + workingPath;
            if (!this.templateExists(realPath)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("TemplateLocator: template exists: " + realPath + " returning " + workingPath));
            }
            int appRootLength = this.appRoot.length();
            String appRelativePath = realPath.substring(appRootLength, realPath.length());
            return this.createTemplateFromPath(path, templateName, realPath, appRelativePath);
        } while ((path = (pt = path.lastIndexOf(PATH_SEPARATOR)) > -1 ? path.substring(0, pt) : null) != null);
        return null;
    }

    public boolean templateExists(String templateKey) {
        if (null == templateKey) {
            return false;
        }
        if (this.useNameCache) {
            return this.templateMap.containsKey(templateKey);
        }
        return new File(templateKey).exists();
    }

    public LocatorDescriptor createFromString(String path) throws TemplateLocatorException {
        LocatorDescriptor locator = this.createLocatorDescriptor(this.defaultLocatorType);
        StringTokenizer tok = new StringTokenizer(path, PATH_SEPARATOR);
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken();
            if (name.equals("type") && tok.hasMoreTokens()) {
                locator.setType(tok.nextToken());
                continue;
            }
            if (name.equals("media-type") && tok.hasMoreTokens()) {
                locator.setMediaType(tok.nextToken());
                continue;
            }
            if (name.equals("language") && tok.hasMoreTokens()) {
                locator.setLanguage(tok.nextToken());
                continue;
            }
            if (name.equals("country") && tok.hasMoreTokens()) {
                locator.setCountry(tok.nextToken());
                continue;
            }
            if (!name.equals("name") || !tok.hasMoreTokens()) continue;
            locator.setName(tok.nextToken());
        }
        return locator;
    }

    private TemplateDescriptor createTemplateFromPath(String path, String name, String realPath, String relativePath) {
        TemplateDescriptor template = this.createTemplate();
        template.setAbsolutePath(realPath);
        if (relativePath.indexOf(PATH_SEPARATOR) != 0) {
            relativePath = PATH_SEPARATOR + relativePath;
        }
        template.setAppRelativePath(relativePath);
        template.setName(name);
        StringTokenizer tok = new StringTokenizer(path, PATH_SEPARATOR);
        int count = 0;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            switch (count) {
                case 0: {
                    template.setType(token);
                    break;
                }
                case 1: {
                    template.setMediaType(token);
                    break;
                }
                case 2: {
                    template.setLanguage(token);
                    break;
                }
                case 3: {
                    template.setCountry(token);
                }
            }
            ++count;
        }
        return template;
    }

    public LocatorDescriptor createLocatorDescriptor(String type) throws TemplateLocatorException {
        LocatorDescriptor locator = null;
        try {
            locator = (LocatorDescriptor)this.locatorClass.newInstance();
            locator.setType(type);
        }
        catch (Exception e) {
            throw new TemplateLocatorException("Failed instantiate a Template Locator implementation object: ", (Throwable)e);
        }
        return locator;
    }

    private TemplateDescriptor createTemplate() {
        TemplateDescriptor template = null;
        try {
            template = (TemplateDescriptor)this.templateClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Failed to create template", (Throwable)e);
            template = new JetspeedTemplateDescriptor();
        }
        return template;
    }

    public void start() {
        this.templateMap = new HashMap();
        for (int ix = 0; ix < this.roots.size(); ++ix) {
            String templateRoot = (String)this.roots.get(ix);
            if (!templateRoot.endsWith(PATH_SEPARATOR)) {
                templateRoot = templateRoot + PATH_SEPARATOR;
            }
            this.loadNameCache(templateRoot, "");
        }
    }

    public void stop() {
    }

    public Iterator query(LocatorDescriptor locator) {
        return null;
    }

    private void loadNameCache(String path, String name) {
        File file = new File(path);
        if (file.isFile()) {
            this.templateMap.put(path, null);
        } else if (file.isDirectory()) {
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            String[] list = file.list();
            for (int ix = 0; list != null && ix < list.length; ++ix) {
                this.loadNameCache(path + list[ix], list[ix]);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

