/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtils {
    private static final int DEFAULT_BUFFER_SIZE = 1024;

    public static void pipe(InputStream toRead, OutputStream toWrite) throws IOException {
        StreamUtils.pipe(toRead, toWrite, 1024);
    }

    public static void pipe(InputStream toRead, OutputStream toWrite, int bufferSize) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = toRead.read(buffer)) != -1) {
            toWrite.write(buffer, 0, bytesRead);
        }
    }

    protected static ByteArrayOutputStream readStream(InputStream toRead, int bufferSize) throws IOException {
        int bytesRead;
        ByteArrayOutputStream contents = new ByteArrayOutputStream();
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = toRead.read(buffer)) != -1) {
            contents.write(buffer, 0, bytesRead);
        }
        return contents;
    }

    public static byte[] streamAsBytes(InputStream toRead, int bufferSize) throws IOException {
        ByteArrayOutputStream contents = StreamUtils.readStream(toRead, bufferSize);
        return contents.toByteArray();
    }

    public static String streamAsString(InputStream toRead) throws IOException {
        return StreamUtils.streamAsString(toRead, 1024, null);
    }

    public static String streamAsString(InputStream toRead, int bufferSize, String encoding) throws IOException {
        ByteArrayOutputStream contents = StreamUtils.readStream(toRead, bufferSize);
        return encoding == null ? contents.toString() : contents.toString(encoding);
    }
}

