/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.prefs.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.prefs.FailedToCreateNodeException;
import org.apache.jetspeed.prefs.NodeAlreadyExistsException;
import org.apache.jetspeed.prefs.NodeDoesNotExistException;
import org.apache.jetspeed.prefs.PreferencesProvider;
import org.apache.jetspeed.prefs.om.Node;
import org.apache.jetspeed.prefs.om.impl.NodeImpl;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;

public class PersistenceBrokerPreferencesProvider
extends InitablePersistenceBrokerDaoSupport
implements PreferencesProvider {
    private HashMap nodeMap = new HashMap();
    private boolean enablePropertyManager;
    static /* synthetic */ Class class$org$apache$jetspeed$prefs$om$impl$NodeImpl;

    public PersistenceBrokerPreferencesProvider(String repositoryPath, boolean enablePropertyManager) throws ClassNotFoundException {
        super(repositoryPath);
        this.enablePropertyManager = enablePropertyManager;
    }

    public void setEnablePropertyManager(boolean enablePropertyManager) {
        this.enablePropertyManager = enablePropertyManager;
    }

    public Node getNode(String fullPath, int nodeType) throws NodeDoesNotExistException {
        NodeCache key = new NodeCache(fullPath, nodeType);
        NodeCache hit = (NodeCache)this.nodeMap.get(key);
        if (hit != null) {
            return hit.getNode();
        }
        Criteria c = new Criteria();
        c.addEqualTo("fullPath", (Object)fullPath);
        c.addEqualTo("nodeType", (Object)new Integer(nodeType));
        QueryByCriteria query = QueryFactory.newQuery((Class)(class$org$apache$jetspeed$prefs$om$impl$NodeImpl == null ? (class$org$apache$jetspeed$prefs$om$impl$NodeImpl = PersistenceBrokerPreferencesProvider.class$("org.apache.jetspeed.prefs.om.impl.NodeImpl")) : class$org$apache$jetspeed$prefs$om$impl$NodeImpl), (Criteria)c);
        Node nodeObj = (Node)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (null != nodeObj) {
            key.setNode(nodeObj);
            this.nodeMap.put(key, key);
            return nodeObj;
        }
        throw new NodeDoesNotExistException("No node of type " + nodeType + "found at path: " + fullPath);
    }

    public boolean nodeExists(String fullPath, int nodeType) {
        try {
            this.getNode(fullPath, nodeType);
            return true;
        }
        catch (NodeDoesNotExistException e) {
            return false;
        }
    }

    public Node createNode(Node parent, String nodeName, int nodeType, String fullPath) throws FailedToCreateNodeException, NodeAlreadyExistsException {
        if (this.nodeExists(fullPath, nodeType)) {
            throw new NodeAlreadyExistsException("Node of type " + nodeType + " already exists at path " + fullPath);
        }
        Long parentNodeId = null;
        if (null != parent) {
            parentNodeId = new Long(parent.getNodeId());
        }
        NodeImpl nodeObj = new NodeImpl(parentNodeId, nodeName, nodeType, fullPath);
        try {
            this.getPersistenceBrokerTemplate().store((Object)nodeObj);
            NodeCache key = new NodeCache(nodeObj);
            this.nodeMap.put(key, key);
            return nodeObj;
        }
        catch (Exception e) {
            throw new FailedToCreateNodeException("Failed to create node of type " + nodeType + " for the path " + fullPath + ".  " + e.toString(), (Throwable)e);
        }
    }

    public Collection getChildren(Node parentNode) {
        NodeCache key = new NodeCache(parentNode);
        NodeCache hit = (NodeCache)this.nodeMap.get(key);
        if (hit == null) {
            key.setNode(parentNode);
            this.nodeMap.put(key, key);
            hit = key;
        }
        if (hit.isChildrenLoaded()) {
            return hit.getChildren();
        }
        Criteria c = new Criteria();
        c.addEqualTo("parentNodeId", (Object)new Long(parentNode.getNodeId()));
        QueryByCriteria query = QueryFactory.newQuery((Class)(class$org$apache$jetspeed$prefs$om$impl$NodeImpl == null ? (class$org$apache$jetspeed$prefs$om$impl$NodeImpl = PersistenceBrokerPreferencesProvider.class$("org.apache.jetspeed.prefs.om.impl.NodeImpl")) : class$org$apache$jetspeed$prefs$om$impl$NodeImpl), (Criteria)c);
        Collection children = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        hit.setChildren(children);
        hit.setChildrenLoaded(true);
        return children;
    }

    public void storeNode(Node node) {
        NodeCache key = new NodeCache(node);
        this.nodeMap.remove(key);
        this.getPersistenceBrokerTemplate().store((Object)node);
    }

    public void removeNode(Node node) {
        NodeCache key = new NodeCache(node);
        this.nodeMap.remove(key);
        this.getPersistenceBrokerTemplate().delete((Object)node);
    }

    public boolean isPropertyManagerEnabled() {
        return this.enablePropertyManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class NodeCache
    implements Serializable {
        Node node;
        String fullpath;
        int type;
        boolean childrenLoaded;
        Collection children;

        public NodeCache(Node node) {
            this.node = node;
            this.fullpath = node.getFullPath();
            this.type = node.getNodeType();
        }

        public NodeCache(String fullpath, int type) {
            this.fullpath = fullpath;
            this.type = type;
        }

        public boolean isChildrenLoaded() {
            return this.childrenLoaded;
        }

        public void setChildrenLoaded(boolean childrenLoaded) {
            this.childrenLoaded = childrenLoaded;
        }

        public String getFullpath() {
            return this.fullpath;
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public int getType() {
            return this.type;
        }

        public Collection getChildren() {
            return this.children;
        }

        public void setChildren(Collection children) {
            this.children = children;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof NodeCache) {
                NodeCache other = (NodeCache)obj;
                return this.fullpath.equals(other.fullpath) && this.type == other.type;
            }
            return false;
        }

        public int hashCode() {
            return this.fullpath.hashCode() + this.type;
        }
    }
}

