/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.i18n;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.jetspeed.i18n.CurrentLocale;

public class KeyedMessage
implements Serializable {
    public static final String KEYED_MESSAGE_BUNDLE_FIELD_NAME = "KEYED_MESSAGE_BUNDLE";
    private static final String UNRESOLVED_KEY = (class$org$apache$jetspeed$i18n$KeyedMessage == null ? (class$org$apache$jetspeed$i18n$KeyedMessage = KeyedMessage.class$("org.apache.jetspeed.i18n.KeyedMessage")) : class$org$apache$jetspeed$i18n$KeyedMessage).getName() + ".<unresolved>";
    private static final HashMap resourceNameMap = new HashMap();
    private String message;
    private String key;
    private Object[] arguments;
    private Class containingClass;
    private boolean resolved;
    static /* synthetic */ Class class$org$apache$jetspeed$i18n$KeyedMessage;
    static /* synthetic */ Class class$java$lang$String;

    protected KeyedMessage(KeyedMessage source, Object[] arguments) {
        this.key = source.getKey();
        this.message = source.message;
        this.resolved = source.resolved;
        this.containingClass = source.containingClass;
        this.arguments = arguments;
    }

    public KeyedMessage(String message) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] elements = e.getStackTrace();
            if (elements.length >= 2) {
                String containingClassName = elements[1].getClassName();
                try {
                    this.containingClass = Thread.currentThread().getContextClassLoader().loadClass(containingClassName);
                }
                catch (ClassNotFoundException e1) {
                    this.key = UNRESOLVED_KEY;
                }
            }
            this.message = message;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourceName() {
        HashMap hashMap = resourceNameMap;
        synchronized (hashMap) {
            return (String)resourceNameMap.get(this.containingClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.key == null) {
            Field[] fields = this.containingClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    if (fields[i].getType() != this.getClass() || !Modifier.isStatic(fields[i].getModifiers()) || fields[i].get(null) != this) continue;
                    this.key = this.containingClass.getName() + "." + fields[i].getName();
                    this.resolved = true;
                    HashMap hashMap = resourceNameMap;
                    synchronized (hashMap) {
                        if (this.getResourceName() == null) {
                            String resourceName = null;
                            try {
                                Field field = this.containingClass.getField(KEYED_MESSAGE_BUNDLE_FIELD_NAME);
                                if (field != null && field.getType() == (class$java$lang$String == null ? (class$java$lang$String = KeyedMessage.class$("java.lang.String")) : class$java$lang$String) && Modifier.isStatic(field.getModifiers())) {
                                    resourceName = (String)field.get(null);
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (resourceName == null) {
                                resourceName = this.containingClass.getName();
                            }
                            resourceNameMap.put(this.containingClass, resourceName);
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.key == null) {
                this.key = UNRESOLVED_KEY;
            }
        }
    }

    private String format(String message) {
        if (this.arguments != null && this.arguments.length > 0) {
            return new MessageFormat(message).format(this.arguments);
        }
        return message;
    }

    protected KeyedMessage create(KeyedMessage source, Object[] arguments) {
        return new KeyedMessage(this, arguments);
    }

    public KeyedMessage create(Object[] arguments) {
        return new KeyedMessage(this, arguments);
    }

    public KeyedMessage create(Object o) {
        return this.create(new Object[]{o});
    }

    public KeyedMessage create(Object o1, Object o2) {
        return this.create(new Object[]{o1, o2});
    }

    public KeyedMessage create(Object o1, Object o2, Object o3) {
        return this.create(new Object[]{o1, o2, o3});
    }

    public final String getKey() {
        this.resolve();
        return this.key;
    }

    public ResourceBundle getBundle(Locale locale) {
        this.resolve();
        if (this.resolved) {
            try {
                return ResourceBundle.getBundle(this.getResourceName(), locale, this.containingClass.getClassLoader());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public ResourceBundle getBundle() {
        return this.getBundle(CurrentLocale.get());
    }

    public String getMessage() {
        return this.getMessage(this.getBundle());
    }

    public String getMessage(ResourceBundle bundle) {
        this.resolve();
        String message = this.message;
        if (this.resolved && bundle != null) {
            try {
                message = bundle.getString(this.key);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.format(message);
    }

    public String getMessage(Locale locale) {
        return this.getMessage(this.getBundle(locale));
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Object getArgument(int index) {
        return this.arguments[index];
    }

    public String toString() {
        return this.getMessage();
    }

    public boolean equals(Object otherObject) {
        if (otherObject != null && otherObject instanceof KeyedMessage) {
            this.resolve();
            return this.resolved && this.key.equals(((KeyedMessage)otherObject).getKey());
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

