/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.ojb;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

public class LocaleFieldConversion
implements FieldConversion {
    private static final String DELIM = ",";

    public Object javaToSql(Object arg0) throws ConversionException {
        if (arg0 instanceof Locale) {
            Locale locale = (Locale)arg0;
            String country = locale.getCountry();
            String language = locale.getLanguage();
            String variant = locale.getVariant();
            StringBuffer buffer = new StringBuffer(40);
            if (language != null) {
                buffer.append(language);
            }
            buffer.append(DELIM);
            if (country != null) {
                buffer.append(country);
            }
            buffer.append(DELIM);
            if (variant != null) {
                buffer.append(variant);
            }
            return buffer.toString().trim();
        }
        return arg0;
    }

    public Object sqlToJava(Object arg0) throws ConversionException {
        if (arg0 instanceof String) {
            String localeString = (String)arg0;
            StringTokenizer tokenizer = new StringTokenizer(localeString, DELIM);
            String language = tokenizer.nextToken().trim();
            String country = null;
            String variant = null;
            if (tokenizer.hasMoreTokens()) {
                country = tokenizer.nextToken().trim();
            }
            if (tokenizer.hasMoreTokens()) {
                variant = tokenizer.nextToken().trim();
            }
            if (country != null && language != null && variant != null) {
                return new Locale(language, country, variant);
            }
            if (country != null && language != null) {
                return new Locale(language, country);
            }
            if (language != null) {
                return new Locale(language, "");
            }
            return JetspeedLocale.getDefaultLocale();
        }
        return arg0;
    }
}

