/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.jetspeed.om.common.MutableLanguage;
import org.apache.jetspeed.util.HashCodeBuilder;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.pluto.om.common.Language;

public class LanguageImpl
implements MutableLanguage,
Serializable {
    public static final String JAVAX_PORTLET_KEYWORDS = "javax.portlet.keywords";
    public static final String JAVAX_PORTLET_SHORT_TITLE = "javax.portlet.short-title";
    public static final String JAVAX_PORTLET_TITLE = "javax.portlet.title";
    private Locale locale;
    private String title;
    private String shortTitle;
    private Collection keywords;
    private ResourceBundle resourceBundle;
    protected long id;
    protected long portletId;

    public LanguageImpl() {
        this(JetspeedLocale.getDefaultLocale(), null, "", "", "");
    }

    public LanguageImpl(Locale locale, String title) {
        this(locale, null, title, "", "");
    }

    public LanguageImpl(Locale locale, ResourceBundle bundle, String defaultTitle, String defaultShortTitle, String defaultKeyWords) {
        HashMap<String, String> defaults = new HashMap<String, String>(3);
        defaults.put(JAVAX_PORTLET_TITLE, defaultTitle);
        defaults.put(JAVAX_PORTLET_SHORT_TITLE, defaultShortTitle);
        defaults.put(JAVAX_PORTLET_KEYWORDS, defaultKeyWords);
        this.resourceBundle = new DefaultsResourceBundle(bundle, defaults);
        this.setLocale(locale);
        this.setTitle(this.getResourceBundle().getString(JAVAX_PORTLET_TITLE));
        this.setShortTitle(this.getResourceBundle().getString(JAVAX_PORTLET_SHORT_TITLE));
        this.setKeywords(this.getResourceBundle().getString(JAVAX_PORTLET_KEYWORDS));
    }

    public LanguageImpl(Locale locale, ResourceBundle bundle) {
        this.resourceBundle = new DefaultsResourceBundle(bundle, new HashMap());
        this.setLocale(locale);
        this.setTitle(this.getResourceBundle().getString(JAVAX_PORTLET_TITLE));
        this.setShortTitle(this.getResourceBundle().getString(JAVAX_PORTLET_SHORT_TITLE));
        this.setKeywords(this.getResourceBundle().getString(JAVAX_PORTLET_KEYWORDS));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = this.resourceBundle.getString(JAVAX_PORTLET_TITLE);
        }
        return this.title;
    }

    public String getShortTitle() {
        if (this.shortTitle == null) {
            this.shortTitle = this.resourceBundle.getString(JAVAX_PORTLET_SHORT_TITLE);
        }
        return this.shortTitle;
    }

    public Iterator getKeywords() {
        if (this.keywords == null) {
            this.setKeywords(this.resourceBundle.getString(JAVAX_PORTLET_KEYWORDS));
        }
        return this.keywords.iterator();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setShortTitle(String title) {
        this.shortTitle = title;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Language) {
            return obj.hashCode() == this.hashCode();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hasher = new HashCodeBuilder(19, 79);
        hasher.append((Object)this.locale.getCountry()).append((Object)this.locale.getLanguage()).append((Object)this.locale.getVariant());
        return hasher.toHashCode();
    }

    public void setKeywords(Collection keywords) {
        this.keywords = keywords;
    }

    public void setKeywords(String keywordStr) {
        if (this.keywords == null) {
            this.keywords = new ArrayList();
        }
        StringTokenizer tok = new StringTokenizer(keywordStr, ",");
        while (tok.hasMoreTokens()) {
            this.keywords.add(tok.nextToken());
        }
    }

    private static class DefaultsResourceBundle
    extends ResourceBundle {
        private ResourceBundle baseBundle;
        private Map defaultValues;

        public DefaultsResourceBundle(ResourceBundle baseBundle, Map defaultValues) {
            this.baseBundle = baseBundle;
            this.defaultValues = defaultValues;
        }

        public Enumeration getKeys() {
            if (this.baseBundle != null) {
                Enumeration<String> baseKeys = this.baseBundle.getKeys();
                HashSet mergedKeys = new HashSet(this.defaultValues.keySet());
                while (baseKeys.hasMoreElements()) {
                    mergedKeys.add(baseKeys.nextElement());
                }
                return Collections.enumeration(mergedKeys);
            }
            return Collections.enumeration(this.defaultValues.keySet());
        }

        protected Object handleGetObject(String key) {
            try {
                if (this.baseBundle != null) {
                    return this.baseBundle.getObject(key);
                }
                return this.getDefaultValue(key);
            }
            catch (MissingResourceException e) {
                return this.getDefaultValue(key);
            }
        }

        protected Object getDefaultValue(String key) {
            Object value = this.defaultValues.get(key);
            if (value != null) {
                return value;
            }
            return "";
        }
    }
}

