/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletregistry;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.components.portletregistry.FailedToStorePortletDefinitionException;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.PortletRegistryHelper;
import org.apache.jetspeed.components.portletregistry.RegistryException;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.om.common.Support;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.om.impl.LanguageImpl;
import org.apache.jetspeed.om.portlet.impl.PortletDefinitionImpl;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.pluto.om.common.Language;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.springframework.dao.DataAccessException;

public class PersistenceBrokerPortletRegistry
extends InitablePersistenceBrokerDaoSupport
implements PortletRegistry {
    static final String PORTLET_UNIQUE_NAME_SEPARATOR = "::";
    static /* synthetic */ Class class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl;

    public PersistenceBrokerPortletRegistry(String repositoryPath) {
        this(repositoryPath, null);
    }

    public PersistenceBrokerPortletRegistry(String repositoryPath, PortletFactory portletFactory) {
        super(repositoryPath);
        PortletDefinitionImpl.setPortletRegistry(this);
        PortletDefinitionImpl.setPortletFactory(portletFactory);
    }

    public Language createLanguage(Locale locale, String title, String shortTitle, String description, Collection keywords) throws RegistryException {
        try {
            LanguageImpl lc = new LanguageImpl();
            lc.setLocale(locale);
            lc.setTitle(title);
            lc.setShortTitle(shortTitle);
            lc.setKeywords(keywords);
            return lc;
        }
        catch (Exception e) {
            throw new RegistryException("Unable to create language object.");
        }
    }

    public Collection getAllPortletDefinitions() {
        Criteria c = new Criteria();
        Collection list = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)(class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl == null ? (class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl = PersistenceBrokerPortletRegistry.class$("org.apache.jetspeed.om.portlet.impl.PortletDefinitionImpl")) : class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl), (Criteria)c));
        this.postLoadColl(list);
        return list;
    }

    public MutablePortletApplication getPortletApplication(ObjectID id) {
        Criteria c = new Criteria();
        c.addEqualTo("id", (Object)new Long(id.toString()));
        MutablePortletApplication app = (MutablePortletApplication)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery((Class)(class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl == null ? (class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl = PersistenceBrokerPortletRegistry.class$("org.apache.jetspeed.om.portlet.impl.PortletApplicationDefinitionImpl")) : class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl), (Criteria)c));
        this.postLoad(app);
        return app;
    }

    public MutablePortletApplication getPortletApplication(String name) {
        Criteria c = new Criteria();
        c.addEqualTo("name", (Object)name);
        MutablePortletApplication app = (MutablePortletApplication)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery((Class)(class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl == null ? (class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl = PersistenceBrokerPortletRegistry.class$("org.apache.jetspeed.om.portlet.impl.PortletApplicationDefinitionImpl")) : class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl), (Criteria)c));
        this.postLoad(app);
        return app;
    }

    public MutablePortletApplication getPortletApplicationByIdentifier(String identifier) {
        Criteria c = new Criteria();
        c.addEqualTo("applicationIdentifier", (Object)identifier);
        MutablePortletApplication app = (MutablePortletApplication)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery((Class)(class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl == null ? (class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl = PersistenceBrokerPortletRegistry.class$("org.apache.jetspeed.om.portlet.impl.PortletApplicationDefinitionImpl")) : class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl), (Criteria)c));
        this.postLoad(app);
        return app;
    }

    public Collection getPortletApplications() {
        Criteria c = new Criteria();
        Collection list = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)(class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl == null ? (class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl = PersistenceBrokerPortletRegistry.class$("org.apache.jetspeed.om.portlet.impl.PortletApplicationDefinitionImpl")) : class$org$apache$jetspeed$om$portlet$impl$PortletApplicationDefinitionImpl), (Criteria)c));
        this.postLoadColl(list);
        return list;
    }

    public PortletDefinitionComposite getPortletDefinitionByIdentifier(String identifier) {
        Criteria c = new Criteria();
        c.addEqualTo("portletIdentifier", (Object)identifier);
        PortletDefinitionComposite def = (PortletDefinitionComposite)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery((Class)(class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl == null ? (class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl = PersistenceBrokerPortletRegistry.class$("org.apache.jetspeed.om.portlet.impl.PortletDefinitionImpl")) : class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl), (Criteria)c));
        if (def != null && def.getPortletApplicationDefinition() == null) {
            String msg = "getPortletDefinitionByIdentifier() returned a PortletDefinition that has no parent PortletApplication.";
            throw new IllegalStateException("getPortletDefinitionByIdentifier() returned a PortletDefinition that has no parent PortletApplication.");
        }
        this.postLoad(def);
        return def;
    }

    public PortletDefinitionComposite getPortletDefinitionByUniqueName(String name) {
        String appName = PortletRegistryHelper.parseAppName(name);
        String portletName = PortletRegistryHelper.parsePortletName(name);
        Criteria c = new Criteria();
        c.addEqualTo("app.name", (Object)appName);
        c.addEqualTo("name", (Object)portletName);
        PortletDefinitionComposite def = (PortletDefinitionComposite)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery((Class)(class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl == null ? (class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl = PersistenceBrokerPortletRegistry.class$("org.apache.jetspeed.om.portlet.impl.PortletDefinitionImpl")) : class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl), (Criteria)c));
        if (def != null && def.getPortletApplicationDefinition() == null) {
            String msg = "getPortletDefinitionByIdentifier() returned a PortletDefinition that has no parent PortletApplication.";
            throw new IllegalStateException("getPortletDefinitionByIdentifier() returned a PortletDefinition that has no parent PortletApplication.");
        }
        this.postLoad(def);
        return def;
    }

    public boolean portletApplicationExists(String appIdentity) {
        return this.getPortletApplicationByIdentifier(appIdentity) != null;
    }

    public boolean namedPortletApplicationExists(String appName) {
        return this.getPortletApplication(appName) != null;
    }

    public boolean portletDefinitionExists(String portletName, MutablePortletApplication app) {
        return this.getPortletDefinitionByUniqueName(app.getName() + PORTLET_UNIQUE_NAME_SEPARATOR + portletName) != null;
    }

    public boolean portletDefinitionExists(String portletIdentity) {
        return this.getPortletDefinitionByIdentifier(portletIdentity) != null;
    }

    public void registerPortletApplication(PortletApplicationDefinition newApp) throws RegistryException {
        this.getPersistenceBrokerTemplate().store((Object)newApp);
    }

    public void removeApplication(PortletApplicationDefinition app) throws RegistryException {
        this.getPersistenceBrokerTemplate().delete((Object)app);
        String appNodePath = "portlet_application/" + ((MutablePortletApplication)app).getName();
        try {
            if (Preferences.systemRoot().nodeExists(appNodePath)) {
                Preferences node = Preferences.systemRoot().node(appNodePath);
                node.removeNode();
            }
        }
        catch (BackingStoreException e) {
            throw new RegistryException(e.toString(), (Throwable)e);
        }
    }

    public void updatePortletApplication(PortletApplicationDefinition app) throws RegistryException {
        this.getPersistenceBrokerTemplate().store((Object)app);
    }

    private void postLoad(Object obj) {
        if (obj != null && obj instanceof Support) {
            try {
                ((Support)obj).postLoad(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void postLoadColl(Collection coll) {
        Iterator itr;
        Object test;
        if (coll != null && !coll.isEmpty() && (test = (itr = coll.iterator()).next()) instanceof Support) {
            Support testSupport = (Support)test;
            try {
                testSupport.postLoad((Object)testSupport);
            }
            catch (Exception e1) {
                // empty catch block
            }
            while (itr.hasNext()) {
                Support support = (Support)itr.next();
                try {
                    support.postLoad((Object)support);
                }
                catch (Exception e) {}
            }
        }
    }

    public void savePortletDefinition(PortletDefinition portlet) throws FailedToStorePortletDefinitionException {
        try {
            this.getPersistenceBrokerTemplate().store((Object)portlet);
        }
        catch (DataAccessException e) {
            throw new FailedToStorePortletDefinitionException(portlet, (Throwable)e);
        }
    }

    public PortletDefinitionComposite getPortletDefinition(ObjectID id) {
        Criteria c = new Criteria();
        c.addEqualTo("id", (Object)new Long(id.toString()));
        PortletDefinitionComposite portlet = (PortletDefinitionComposite)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery((Class)(class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl == null ? (class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl = PersistenceBrokerPortletRegistry.class$("org.apache.jetspeed.om.portlet.impl.PortletDefinitionImpl")) : class$org$apache$jetspeed$om$portlet$impl$PortletDefinitionImpl), (Criteria)c));
        this.postLoad(portlet);
        return portlet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

