/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletentity;

import java.io.IOException;
import java.rmi.server.UID;
import java.util.Collection;
import java.util.Iterator;
import java.util.prefs.BackingStoreException;
import org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent;
import org.apache.jetspeed.components.portletentity.PortletEntityImpl;
import org.apache.jetspeed.components.portletentity.PortletEntityNotDeletedException;
import org.apache.jetspeed.components.portletentity.PortletEntityNotGeneratedException;
import org.apache.jetspeed.components.portletentity.PortletEntityNotStoredException;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.MutablePortletEntity;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.preference.impl.PrefsPreferenceSetImpl;
import org.apache.jetspeed.util.JetspeedObjectID;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.entity.PortletEntityCtrl;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.springframework.orm.ojb.support.PersistenceBrokerDaoSupport;

public class PersistenceBrokerPortletEntityAccess
extends PersistenceBrokerDaoSupport
implements PortletEntityAccessComponent {
    private PortletRegistry registry;
    static /* synthetic */ Class class$org$apache$jetspeed$components$portletentity$PortletEntityImpl;

    public PersistenceBrokerPortletEntityAccess(PortletRegistry registry) {
        this.registry = registry;
        PortletEntityImpl.pac = this;
        PortletEntityImpl.registry = registry;
    }

    public MutablePortletEntity generateEntityFromFragment(ContentFragment fragment, String principal) throws PortletEntityNotGeneratedException {
        PortletDefinitionComposite pd = this.registry.getPortletDefinitionByUniqueName(fragment.getName());
        ObjectID entityKey = this.generateEntityKey((Fragment)fragment, principal);
        MutablePortletEntity portletEntity = null;
        if (pd != null) {
            portletEntity = this.newPortletEntityInstance((PortletDefinition)pd);
            if (portletEntity == null) {
                throw new PortletEntityNotGeneratedException("Failed to create Portlet Entity for " + fragment.getName());
            }
        } else {
            String msg = "Failed to retrieve Portlet Definition for " + fragment.getName();
            this.logger.warn((Object)msg);
            portletEntity = new PortletEntityImpl((Fragment)fragment);
            fragment.overrideRenderedContent(msg);
        }
        portletEntity.setId(entityKey.toString());
        return portletEntity;
    }

    public MutablePortletEntity generateEntityFromFragment(ContentFragment fragment) throws PortletEntityNotGeneratedException {
        return this.generateEntityFromFragment(fragment, null);
    }

    public ObjectID generateEntityKey(Fragment fragment, String principal) {
        StringBuffer key = new StringBuffer();
        if (principal != null && principal.length() > 0) {
            key.append(principal);
            key.append("/");
        }
        key.append(fragment.getId());
        return JetspeedObjectID.createFromString((String)key.toString());
    }

    public Collection getPortletEntities(PortletDefinition portletDefinition) {
        Criteria c = new Criteria();
        String appName = ((MutablePortletApplication)portletDefinition.getPortletApplicationDefinition()).getName();
        String portletName = portletDefinition.getName();
        c.addEqualTo("appName", (Object)appName);
        c.addEqualTo("portletName", (Object)portletName);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)(class$org$apache$jetspeed$components$portletentity$PortletEntityImpl == null ? (class$org$apache$jetspeed$components$portletentity$PortletEntityImpl = PersistenceBrokerPortletEntityAccess.class$("org.apache.jetspeed.components.portletentity.PortletEntityImpl")) : class$org$apache$jetspeed$components$portletentity$PortletEntityImpl), (Criteria)c));
    }

    public Collection getPortletEntities(String portletUniqueName) {
        String[] split = portletUniqueName.split("::");
        String appName = split[0];
        String portletName = split[1];
        Criteria c = new Criteria();
        c.addEqualTo("appName", (Object)appName);
        c.addEqualTo("portletName", (Object)portletName);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)(class$org$apache$jetspeed$components$portletentity$PortletEntityImpl == null ? (class$org$apache$jetspeed$components$portletentity$PortletEntityImpl = PersistenceBrokerPortletEntityAccess.class$("org.apache.jetspeed.components.portletentity.PortletEntityImpl")) : class$org$apache$jetspeed$components$portletentity$PortletEntityImpl), (Criteria)c));
    }

    public MutablePortletEntity getPortletEntity(ObjectID id) {
        try {
            return this.getPortletEntity(id, null);
        }
        catch (PortletEntityNotStoredException e) {
            IllegalStateException ise = new IllegalStateException("Unexepected error while retrieving portlet entity " + id);
            ise.initCause(e);
            throw ise;
        }
    }

    protected MutablePortletEntity getPortletEntity(ObjectID id, ContentFragment fragment) throws PortletEntityNotStoredException {
        Criteria c = new Criteria();
        c.addEqualTo("id", (Object)id.toString());
        QueryByCriteria q = QueryFactory.newQuery((Class)(class$org$apache$jetspeed$components$portletentity$PortletEntityImpl == null ? (class$org$apache$jetspeed$components$portletentity$PortletEntityImpl = PersistenceBrokerPortletEntityAccess.class$("org.apache.jetspeed.components.portletentity.PortletEntityImpl")) : class$org$apache$jetspeed$components$portletentity$PortletEntityImpl), (Criteria)c);
        MutablePortletEntity portletEntity = (MutablePortletEntity)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)q);
        if (portletEntity == null) {
            return null;
        }
        String portletUniqueName = portletEntity.getPortletUniqueName();
        PortletDefinitionComposite parentPortletDef = this.registry.getPortletDefinitionByUniqueName(portletUniqueName);
        if (parentPortletDef != null) {
            if (fragment != null && !portletUniqueName.equals(fragment.getName())) {
                parentPortletDef = this.registry.getPortletDefinitionByUniqueName(fragment.getName());
                portletEntity.setPortletDefinition((PortletDefinition)parentPortletDef);
                this.storePortletEntity((PortletEntity)portletEntity);
            } else {
                portletEntity.setPortletDefinition((PortletDefinition)parentPortletDef);
            }
        } else if (fragment != null && parentPortletDef == null) {
            parentPortletDef = this.registry.getPortletDefinitionByUniqueName(fragment.getName());
            portletEntity.setPortletDefinition((PortletDefinition)parentPortletDef);
            this.storePortletEntity((PortletEntity)portletEntity);
        }
        if (parentPortletDef == null) {
            String msg = "No parent portlet definition could be located using unique name: " + portletUniqueName + ".  Unless you plan on redploying this portlet definition, it is highly recommended " + "that you delete the orphaned portlet entity with the id: " + portletEntity.getId();
            fragment.overrideRenderedContent(msg);
            this.logger.warn((Object)msg);
        }
        return portletEntity;
    }

    public MutablePortletEntity getPortletEntity(String id) {
        JetspeedObjectID oid = JetspeedObjectID.createFromString((String)id);
        return this.getPortletEntity((ObjectID)oid);
    }

    public MutablePortletEntity getPortletEntityForFragment(ContentFragment fragment, String principal) throws PortletEntityNotStoredException {
        return this.getPortletEntity(this.generateEntityKey((Fragment)fragment, principal), fragment);
    }

    public MutablePortletEntity getPortletEntityForFragment(ContentFragment fragment) throws PortletEntityNotStoredException {
        return this.getPortletEntity(this.generateEntityKey((Fragment)fragment, null), fragment);
    }

    public MutablePortletEntity newPortletEntityInstance(PortletDefinition portletDefinition) {
        return this.newPortletEntityInstance(portletDefinition, this.autoGenerateID(portletDefinition));
    }

    public MutablePortletEntity newPortletEntityInstance(PortletDefinition portletDefinition, String id) {
        PortletEntityImpl portletEntity = new PortletEntityImpl();
        portletEntity.setPortletDefinition(portletDefinition);
        portletEntity.setId(id);
        return portletEntity;
    }

    public void removeFromCache(PortletEntity entity) {
    }

    public void removePortletEntities(PortletDefinition portletDefinition) throws PortletEntityNotDeletedException {
        Iterator entities = this.getPortletEntities(portletDefinition).iterator();
        while (entities.hasNext()) {
            PortletEntity entity = (PortletEntity)entities.next();
            this.removePortletEntity(entity);
        }
    }

    public void removePortletEntity(PortletEntity portletEntity) throws PortletEntityNotDeletedException {
        PrefsPreferenceSetImpl prefsSet = (PrefsPreferenceSetImpl)portletEntity.getPreferenceSet();
        this.getPersistenceBrokerTemplate().delete((Object)portletEntity);
        try {
            prefsSet.clear();
        }
        catch (BackingStoreException e) {
            throw new PortletEntityNotDeletedException("Failed to remove preferences for portlet entity " + portletEntity.getId() + ".  " + e.getMessage(), (Throwable)e);
        }
    }

    public void storePortletEntity(PortletEntity portletEntity) throws PortletEntityNotStoredException {
        try {
            ((PortletEntityCtrl)portletEntity).store();
        }
        catch (Exception e) {
            throw new PortletEntityNotStoredException(e.toString(), (Throwable)e);
        }
    }

    public void storePreferenceSet(PreferenceSet prefSet, PortletEntity entity) throws IOException {
        PrefsPreferenceSetImpl preferenceSet = (PrefsPreferenceSetImpl)prefSet;
        try {
            this.getPersistenceBrokerTemplate().store((Object)entity);
            if (preferenceSet != null) {
                preferenceSet.flush();
            }
        }
        catch (Exception e) {
            String msg = "Failed to store portlet entity:" + e.toString();
            IOException ioe = new IOException(msg);
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected String autoGenerateID(PortletDefinition pd) {
        String appName = ((MutablePortletApplication)pd.getPortletApplicationDefinition()).getName();
        String portletName = pd.getName();
        return appName + "::" + portletName + "::" + new UID().toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

