/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.scheduler;

import java.util.Vector;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.scheduler.AbstractScheduler;
import org.apache.jetspeed.scheduler.JobEntry;
import org.apache.jetspeed.scheduler.JobQueue;
import org.apache.jetspeed.scheduler.Scheduler;

public class MemoryBasedScheduler
extends AbstractScheduler
implements Scheduler {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$scheduler$MemoryBasedScheduler == null ? (class$org$apache$jetspeed$scheduler$MemoryBasedScheduler = MemoryBasedScheduler.class$("org.apache.jetspeed.scheduler.MemoryBasedScheduler")) : class$org$apache$jetspeed$scheduler$MemoryBasedScheduler));
    private Configuration config;
    static /* synthetic */ Class class$org$apache$jetspeed$scheduler$MemoryBasedScheduler;

    public MemoryBasedScheduler(Configuration config) throws Exception {
        this.config = config;
    }

    private Configuration getConfiguration() {
        return this.config;
    }

    public void start() {
        try {
            super.start();
            this.scheduleQueue = new JobQueue();
            this.mainLoop = new AbstractScheduler.MainLoop(this);
            Vector jobProps = this.getConfiguration().getVector("jobs");
            Vector<JobEntry> jobs = new Vector<JobEntry>();
            if (!jobProps.isEmpty()) {
                for (int i = 0; i < jobProps.size(); ++i) {
                    String jobName = (String)jobProps.elementAt(i);
                    String jobPrefix = "job." + jobName;
                    if (this.getConfiguration().getString(jobPrefix + ".ID", null) == null) {
                        throw new Exception("There is an error in the properties file. \n" + jobPrefix + ".ID is not found.\n");
                    }
                    int sec = this.getConfiguration().getInt(jobPrefix + ".SECOND", -1);
                    int min = this.getConfiguration().getInt(jobPrefix + ".MINUTE", -1);
                    int hr = this.getConfiguration().getInt(jobPrefix + ".HOUR", -1);
                    int wkday = this.getConfiguration().getInt(jobPrefix + ".WEEKDAY", -1);
                    int dayOfMonth = this.getConfiguration().getInt(jobPrefix + ".DAY_OF_MONTH", -1);
                    JobEntry je = new JobEntry(sec, min, hr, wkday, dayOfMonth, jobName);
                    jobs.addElement(je);
                }
            }
            if (jobs != null && jobs.size() > 0) {
                System.out.println("Starting jobs = " + jobs.size());
                this.scheduleQueue.batchLoad(jobs);
                this.restart();
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot initialize SchedulerService!: ", (Throwable)e);
        }
    }

    public void stop() {
        super.stop();
    }

    public JobEntry getJob(int oid) throws Exception {
        JobEntry je = new JobEntry(-1, -1, -1, -1, -1, null);
        return this.scheduleQueue.getJob(je);
    }

    public void addJob(JobEntry je) throws Exception {
        this.scheduleQueue.add(je);
        this.restart();
    }

    public void removeJob(JobEntry je) throws Exception {
        this.scheduleQueue.remove(je);
        this.restart();
    }

    public void updateJob(JobEntry je) throws Exception {
        try {
            je.calcRunTime();
        }
        catch (Exception e) {
            log.error((Object)("Problem updating Scheduled Job: " + e));
        }
        this.scheduleQueue.modify(je);
        this.restart();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

