/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.scheduler;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.scheduler.JobEntry;
import org.apache.jetspeed.scheduler.JobQueue;
import org.apache.jetspeed.scheduler.Scheduler;
import org.apache.jetspeed.scheduler.WorkerThread;

public abstract class AbstractScheduler
implements Scheduler {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$scheduler$MemoryBasedScheduler == null ? (class$org$apache$jetspeed$scheduler$MemoryBasedScheduler = AbstractScheduler.class$("org.apache.jetspeed.scheduler.MemoryBasedScheduler")) : class$org$apache$jetspeed$scheduler$MemoryBasedScheduler));
    protected JobQueue scheduleQueue = null;
    protected MainLoop mainLoop = null;
    protected Thread thread = null;
    static /* synthetic */ Class class$org$apache$jetspeed$scheduler$MemoryBasedScheduler;

    public void start() {
    }

    public void stop() {
        if (this.getThread() != null) {
            this.getThread().interrupt();
        }
    }

    public abstract JobEntry getJob(int var1) throws Exception;

    public abstract void addJob(JobEntry var1) throws Exception;

    public abstract void removeJob(JobEntry var1) throws Exception;

    public abstract void updateJob(JobEntry var1) throws Exception;

    public List listJobs() {
        return this.scheduleQueue.list();
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    private synchronized void clearThread() {
        this.thread = null;
    }

    public synchronized void restart() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this.mainLoop, "scheduler");
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.notify();
        }
    }

    private synchronized JobEntry nextJob() throws Exception {
        try {
            while (!Thread.interrupted()) {
                JobEntry je = this.scheduleQueue.getNext();
                if (je == null) {
                    this.wait();
                    continue;
                }
                long now = System.currentTimeMillis();
                long when = je.getNextRuntime();
                if (when > now) {
                    this.wait(when - now);
                    continue;
                }
                this.scheduleQueue.updateQueue(je);
                return je;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class MainLoop
    implements Runnable {
        protected MainLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                JobEntry je;
                while ((je = AbstractScheduler.this.nextJob()) != null) {
                    WorkerThread wt = new WorkerThread(je);
                    Thread helper = new Thread(wt);
                    helper.start();
                }
            }
            catch (Exception e) {
                log.error((Object)("Error running a Scheduled Job: " + e));
            }
            finally {
                AbstractScheduler.this.clearThread();
            }
        }
    }
}

