/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo.jdoql;

import org.apache.ojb.jdo.jdoql.Expression;
import org.apache.ojb.jdo.jdoql.Visitor;

public class BinaryExpression
extends Expression {
    public static final int OPERATOR_MULTIPLY = 0;
    public static final int OPERATOR_DIVIDE = 1;
    public static final int OPERATOR_PLUS = 2;
    public static final int OPERATOR_MINUS = 3;
    public static final int OPERATOR_LOWER = 4;
    public static final int OPERATOR_GREATER = 5;
    public static final int OPERATOR_LOWER_OR_EQUAL = 6;
    public static final int OPERATOR_GREATER_OR_EQUAL = 7;
    public static final int OPERATOR_EQUAL = 8;
    public static final int OPERATOR_NOT_EQUAL = 9;
    public static final int OPERATOR_BITWISE_AND = 10;
    public static final int OPERATOR_BITWISE_XOR = 11;
    public static final int OPERATOR_BITWISE_OR = 12;
    public static final int OPERATOR_AND = 13;
    public static final int OPERATOR_OR = 14;
    private Expression _left;
    private int _operator;
    private Expression _right;
    private Class _type;

    public BinaryExpression(Expression left, int operator, Expression right) {
        this._left = left;
        this._operator = operator;
        this._right = right;
    }

    public Expression getLeftSide() {
        return this._left;
    }

    public int getOperator() {
        return this._operator;
    }

    public Expression getRightSide() {
        return this._right;
    }

    public void replaceChild(Expression oldChild, Expression newChild) {
        if (oldChild == this._left) {
            this._left.setParent(null);
            this._left = newChild;
            this._left.setParent(this);
        } else if (oldChild == this._right) {
            this._right.setParent(null);
            this._right = newChild;
            this._right.setParent(this);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(");
        result.append(this._left.toString());
        result.append(" ");
        switch (this._operator) {
            case 0: {
                result.append("* ");
                break;
            }
            case 1: {
                result.append("/ ");
                break;
            }
            case 2: {
                result.append("+ ");
                break;
            }
            case 3: {
                result.append("- ");
                break;
            }
            case 4: {
                result.append("< ");
                break;
            }
            case 5: {
                result.append("> ");
                break;
            }
            case 6: {
                result.append("<= ");
                break;
            }
            case 7: {
                result.append(">= ");
                break;
            }
            case 8: {
                result.append("== ");
                break;
            }
            case 9: {
                result.append("!= ");
                break;
            }
            case 10: {
                result.append("& ");
                break;
            }
            case 11: {
                result.append("^ ");
                break;
            }
            case 12: {
                result.append("| ");
                break;
            }
            case 13: {
                result.append("&& ");
                break;
            }
            case 14: {
                result.append("|| ");
            }
        }
        result.append(this._right.toString());
        result.append(")");
        return result.toString();
    }

    public void setType(Class type) {
        this._type = type;
    }

    public Class getType() {
        return this._type;
    }
}

