/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class WrappedConnection
implements Connection {
    private Connection _conn = null;
    private boolean _isClosed = false;

    public WrappedConnection(Connection c) {
        this._conn = c;
    }

    public Connection getDelegate() {
        return this._conn;
    }

    public Connection getInnermostDelegate() {
        Connection c = this._conn;
        while (c != null && c instanceof WrappedConnection) {
            if (this != (c = ((WrappedConnection)c).getDelegate())) continue;
            return null;
        }
        return c;
    }

    public void setDelegate(Connection c) {
        this._conn = c;
    }

    protected void checkOpen() throws SQLException {
        if (this._isClosed) {
            throw new SQLException("Connection is closed. " + this);
        }
    }

    public void activateConnection() {
        this._isClosed = false;
        if (this._conn instanceof WrappedConnection) {
            ((WrappedConnection)this._conn).activateConnection();
        }
    }

    public void passivateConnection() throws SQLException {
        this._isClosed = true;
        if (this._conn instanceof WrappedConnection) {
            ((WrappedConnection)this._conn).passivateConnection();
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("wrapped connection", this._conn != null ? this._conn.toString() : null).toString();
    }

    public void close() throws SQLException {
        this.passivateConnection();
        this._conn.close();
    }

    public boolean isClosed() throws SQLException {
        return this._isClosed || this._conn.isClosed();
    }

    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return this._conn.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return this._conn.createStatement(resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkOpen();
        return this._conn.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return this._conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this._conn.clearWarnings();
    }

    public void commit() throws SQLException {
        this.checkOpen();
        this._conn.commit();
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this._conn.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this._conn.getCatalog();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this._conn.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this._conn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.checkOpen();
        return this._conn.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this._conn.getWarnings();
    }

    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this._conn.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return this._conn.nativeSQL(sql);
    }

    public void rollback() throws SQLException {
        this.checkOpen();
        this._conn.rollback();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        this._conn.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        this._conn.setCatalog(catalog);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        this._conn.setReadOnly(readOnly);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        this._conn.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkOpen();
        this._conn.setTypeMap(map);
    }

    public int getHoldability() throws SQLException {
        this.checkOpen();
        return this._conn.getHoldability();
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        this._conn.setHoldability(holdability);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        return this._conn.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkOpen();
        return this._conn.setSavepoint(name);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this._conn.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this._conn.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        return this._conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        return this._conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(sql, columnNames);
    }
}

