/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.Oracle9iLobHandler;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformOracleImpl;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PlatformOracle9iImpl
extends PlatformOracleImpl {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$platforms$PlatformOracle9iImpl == null ? (class$org$apache$ojb$broker$platforms$PlatformOracle9iImpl = PlatformOracle9iImpl.class$("org.apache.ojb.broker.platforms.PlatformOracle9iImpl")) : class$org$apache$ojb$broker$platforms$PlatformOracle9iImpl);
    protected static final int STATEMENT_CACHE_SIZE = 10;
    protected static final int ROW_PREFETCH_SIZE = 10;
    protected static final int STATEMENTS_PER_BATCH = 20;
    protected static Map m_batchStatementsInProgress = Collections.synchronizedMap(new WeakHashMap(20));
    protected static final Class[] PARAM_TYPE_EMPTY = new Class[0];
    protected static final Class[] PARAM_TYPE_INTEGER = new Class[]{Integer.TYPE};
    protected static final Class[] PARAM_TYPE_BOOLEAN = new Class[]{Boolean.TYPE};
    protected static final Class[] PARAM_TYPE_STRING = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PlatformOracle9iImpl.class$("java.lang.String")) : class$java$lang$String};
    protected static final Object[] PARAM_EMPTY = new Object[0];
    protected static final Object[] PARAM_STATEMENT_CACHE_SIZE = new Object[]{new Integer(10)};
    protected static final Object[] PARAM_ROW_PREFETCH_SIZE = new Object[]{new Integer(10)};
    protected static final Object[] PARAM_STATEMENT_BATCH_SIZE = new Object[]{new Integer(20)};
    protected static final Object[] PARAM_BOOLEAN_TRUE = new Object[]{Boolean.TRUE};
    protected static final String JBOSS_CONN_NAME = "org.jboss.resource.adapter.jdbc.WrappedConnection";
    protected static Class JBOSS_CONN_CLASS = null;
    protected static Class ORA_CONN_CLASS;
    protected static Class ORA_PS_CLASS;
    protected static Class ORA_CLOB_CLASS;
    protected static Class ORA_BLOB_CLASS;
    protected static Class[] PARAM_TYPE_INT_ORACLOB;
    protected static Class[] PARAM_TYPE_INT_ORABLOB;
    protected static Method METHOD_SET_STATEMENT_CACHE_SIZE;
    protected static Method METHOD_SET_IMPLICIT_CACHING_ENABLED;
    protected static Method METHOD_SET_ROW_PREFETCH;
    protected static Method METHOD_SET_BLOB;
    protected static Method METHOD_SET_CLOB;
    protected static boolean ORA_STATEMENT_CACHING_AVAILABLE;
    protected static boolean ORA_ROW_PREFETCH_AVAILABLE;
    protected static boolean ORA_CLOB_HANDLING_AVAILABLE;
    protected static boolean ORA_BLOB_HANDLING_AVAILABLE;
    protected static final String[] UNWRAP_CONN_METHOD_NAMES;
    protected static final Class[][] UNWRAP_CONN_PARAM_TYPES;
    protected static final String[] UNWRAP_PS_METHOD_NAMES;
    protected static final Class[][] UNWRAP_PS_PARAM_TYPES;
    static /* synthetic */ Class class$org$apache$ojb$broker$platforms$PlatformOracle9iImpl;
    static /* synthetic */ Class class$java$lang$String;

    public PlatformOracle9iImpl() {
        PlatformOracle9iImpl.initOracleReflectedVars();
    }

    public void initializeJdbcConnection(JdbcConnectionDescriptor jcd, Connection conn) throws PlatformException {
        block10: {
            Connection oraConn;
            Class<?> connClass;
            block9: {
                super.initializeJdbcConnection(jcd, conn);
                connClass = conn.getClass();
                if (JBOSS_CONN_CLASS != null && JBOSS_CONN_CLASS.isAssignableFrom(connClass)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("JBoss detected, Oracle Connection tuning left to J2EE container.");
                    }
                    return;
                }
                oraConn = this.unwrapConnection(conn);
                if (oraConn == null) {
                    return;
                }
                if (ORA_STATEMENT_CACHING_AVAILABLE) {
                    try {
                        METHOD_SET_STATEMENT_CACHE_SIZE.invoke((Object)oraConn, PARAM_STATEMENT_CACHE_SIZE);
                        METHOD_SET_IMPLICIT_CACHING_ENABLED.invoke((Object)oraConn, PARAM_BOOLEAN_TRUE);
                    }
                    catch (Exception e) {
                        if (!this.logger.isDebugEnabled()) break block9;
                        this.logger.debug("PlatformOracle9iImpl could not enable Oracle statement caching. Original/unwrapped connection classes=" + connClass.getName() + "/" + oraConn.getClass().getName());
                    }
                }
            }
            if (ORA_ROW_PREFETCH_AVAILABLE) {
                try {
                    METHOD_SET_ROW_PREFETCH.invoke((Object)oraConn, PARAM_ROW_PREFETCH_SIZE);
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block10;
                    this.logger.debug("PlatformOracle9iImpl could not enable Oracle row pre-fetching.Original/unwrapped connection classes=" + connClass.getName() + "/" + oraConn.getClass().getName());
                }
            }
        }
    }

    public void afterStatementCreate(Statement stmt) {
    }

    public void beforeBatch(PreparedStatement stmt) throws PlatformException {
        boolean statementBatchingSupported;
        Method methodSetExecuteBatch = ClassHelper.getMethod(stmt, "setExecuteBatch", PARAM_TYPE_INTEGER);
        Method methodSendBatch = ClassHelper.getMethod(stmt, "sendBatch", null);
        boolean bl = statementBatchingSupported = methodSetExecuteBatch != null && methodSendBatch != null;
        if (statementBatchingSupported) {
            try {
                methodSetExecuteBatch.invoke((Object)stmt, PARAM_STATEMENT_BATCH_SIZE);
                m_batchStatementsInProgress.put(stmt, methodSendBatch);
            }
            catch (Exception e) {
                throw new PlatformException(e.getLocalizedMessage(), e);
            }
        } else {
            super.beforeBatch(stmt);
        }
    }

    public void addBatch(PreparedStatement stmt) throws PlatformException {
        boolean statementBatchingSupported = m_batchStatementsInProgress.containsKey(stmt);
        if (statementBatchingSupported) {
            try {
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new PlatformException(e.getLocalizedMessage(), e);
            }
        } else {
            super.addBatch(stmt);
        }
    }

    public int[] executeBatch(PreparedStatement stmt) throws PlatformException {
        Method methodSendBatch = (Method)m_batchStatementsInProgress.remove(stmt);
        boolean statementBatchingSupported = methodSendBatch != null;
        int[] retval = null;
        if (statementBatchingSupported) {
            try {
                methodSendBatch.invoke((Object)stmt, null);
            }
            catch (Exception e) {
                throw new PlatformException(e.getLocalizedMessage(), e);
            }
        } else {
            retval = super.executeBatch(stmt);
        }
        return retval;
    }

    public void setObjectForStatement(PreparedStatement ps, int index, Object value, int sqlType) throws SQLException {
        boolean oraLargeLobSupportAvailable;
        Connection oraConn;
        Statement oraStmt;
        if (sqlType == 2005 || sqlType == 2004) {
            oraStmt = this.unwrapStatement(ps);
            oraConn = this.unwrapConnection(ps.getConnection());
            oraLargeLobSupportAvailable = oraStmt != null && oraConn != null && (sqlType == 2005 ? ORA_CLOB_HANDLING_AVAILABLE : ORA_BLOB_HANDLING_AVAILABLE);
        } else {
            oraStmt = null;
            oraConn = null;
            oraLargeLobSupportAvailable = false;
        }
        if ((sqlType == -3 || sqlType == -4) && value instanceof byte[]) {
            byte[] buf = (byte[])value;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buf);
            super.changePreparedStatementResultSetType(ps);
            ps.setBinaryStream(index, (InputStream)inputStream, buf.length);
        } else if (value instanceof Double) {
            ps.setDouble(index, (Double)value);
        } else if (sqlType == -5 && value instanceof Integer) {
            ps.setLong(index, ((Integer)value).intValue());
        } else if (sqlType == 4 && value instanceof Long) {
            ps.setLong(index, (Long)value);
        } else if (sqlType == 2005 && oraLargeLobSupportAvailable && value instanceof String) {
            try {
                Object clob = Oracle9iLobHandler.createCLOBFromString(oraConn, (String)value);
                METHOD_SET_CLOB.invoke((Object)oraStmt, new Integer(index), clob);
            }
            catch (Exception e) {
                throw new SQLException(e.getLocalizedMessage());
            }
        } else if (sqlType == 2004 && oraLargeLobSupportAvailable && value instanceof byte[]) {
            try {
                Object blob = Oracle9iLobHandler.createBLOBFromByteArray(oraConn, (byte[])value);
                METHOD_SET_BLOB.invoke((Object)oraStmt, new Integer(index), blob);
            }
            catch (Exception e) {
                throw new SQLException(e.getLocalizedMessage());
            }
        } else {
            super.setObjectForStatement(ps, index, value, sqlType);
        }
    }

    public byte getJoinSyntaxType() {
        return 1;
    }

    protected Connection unwrapConnection(Connection conn) {
        Object unwrapped = this.genericUnwrap(ORA_CONN_CLASS, conn, UNWRAP_CONN_METHOD_NAMES, UNWRAP_CONN_PARAM_TYPES);
        if (unwrapped == null && this.logger.isDebugEnabled()) {
            this.logger.debug("PlatformOracle9iImpl could not unwrap " + conn.getClass().getName() + ", Oracle-extensions disabled.");
        }
        return (Connection)unwrapped;
    }

    protected Statement unwrapStatement(Statement ps) {
        Object unwrapped = this.genericUnwrap(ORA_PS_CLASS, ps, UNWRAP_PS_METHOD_NAMES, UNWRAP_PS_PARAM_TYPES);
        if (unwrapped == null && this.logger.isDebugEnabled()) {
            this.logger.debug("PlatformOracle9iImpl could not unwrap " + ps.getClass().getName() + ", large CLOB/BLOB support disabled.");
        }
        return (Statement)unwrapped;
    }

    protected Object genericUnwrap(Class classToMatch, Object toUnwrap, String[] methodNameCandidates, Class[][] methodTypeCandidates) {
        block8: {
            if (classToMatch == null) {
                return null;
            }
            Class<?> psClass = toUnwrap.getClass();
            if (classToMatch.isAssignableFrom(psClass)) {
                return toUnwrap;
            }
            try {
                for (int i = 0; i < methodNameCandidates.length; ++i) {
                    Object[] objectArray;
                    String methodName = methodNameCandidates[i];
                    Class[] paramTypes = methodTypeCandidates[i];
                    Method method = ClassHelper.getMethod(toUnwrap, methodName, paramTypes);
                    if (method == null) continue;
                    if (paramTypes == PARAM_TYPE_EMPTY) {
                        objectArray = PARAM_EMPTY;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = toUnwrap;
                    }
                    Object[] args = objectArray;
                    Object unwrapped = method.invoke(toUnwrap, args);
                    if (unwrapped == null) continue;
                    if (classToMatch.isAssignableFrom(unwrapped.getClass())) {
                        return unwrapped;
                    }
                    return this.genericUnwrap(classToMatch, unwrapped, methodNameCandidates, methodTypeCandidates);
                }
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block8;
                this.logger.debug("genericUnwrap failed", e);
            }
        }
        return null;
    }

    protected static void initOracleReflectedVars() {
        try {
            ORA_CONN_CLASS = ClassHelper.getClass("oracle.jdbc.OracleConnection", false);
            ORA_PS_CLASS = ClassHelper.getClass("oracle.jdbc.OraclePreparedStatement", false);
            ORA_CLOB_CLASS = ClassHelper.getClass("oracle.sql.CLOB", false);
            ORA_BLOB_CLASS = ClassHelper.getClass("oracle.sql.BLOB", false);
            PARAM_TYPE_INT_ORACLOB = new Class[]{Integer.TYPE, ORA_CLOB_CLASS};
            PARAM_TYPE_INT_ORABLOB = new Class[]{Integer.TYPE, ORA_BLOB_CLASS};
            PlatformOracle9iImpl.UNWRAP_CONN_PARAM_TYPES[0] = new Class[]{ORA_CONN_CLASS};
            METHOD_SET_STATEMENT_CACHE_SIZE = ClassHelper.getMethod(ORA_CONN_CLASS, "setStatementCacheSize", PARAM_TYPE_INTEGER);
            METHOD_SET_IMPLICIT_CACHING_ENABLED = ClassHelper.getMethod(ORA_CONN_CLASS, "setImplicitCachingEnabled", PARAM_TYPE_BOOLEAN);
            METHOD_SET_ROW_PREFETCH = ClassHelper.getMethod(ORA_CONN_CLASS, "setDefaultRowPrefetch", PARAM_TYPE_INTEGER);
            METHOD_SET_CLOB = ClassHelper.getMethod(ORA_PS_CLASS, "setCLOB", PARAM_TYPE_INT_ORACLOB);
            METHOD_SET_BLOB = ClassHelper.getMethod(ORA_PS_CLASS, "setBLOB", PARAM_TYPE_INT_ORABLOB);
            ORA_STATEMENT_CACHING_AVAILABLE = METHOD_SET_STATEMENT_CACHE_SIZE != null && METHOD_SET_IMPLICIT_CACHING_ENABLED != null;
            ORA_ROW_PREFETCH_AVAILABLE = METHOD_SET_ROW_PREFETCH != null;
            ORA_CLOB_HANDLING_AVAILABLE = METHOD_SET_CLOB != null;
            ORA_BLOB_HANDLING_AVAILABLE = METHOD_SET_BLOB != null;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            JBOSS_CONN_CLASS = ClassHelper.getClass(JBOSS_CONN_NAME, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        METHOD_SET_BLOB = null;
        METHOD_SET_CLOB = null;
        UNWRAP_CONN_METHOD_NAMES = new String[]{"unwrapCompletely", "getInnermostDelegate", "getUnderlyingConnection", "getVendorConnection", "getJDBC"};
        UNWRAP_CONN_PARAM_TYPES = new Class[][]{null, PARAM_TYPE_EMPTY, PARAM_TYPE_EMPTY, PARAM_TYPE_EMPTY, PARAM_TYPE_EMPTY};
        UNWRAP_PS_METHOD_NAMES = new String[]{"getInnermostDelegate", "getUnderlyingStatement", "getJDBC"};
        UNWRAP_PS_PARAM_TYPES = new Class[][]{PARAM_TYPE_EMPTY, PARAM_TYPE_EMPTY, PARAM_TYPE_EMPTY};
    }
}

