/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import org.apache.commons.beanutils.DynaBean;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldBase;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistentFieldDynaBeanImplNew
extends PersistentFieldBase {
    private static final long serialVersionUID = 4728858060905429509L;

    public PersistentFieldDynaBeanImplNew() {
    }

    public PersistentFieldDynaBeanImplNew(Class aPropertyType, String aPropertyName) {
        super(aPropertyType, aPropertyName);
        this.checkNested(aPropertyName);
    }

    public void set(Object anObject, Object aValue) throws MetadataException {
        if (anObject == null) {
            return;
        }
        if (anObject instanceof DynaBean) {
            DynaBean dynaBean = (DynaBean)anObject;
            try {
                dynaBean.set(this.getName(), aValue);
            }
            catch (Throwable t) {
                String msg = dynaBean.getClass().getName();
                this.logSetProblem(anObject, aValue, msg);
                throw new PersistenceBrokerException(t);
            }
        } else {
            String msg = "the object is not a DynaBean";
            this.logSetProblem(anObject, aValue, msg);
            throw new PersistenceBrokerException(msg);
        }
    }

    public Object get(Object anObject) throws MetadataException {
        if (anObject == null) {
            return null;
        }
        if (anObject instanceof DynaBean) {
            DynaBean dynaBean = (DynaBean)anObject;
            try {
                return dynaBean.get(this.getName());
            }
            catch (Throwable t) {
                String msg = dynaBean.getClass().getName();
                this.logGetProblem(anObject, msg);
                throw new PersistenceBrokerException(t);
            }
        }
        String msg = "the object is not a DynaBean";
        this.logGetProblem(anObject, msg);
        throw new PersistenceBrokerException(msg);
    }

    private void checkNested(String fieldName) {
        if (fieldName.indexOf("::") > -1) {
            throw new MetadataException("This implementation does not support nested fields");
        }
    }

    public Class getType() {
        return this.getDeclaringClass();
    }

    protected boolean makeAccessible() {
        return false;
    }

    public boolean usesAccessorsAndMutators() {
        return false;
    }

    protected void logSetProblem(Object anObject, Object aValue, String msg) {
        Logger logger = LoggerFactory.getDefaultLogger();
        logger.error("Error in operation [set] of object [" + this.getClass().getName() + "], " + msg);
        logger.error("Property Name [" + this.getName() + "]");
        if (anObject instanceof DynaBean) {
            DynaBean dynaBean = (DynaBean)anObject;
            logger.error("anObject was DynaClass [" + dynaBean.getDynaClass().getName() + "]");
        } else if (anObject != null) {
            logger.error("anObject was class [" + anObject.getClass().getName() + "]");
        } else {
            logger.error("anObject was null");
        }
        if (aValue != null) {
            logger.error("aValue was class [" + aValue.getClass().getName() + "]");
        } else {
            logger.error("aValue was null");
        }
    }

    protected void logGetProblem(Object anObject, String msg) {
        Logger logger = LoggerFactory.getDefaultLogger();
        logger.error("Error in operation [get of object [" + this.getClass().getName() + "], " + msg);
        logger.error("Property Name [" + this.getName() + "]");
        if (anObject instanceof DynaBean) {
            DynaBean dynaBean = (DynaBean)anObject;
            logger.error("anObject was DynaClass [" + dynaBean.getDynaClass().getName() + "]");
        } else if (anObject != null) {
            logger.error("anObject was class [" + anObject.getClass().getName() + "]");
        } else {
            logger.error("anObject was null");
        }
    }
}

