/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.locking.IsolationLevels;
import org.apache.ojb.broker.metadata.AttributeContainer;
import org.apache.ojb.broker.metadata.ConnectionPoolDescriptor;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectCacheDescriptor;
import org.apache.ojb.broker.metadata.RepositoryElements;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.SequenceDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ConnectionDescriptorXmlHandler
extends DefaultHandler
implements RepositoryElements,
IsolationLevels {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$ConnectionDescriptorXmlHandler == null ? (class$org$apache$ojb$broker$metadata$ConnectionDescriptorXmlHandler = ConnectionDescriptorXmlHandler.class$("org.apache.ojb.broker.metadata.ConnectionDescriptorXmlHandler")) : class$org$apache$ojb$broker$metadata$ConnectionDescriptorXmlHandler);
    private ConnectionRepository con_repository;
    private JdbcConnectionDescriptor m_CurrentJCD;
    private SequenceDescriptor currentSequenceDescriptor;
    private List conDesList;
    private AttributeContainer currentAttributeContainer;
    private boolean defaultConnectionFound = false;
    private RepositoryTags tags = RepositoryTags.getInstance();
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$ConnectionDescriptorXmlHandler;

    public ConnectionDescriptorXmlHandler(ConnectionRepository cr) {
        if (cr == null) {
            throw new MetadataException("Given ConnectionRepository argument was null");
        }
        this.con_repository = cr;
        this.conDesList = new ArrayList();
    }

    public void startDocument() {
        this.logger.debug("****   startDoc   ****");
    }

    public void endDocument() {
        this.logger.debug("****   endDoc   ****");
        Iterator iterator = this.conDesList.iterator();
        while (iterator.hasNext()) {
            JdbcConnectionDescriptor jcd = (JdbcConnectionDescriptor)iterator.next();
            this.con_repository.addDescriptor(jcd);
        }
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        boolean isDebug = this.logger.isDebugEnabled();
        try {
            switch (this.getLiteralId(qName)) {
                case 1: {
                    if (isDebug) {
                        this.logger.debug("   > " + this.tags.getTagById(1));
                    }
                    JdbcConnectionDescriptor newJcd = new JdbcConnectionDescriptor();
                    this.currentAttributeContainer = newJcd;
                    this.conDesList.add(newJcd);
                    this.m_CurrentJCD = newJcd;
                    String jcdAlias = atts.getValue(this.tags.getTagById(82));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(82) + ": " + jcdAlias);
                    }
                    this.m_CurrentJCD.setJcdAlias(jcdAlias);
                    String defaultConnection = atts.getValue(this.tags.getTagById(80));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(80) + ": " + defaultConnection);
                    }
                    this.m_CurrentJCD.setDefaultConnection(Boolean.valueOf(defaultConnection));
                    if (this.m_CurrentJCD.isDefaultConnection()) {
                        if (this.defaultConnectionFound) {
                            throw new MetadataException("Found two jdbc-connection-descriptor elements with default-connection=\"true\"");
                        }
                        this.defaultConnectionFound = true;
                    }
                    String platform = atts.getValue(this.tags.getTagById(2));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(2) + ": " + platform);
                    }
                    this.m_CurrentJCD.setDbms(platform);
                    String level = atts.getValue(this.tags.getTagById(45));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(45) + ": " + level);
                    }
                    this.m_CurrentJCD.setJdbcLevel(level);
                    String driver = atts.getValue(this.tags.getTagById(6));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(6) + ": " + driver);
                    }
                    this.m_CurrentJCD.setDriver(driver);
                    String protocol = atts.getValue(this.tags.getTagById(7));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(7) + ": " + protocol);
                    }
                    this.m_CurrentJCD.setProtocol(protocol);
                    String subprotocol = atts.getValue(this.tags.getTagById(8));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(8) + ": " + subprotocol);
                    }
                    this.m_CurrentJCD.setSubProtocol(subprotocol);
                    String dbalias = atts.getValue(this.tags.getTagById(9));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(9) + ": " + dbalias);
                    }
                    this.m_CurrentJCD.setDbAlias(dbalias);
                    String datasource = atts.getValue(this.tags.getTagById(44));
                    if (datasource != null && datasource.trim().equals("")) {
                        datasource = null;
                    }
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(44) + ": " + datasource);
                    }
                    this.m_CurrentJCD.setDatasourceName(datasource);
                    String user = atts.getValue(this.tags.getTagById(10));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(10) + ": " + user);
                    }
                    this.m_CurrentJCD.setUserName(user);
                    String password = atts.getValue(this.tags.getTagById(11));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(11) + ": " + password);
                    }
                    this.m_CurrentJCD.setPassWord(password);
                    String eagerRelease = atts.getValue(this.tags.getTagById(74));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(74) + ": " + eagerRelease);
                    }
                    this.m_CurrentJCD.setEagerRelease(Boolean.valueOf(eagerRelease));
                    String batchMode = atts.getValue(this.tags.getTagById(83));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(83) + ": " + batchMode);
                    }
                    this.m_CurrentJCD.setBatchMode(Boolean.valueOf(batchMode));
                    String useAutoCommit = atts.getValue(this.tags.getTagById(90));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(90) + ": " + useAutoCommit);
                    }
                    this.m_CurrentJCD.setUseAutoCommit(Integer.valueOf(useAutoCommit));
                    String ignoreAutoCommitExceptions = atts.getValue(this.tags.getTagById(91));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(91) + ": " + ignoreAutoCommitExceptions);
                    }
                    this.m_CurrentJCD.setIgnoreAutoCommitExceptions(Boolean.valueOf(ignoreAutoCommitExceptions));
                    break;
                }
                case 65: {
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(65));
                    }
                    ConnectionPoolDescriptor m_CurrentCPD = this.m_CurrentJCD.getConnectionPoolDescriptor();
                    String maxActive = atts.getValue(this.tags.getTagById(55));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(55) + ": " + maxActive);
                    }
                    if (this.checkString(maxActive)) {
                        m_CurrentCPD.setMaxActive(Integer.parseInt(maxActive));
                    }
                    String maxIdle = atts.getValue(this.tags.getTagById(56));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(56) + ": " + maxIdle);
                    }
                    if (this.checkString(maxIdle)) {
                        m_CurrentCPD.setMaxIdle(Integer.parseInt(maxIdle));
                    }
                    String maxWait = atts.getValue(this.tags.getTagById(57));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(57) + ": " + maxWait);
                    }
                    if (this.checkString(maxWait)) {
                        m_CurrentCPD.setMaxWait(Integer.parseInt(maxWait));
                    }
                    String minEvictableIdleTimeMillis = atts.getValue(this.tags.getTagById(58));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(58) + ": " + minEvictableIdleTimeMillis);
                    }
                    if (this.checkString(minEvictableIdleTimeMillis)) {
                        m_CurrentCPD.setMinEvictableIdleTimeMillis(Long.parseLong(minEvictableIdleTimeMillis));
                    }
                    String numTestsPerEvictionRun = atts.getValue(this.tags.getTagById(59));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(59) + ": " + numTestsPerEvictionRun);
                    }
                    if (this.checkString(numTestsPerEvictionRun)) {
                        m_CurrentCPD.setNumTestsPerEvictionRun(Integer.parseInt(numTestsPerEvictionRun));
                    }
                    String testOnBorrow = atts.getValue(this.tags.getTagById(60));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(60) + ": " + testOnBorrow);
                    }
                    if (this.checkString(testOnBorrow)) {
                        m_CurrentCPD.setTestOnBorrow(Boolean.valueOf(testOnBorrow));
                    }
                    String testOnReturn = atts.getValue(this.tags.getTagById(61));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(61) + ": " + testOnReturn);
                    }
                    if (this.checkString(testOnReturn)) {
                        m_CurrentCPD.setTestOnReturn(Boolean.valueOf(testOnReturn));
                    }
                    String testWhileIdle = atts.getValue(this.tags.getTagById(62));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(62) + ": " + testWhileIdle);
                    }
                    if (this.checkString(testWhileIdle)) {
                        m_CurrentCPD.setTestWhileIdle(Boolean.valueOf(testWhileIdle));
                    }
                    String timeBetweenEvictionRunsMillis = atts.getValue(this.tags.getTagById(63));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(63) + ": " + timeBetweenEvictionRunsMillis);
                    }
                    if (this.checkString(timeBetweenEvictionRunsMillis)) {
                        m_CurrentCPD.setTimeBetweenEvictionRunsMillis(Long.parseLong(timeBetweenEvictionRunsMillis));
                    }
                    String whenExhaustedAction = atts.getValue(this.tags.getTagById(64));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(64) + ": " + whenExhaustedAction);
                    }
                    if (this.checkString(whenExhaustedAction)) {
                        m_CurrentCPD.setWhenExhaustedAction(Byte.parseByte(whenExhaustedAction));
                    }
                    String connectionFactoryStr = atts.getValue(this.tags.getTagById(66));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(66) + ": " + connectionFactoryStr);
                    }
                    if (this.checkString(connectionFactoryStr)) {
                        m_CurrentCPD.setConnectionFactory(ClassHelper.getClass(connectionFactoryStr));
                    }
                    String validationQuery = atts.getValue(this.tags.getTagById(79));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(79) + ": " + validationQuery);
                    }
                    if (this.checkString(validationQuery)) {
                        m_CurrentCPD.setValidationQuery(validationQuery);
                    }
                    String logAbandoned = atts.getValue(this.tags.getTagById(87));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(87) + ": " + logAbandoned);
                    }
                    if (this.checkString(logAbandoned)) {
                        m_CurrentCPD.setLogAbandoned(Boolean.valueOf(logAbandoned));
                    }
                    String removeAbandoned = atts.getValue(this.tags.getTagById(85));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(85) + ": " + removeAbandoned);
                    }
                    if (this.checkString(removeAbandoned)) {
                        m_CurrentCPD.setRemoveAbandoned(Boolean.valueOf(removeAbandoned));
                    }
                    String removeAbandonedTimeout = atts.getValue(this.tags.getTagById(86));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(86) + ": " + removeAbandonedTimeout);
                    }
                    if (!this.checkString(removeAbandonedTimeout)) break;
                    m_CurrentCPD.setRemoveAbandonedTimeout(Integer.parseInt(removeAbandonedTimeout));
                    break;
                }
                case 113: {
                    String className = atts.getValue(this.tags.getTagById(13));
                    if (!this.checkString(className) || this.m_CurrentJCD == null) break;
                    ObjectCacheDescriptor ocd = this.m_CurrentJCD.getObjectCacheDescriptor();
                    this.currentAttributeContainer = ocd;
                    ocd.setObjectCache(ClassHelper.getClass(className));
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(113));
                    }
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(13) + ": " + className);
                    }
                    break;
                }
                case 88: {
                    String className = atts.getValue(this.tags.getTagById(89));
                    if (!this.checkString(className)) break;
                    this.currentSequenceDescriptor = new SequenceDescriptor(this.m_CurrentJCD);
                    this.currentAttributeContainer = this.currentSequenceDescriptor;
                    this.m_CurrentJCD.setSequenceDescriptor(this.currentSequenceDescriptor);
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(88));
                    }
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(89) + ": " + className);
                    }
                    if (!this.checkString(className)) break;
                    this.currentSequenceDescriptor.setSequenceManagerClass(ClassHelper.getClass(className));
                    break;
                }
                case 71: {
                    String attributeName = atts.getValue(this.tags.getTagById(72));
                    String attributeValue = atts.getValue(this.tags.getTagById(73));
                    if (this.currentAttributeContainer == null) break;
                    if (this.checkString(attributeName)) {
                        if (isDebug) {
                            this.logger.debug("      > " + this.tags.getTagById(71));
                        }
                        if (isDebug) {
                            this.logger.debug("       " + this.tags.getTagById(72) + ": " + attributeName + "  " + this.tags.getTagById(73) + ": " + attributeValue);
                        }
                        this.currentAttributeContainer.addAttribute(attributeName, attributeValue);
                        break;
                    }
                    this.logger.info("Found 'null' or 'empty' attribute object for element " + this.currentAttributeContainer.getClass() + " attribute-name=" + attributeName + ", attribute-value=" + attributeValue + " See jdbc-connection-descriptor with jcdAlias '" + this.m_CurrentJCD.getJcdAlias() + "'");
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(ex);
            throw new PersistenceBrokerException(ex);
        }
    }

    private boolean checkString(String str) {
        return str != null && !str.trim().equals("");
    }

    private int getLiteralId(String literal) throws PersistenceBrokerException {
        try {
            return this.tags.getIdByTag(literal);
        }
        catch (NullPointerException e) {
            throw new MetadataException("unknown literal: '" + literal + "'", e);
        }
    }

    public void endElement(String uri, String name, String qName) {
        boolean isDebug = this.logger.isDebugEnabled();
        try {
            switch (this.getLiteralId(qName)) {
                case 0: {
                    this.currentAttributeContainer = null;
                    break;
                }
                case 12: {
                    this.currentAttributeContainer = null;
                    break;
                }
                case 1: {
                    this.logger.debug("   < " + this.tags.getTagById(1));
                    this.m_CurrentJCD = null;
                    this.currentAttributeContainer = null;
                    break;
                }
                case 65: {
                    this.logger.debug("   < " + this.tags.getTagById(65));
                    this.currentAttributeContainer = this.m_CurrentJCD;
                    break;
                }
                case 88: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(88));
                    }
                    this.currentSequenceDescriptor = null;
                    this.currentAttributeContainer = this.m_CurrentJCD;
                    break;
                }
                case 113: {
                    if (this.currentAttributeContainer == null) break;
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(113));
                    }
                    this.currentAttributeContainer = this.m_CurrentJCD;
                    break;
                }
                case 71: {
                    if (this.currentAttributeContainer == null || !isDebug) break;
                    this.logger.debug("      < " + this.tags.getTagById(71));
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(ex);
            throw new PersistenceBrokerException(ex);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        this.logger.error(e);
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.logger.fatal(e);
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        this.logger.warn(e);
        throw e;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

