/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.query.Query;

public class CollectionProxyDefaultImpl
implements Collection,
ManageableCollection,
CollectionProxy {
    private PBKey _brokerKey;
    private boolean _perThreadDescriptorsEnabled;
    private Object _profileKey;
    private Query _query;
    private Collection _data;
    private Class _collectionClass;
    private int _size = -1;
    private boolean _needsClose;
    private transient ArrayList _listeners;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareCollection;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$IRemovalAwareCollection;

    public CollectionProxyDefaultImpl(PBKey brokerKey, Query query) {
        this(brokerKey, class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = CollectionProxyDefaultImpl.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection, query);
    }

    public CollectionProxyDefaultImpl(PBKey brokerKey, Class collClass, Query query) {
        MetadataManager mm = MetadataManager.getInstance();
        this._perThreadDescriptorsEnabled = mm.isEnablePerThreadChanges();
        if (this._perThreadDescriptorsEnabled) {
            Object key = mm.getCurrentProfileKey();
            if (key == null) {
                throw new MetadataException("Trying to create a Collection proxy with per-thread metadata changes enabled, but no profile key.");
            }
            this.setProfileKey(key);
        }
        this.setBrokerKey(brokerKey);
        this.setCollectionClass(collClass);
        this.setQuery(query);
    }

    protected void loadProfileIfNeeded() {
        MetadataManager mm;
        Object key = this.getProfileKey();
        if (key != null && !key.equals((mm = MetadataManager.getInstance()).getCurrentProfileKey())) {
            mm.loadProfile(key);
        }
    }

    public boolean isLoaded() {
        return this._data != null;
    }

    protected synchronized int loadSize() throws PersistenceBrokerException {
        PersistenceBroker broker = this.getBroker();
        try {
            int n = broker.getCount(this.getQuery());
            return n;
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
        finally {
            this.releaseBroker(broker);
        }
    }

    protected synchronized void setSize(int size) {
        this._size = size;
    }

    protected Collection loadData() throws PersistenceBrokerException {
        PersistenceBroker broker = this.getBroker();
        try {
            Collection result = this._data != null ? this._data : (this._size != 0 ? (Collection)((Object)broker.getCollectionByQuery(this.getCollectionClass(), this.getQuery())) : (Collection)this.getCollectionClass().newInstance());
            Collection collection = result;
            return collection;
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
        finally {
            this.releaseBroker(broker);
        }
    }

    protected void beforeLoading() {
        if (this._listeners != null) {
            if (this._perThreadDescriptorsEnabled) {
                this.loadProfileIfNeeded();
            }
            for (int idx = this._listeners.size() - 1; idx >= 0; --idx) {
                CollectionProxyListener listener = (CollectionProxyListener)this._listeners.get(idx);
                listener.beforeLoading(this);
            }
        }
    }

    protected void afterLoading() {
        if (this._listeners != null) {
            if (this._perThreadDescriptorsEnabled) {
                this.loadProfileIfNeeded();
            }
            for (int idx = this._listeners.size() - 1; idx >= 0; --idx) {
                CollectionProxyListener listener = (CollectionProxyListener)this._listeners.get(idx);
                listener.afterLoading(this);
            }
        }
    }

    public int size() {
        if (this.isLoaded()) {
            return this.getData().size();
        }
        if (this._size < 0) {
            this._size = this.loadSize();
        }
        return this._size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object o) {
        return this.getData().contains(o);
    }

    public Iterator iterator() {
        return this.getData().iterator();
    }

    public Object[] toArray() {
        return this.getData().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.getData().toArray(a);
    }

    public boolean add(Object o) {
        return this.getData().add(o);
    }

    public boolean remove(Object o) {
        return this.getData().remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.getData().containsAll(c);
    }

    public boolean addAll(Collection c) {
        return this.getData().addAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.getData().removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.getData().retainAll(c);
    }

    public void clear() {
        Class collClass;
        if ((class$org$apache$ojb$broker$util$collections$IRemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$IRemovalAwareCollection = CollectionProxyDefaultImpl.class$("org.apache.ojb.broker.util.collections.IRemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$IRemovalAwareCollection).isAssignableFrom(collClass = this.getCollectionClass())) {
            this.getData().clear();
        } else {
            ArrayList coll;
            try {
                coll = (ArrayList)collClass.newInstance();
            }
            catch (Exception e) {
                coll = new ArrayList();
            }
            this.setData(coll);
        }
        this._size = 0;
    }

    public Query getQuery() {
        return this._query;
    }

    protected void setQuery(Query query) {
        this._query = query;
    }

    protected synchronized void releaseBroker(PersistenceBroker broker) {
        if (broker != null && this._needsClose) {
            this._needsClose = false;
            broker.close();
        }
    }

    protected synchronized PersistenceBroker getBroker() throws PBFactoryException {
        if (this._perThreadDescriptorsEnabled) {
            this.loadProfileIfNeeded();
        }
        if (this.getBrokerKey() == null) {
            throw new OJBRuntimeException("Can't find associated PBKey. Need PBKey to obtain a validPersistenceBroker instance from intern resources.");
        }
        PersistenceBroker broker = PersistenceBrokerThreadMapping.currentPersistenceBroker(this.getBrokerKey());
        if (broker == null || broker.isClosed()) {
            broker = PersistenceBrokerFactory.createPersistenceBroker(this.getBrokerKey());
            this._needsClose = true;
        }
        return broker;
    }

    public synchronized Collection getData() {
        if (!this.isLoaded()) {
            this.beforeLoading();
            this.setData(this.loadData());
            this.afterLoading();
        }
        return this._data;
    }

    public void setData(Collection data) {
        this._data = data;
    }

    public Class getCollectionClass() {
        return this._collectionClass;
    }

    protected void setCollectionClass(Class collClass) {
        this._collectionClass = collClass;
    }

    public void ojbAdd(Object anObject) {
        this.add(anObject);
    }

    public void ojbAddAll(ManageableCollection otherCollection) {
        this.addAll((Collection)((CollectionProxyDefaultImpl)otherCollection));
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void afterStore(PersistenceBroker broker) throws PersistenceBrokerException {
        Collection c = this.getData();
        if (c instanceof ManageableCollection) {
            ((ManageableCollection)((Object)c)).afterStore(broker);
        }
    }

    public PBKey getBrokerKey() {
        return this._brokerKey;
    }

    protected void setBrokerKey(PBKey brokerKey) {
        this._brokerKey = brokerKey;
    }

    protected Object getProfileKey() {
        return this._profileKey;
    }

    public void setProfileKey(Object profileKey) {
        this._profileKey = profileKey;
    }

    public synchronized void addListener(CollectionProxyListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public synchronized void removeListener(CollectionProxyListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

