/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.ojb.broker.accesslayer.sql.SqlCacheKey;
import org.apache.ojb.broker.accesslayer.sql.SqlDeleteByPkStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlDeleteByQuery;
import org.apache.ojb.broker.accesslayer.sql.SqlDeleteMNStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlGenerator;
import org.apache.ojb.broker.accesslayer.sql.SqlInsertMNStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlInsertStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlProcedureStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectByPkStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectMNStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlUpdateStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DeleteProcedureDescriptor;
import org.apache.ojb.broker.metadata.InsertProcedureDescriptor;
import org.apache.ojb.broker.metadata.UpdateProcedureDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.BetweenCriteria;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.ExistsCriteria;
import org.apache.ojb.broker.query.FieldCriteria;
import org.apache.ojb.broker.query.InCriteria;
import org.apache.ojb.broker.query.NullCriteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.SelectionCriteria;
import org.apache.ojb.broker.query.SqlCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class SqlGeneratorDefaultImpl
implements SqlGenerator {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$sql$SqlGeneratorDefaultImpl == null ? (class$org$apache$ojb$broker$accesslayer$sql$SqlGeneratorDefaultImpl = SqlGeneratorDefaultImpl.class$("org.apache.ojb.broker.accesslayer.sql.SqlGeneratorDefaultImpl")) : class$org$apache$ojb$broker$accesslayer$sql$SqlGeneratorDefaultImpl);
    private Map m_sqlCacheMap = new WeakHashMap();
    private Platform m_platform;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$sql$SqlGeneratorDefaultImpl;

    public SqlGeneratorDefaultImpl(Platform pf) {
        this.m_platform = pf;
    }

    public String getPreparedDeleteStatement(ClassDescriptor cld) {
        DeleteProcedureDescriptor pd = cld.getDeleteProcedure();
        SqlStatement sql = pd == null ? new SqlDeleteByPkStatement(cld, this.logger) : new SqlProcedureStatement(pd, this.logger);
        String result = sql.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + result);
        }
        return result;
    }

    public String getPreparedInsertStatement(ClassDescriptor cld) {
        InsertProcedureDescriptor pd = cld.getInsertProcedure();
        SqlStatement sql = pd == null ? new SqlInsertStatement(cld, this.logger) : new SqlProcedureStatement(pd, this.logger);
        String result = sql.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + result);
        }
        return result;
    }

    public String getPreparedSelectByPkStatement(ClassDescriptor cld) {
        SqlSelectByPkStatement sql = new SqlSelectByPkStatement(cld, this.logger);
        String result = sql.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + result);
        }
        return result;
    }

    public String getPreparedSelectStatement(Query query, ClassDescriptor cld) {
        SqlCacheKey key = new SqlCacheKey(query, cld, 1);
        String result = (String)this.m_sqlCacheMap.get(key);
        if (result == null) {
            SqlSelectStatement sql = new SqlSelectStatement(this.m_platform, cld, query, this.logger);
            result = sql.getStatement();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + result);
            }
            this.m_sqlCacheMap.put(key, result);
        }
        return result;
    }

    public String getPreparedUpdateStatement(ClassDescriptor cld) {
        UpdateProcedureDescriptor pd = cld.getUpdateProcedure();
        SqlStatement sql = pd == null ? new SqlUpdateStatement(cld, this.logger) : new SqlProcedureStatement(pd, this.logger);
        String result = sql.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + result);
        }
        return result;
    }

    public String getInsertMNStatement(String table, String[] pkColumns1, String[] pkColumns2) {
        String[] cols = new String[pkColumns1.length + pkColumns2.length];
        System.arraycopy(pkColumns1, 0, cols, 0, pkColumns1.length);
        System.arraycopy(pkColumns2, 0, cols, pkColumns1.length, pkColumns2.length);
        SqlInsertMNStatement sql = new SqlInsertMNStatement(table, cols, this.logger);
        String result = sql.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + result);
        }
        return result;
    }

    public String getSelectMNStatement(String table, String[] selectColumns, String[] columns) {
        SqlSelectMNStatement sql = new SqlSelectMNStatement(table, selectColumns, columns, this.logger);
        String result = sql.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + result);
        }
        return result;
    }

    public String getDeleteMNStatement(String table, String[] pkColumns1, String[] pkColumns2) {
        String[] cols;
        if (pkColumns2 == null) {
            cols = pkColumns1;
        } else {
            cols = new String[pkColumns1.length + pkColumns2.length];
            System.arraycopy(pkColumns1, 0, cols, 0, pkColumns1.length);
            System.arraycopy(pkColumns2, 0, cols, pkColumns1.length, pkColumns2.length);
        }
        SqlDeleteMNStatement sql = new SqlDeleteMNStatement(table, cols, this.logger);
        String result = sql.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + result);
        }
        return result;
    }

    public String getSelectStatementDep(Query query, ClassDescriptor cld) {
        SqlCacheKey key = new SqlCacheKey(query, cld, 1);
        String result = (String)this.m_sqlCacheMap.get(key);
        if (result == null) {
            SqlSelectStatement sql = new SqlSelectStatement(this.m_platform, cld, query, this.logger);
            result = sql.getStatement();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + result);
            }
            this.m_sqlCacheMap.put(key, result);
        }
        return result;
    }

    public String asSQLStatement(Criteria crit, ClassDescriptor cld) {
        Enumeration e = crit.getElements();
        StringBuffer statement = new StringBuffer();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Criteria) {
                String addAtEnd;
                String addAtStart;
                Criteria pc = (Criteria)o;
                if (pc.isEmbraced()) {
                    addAtStart = " (";
                    addAtEnd = ") ";
                } else {
                    addAtStart = "";
                    addAtEnd = "";
                }
                switch (pc.getType()) {
                    case 0: {
                        statement.append(" OR " + addAtStart);
                        statement.append(this.asSQLStatement(pc, cld));
                        statement.append(addAtEnd);
                        break;
                    }
                    case 1: {
                        statement.insert(0, "( ");
                        statement.append(") ");
                        statement.append(" AND " + addAtStart);
                        statement.append(this.asSQLStatement(pc, cld));
                        statement.append(addAtEnd);
                    }
                }
                continue;
            }
            SelectionCriteria c = (SelectionCriteria)o;
            if (statement.length() == 0) {
                statement.append(this.asSQLClause(c, cld));
                continue;
            }
            statement.insert(0, "(");
            statement.append(") ");
            statement.append(" AND ");
            statement.append(this.asSQLClause(c, cld));
        }
        if (statement.length() == 0) {
            return null;
        }
        return statement.toString();
    }

    protected String asSQLClause(SelectionCriteria c, ClassDescriptor cld) {
        if (c instanceof FieldCriteria) {
            return this.toSQLClause((FieldCriteria)c, cld);
        }
        if (c instanceof NullCriteria) {
            return this.toSQLClause((NullCriteria)c, cld);
        }
        if (c instanceof BetweenCriteria) {
            return this.toSQLClause((BetweenCriteria)c, cld);
        }
        if (c instanceof InCriteria) {
            return this.toSQLClause((InCriteria)c, cld);
        }
        if (c instanceof SqlCriteria) {
            return this.toSQLClause((SqlCriteria)c, cld);
        }
        if (c instanceof ExistsCriteria) {
            return this.toSQLClause((ExistsCriteria)c, cld);
        }
        return this.toSQLClause(c, cld);
    }

    private String toSqlClause(Object attributeOrQuery, ClassDescriptor cld) {
        String result;
        if (attributeOrQuery instanceof Query) {
            Query q = (Query)attributeOrQuery;
            result = this.getPreparedSelectStatement(q, cld.getRepository().getDescriptorFor(q.getSearchClass()));
        } else {
            result = (String)attributeOrQuery;
        }
        return result;
    }

    private String toSQLClause(NullCriteria c, ClassDescriptor cld) {
        String colName = (String)c.getAttribute();
        return colName + c.getClause();
    }

    private String toSQLClause(FieldCriteria c, ClassDescriptor cld) {
        String colName = this.toSqlClause(c.getAttribute(), cld);
        return colName + c.getClause() + c.getValue();
    }

    private String toSQLClause(BetweenCriteria c, ClassDescriptor cld) {
        String colName = this.toSqlClause(c.getAttribute(), cld);
        return colName + c.getClause() + " ? AND ? ";
    }

    private String toSQLClause(InCriteria c, ClassDescriptor cld) {
        StringBuffer buf = new StringBuffer();
        Collection values = (Collection)c.getValue();
        int size = values.size();
        buf.append(c.getAttribute());
        buf.append(c.getClause());
        buf.append("(");
        for (int i = 0; i < size - 1; ++i) {
            buf.append("?,");
        }
        buf.append("?)");
        return buf.toString();
    }

    private String toSQLClause(SelectionCriteria c, ClassDescriptor cld) {
        String colName = this.toSqlClause(c.getAttribute(), cld);
        return colName + c.getClause() + " ? ";
    }

    private String toSQLClause(SqlCriteria c, ClassDescriptor cld) {
        return c.getClause();
    }

    private String toSQLClause(ExistsCriteria c, ClassDescriptor cld) {
        StringBuffer buf = new StringBuffer();
        Query subQuery = (Query)c.getValue();
        buf.append(c.getClause());
        buf.append(" (");
        if (cld != null) {
            buf.append(this.getPreparedSelectStatement(subQuery, cld.getRepository().getDescriptorFor(subQuery.getSearchClass())));
        } else {
            buf.append(subQuery);
        }
        buf.append(")");
        return buf.toString();
    }

    public String getPreparedDeleteStatement(Query query, ClassDescriptor cld) {
        SqlCacheKey key = new SqlCacheKey(query, cld, 4);
        String result = (String)this.m_sqlCacheMap.get(key);
        if (result == null) {
            SqlDeleteByQuery sql = new SqlDeleteByQuery(this.m_platform, cld, query, this.logger);
            result = sql.getStatement();
            this.m_sqlCacheMap.put(key, result);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + result);
            }
        }
        return result;
    }

    public Platform getPlatform() {
        return this.m_platform;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

