/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.KeyConstraintViolatedException;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ArgumentDescriptor;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class JdbcAccessImpl
implements JdbcAccess {
    private static final String SQL_STATE_KEY_VIOLATED = "23000";
    private static final String SQL_STATE_FK_VIOLATED = "23505";
    protected Logger logger;
    protected PersistenceBroker broker;

    public JdbcAccessImpl(PersistenceBroker broker) {
        this.broker = broker;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void executeDelete(ClassDescriptor cld, Object obj) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeDelete: " + obj);
        }
        PreparedStatement stmt = null;
        try {
            stmt = this.broker.serviceStatementManager().getDeleteStatement(cld);
            if (stmt == null) {
                this.logger.error("getDeleteStatement returned a null statement");
                throw new PersistenceBrokerException("JdbcAccessImpl: getDeleteStatement returned a null statement");
            }
            this.broker.serviceStatementManager().bindDelete(stmt, cld, obj);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeDelete: " + stmt);
            }
            if (stmt.executeUpdate() == 0 && cld.isLocking()) {
                throw new OptimisticLockException("Object has been modified or deleted by someone else", obj);
            }
            this.harvestReturnValues(cld.getDeleteProcedure(), obj, stmt);
        }
        catch (OptimisticLockException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("OptimisticLockException during the execution of delete: " + e.getMessage(), (Throwable)((Object)e));
            }
            throw e;
        }
        catch (PersistenceBrokerException e) {
            this.logger.error("PersistenceBrokerException during the execution of delete: " + e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (SQLException e) {
            String msg = "SQLException during the execution of the delete (for " + cld.getClassOfObject().getName() + "): " + e.getMessage();
            this.logger.error(msg, e);
            throw new PersistenceBrokerSQLException("JdbcAccessImpl: " + msg, e);
        }
        finally {
            this.broker.serviceStatementManager().closeResources(stmt, null);
        }
    }

    public void executeDelete(Query query, ClassDescriptor cld) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeDelete (by Query): " + query);
        }
        PreparedStatement stmt = null;
        try {
            String sql = this.broker.serviceSqlGenerator().getPreparedDeleteStatement(query, cld);
            stmt = this.broker.serviceStatementManager().getPreparedStatement(cld, sql, false);
            this.broker.serviceStatementManager().bindStatement(stmt, query, cld, 1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeDelete (by Query): " + stmt);
            }
            stmt.executeUpdate();
            this.broker.serviceStatementManager().closeResources(stmt, null);
        }
        catch (SQLException e) {
            try {
                String msg = "SQLException during the execution of delete by query (for " + cld.getClassOfObject().getName() + "): " + e.getMessage();
                this.logger.error(msg, e);
                throw new PersistenceBrokerSQLException(msg, e);
            }
            catch (Throwable throwable) {
                this.broker.serviceStatementManager().closeResources(stmt, null);
                throw throwable;
            }
        }
    }

    public void executeInsert(ClassDescriptor cld, Object obj) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeInsert: " + obj);
        }
        PreparedStatement stmt = null;
        try {
            stmt = this.broker.serviceStatementManager().getInsertStatement(cld);
            if (stmt == null) {
                this.logger.error("getInsertStatement returned a null statement");
                throw new PersistenceBrokerException("getInsertStatement returned a null statement");
            }
            this.broker.serviceStatementManager().bindInsert(stmt, cld, obj);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeInsert: " + stmt);
            }
            stmt.executeUpdate();
            this.broker.serviceSequenceManager().afterStore(this, cld, obj);
            this.harvestReturnValues(cld.getInsertProcedure(), obj, stmt);
        }
        catch (PersistenceBrokerException e) {
            this.logger.error("PersistenceBrokerException during the execution of the insert: " + e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (SequenceManagerException e) {
            throw new PersistenceBrokerException("Can't lookup new database Identity Column value", (Throwable)((Object)e));
        }
        catch (SQLException e) {
            String stateCode = e.getSQLState();
            StringBuffer msg = new StringBuffer("SQL failure while insert object data for class ");
            try {
                msg.append(cld.getClassNameOfObject()).append(", PK of the given object is [");
                FieldDescriptor[] fields = cld.getPkFields();
                for (int i = 0; i < fields.length; ++i) {
                    msg.append(" ").append(fields[i].getPersistentField().getName()).append("=").append(fields[i].getPersistentField().get(obj));
                }
                msg.append("], object was " + obj);
                msg.append(", exception message is [").append(e.getMessage()).append("]");
                msg.append(", SQL code [").append(stateCode).append("]");
            }
            catch (Exception ignore) {
                msg.append("- Sorry, can't generate a more detailed message");
            }
            if (SQL_STATE_KEY_VIOLATED.equals(stateCode) || SQL_STATE_FK_VIOLATED.equals(stateCode)) {
                throw new KeyConstraintViolatedException(msg.toString(), e);
            }
            throw new PersistenceBrokerSQLException(msg.toString(), e);
        }
        finally {
            this.broker.serviceStatementManager().closeResources(stmt, null);
        }
    }

    public ResultSetAndStatement executeQuery(Query query, ClassDescriptor cld) throws PersistenceBrokerException {
        boolean scrollable;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeQuery: " + query);
        }
        boolean bl = scrollable = query.getStartAtIndex() > 0 || query.getEndAtIndex() > 0;
        if (query != null && query.getPrefetchedRelationships() != null && !query.getPrefetchedRelationships().isEmpty()) {
            scrollable = true;
        }
        ResultSetAndStatement retval = null;
        try {
            String sql = this.broker.serviceSqlGenerator().getPreparedSelectStatement(query, cld);
            PreparedStatement stmt = this.broker.serviceStatementManager().getPreparedStatement(cld, sql, scrollable);
            this.broker.serviceStatementManager().bindStatement(stmt, query, cld, 1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeQuery: " + stmt);
            }
            ResultSet rs = stmt.executeQuery();
            retval = new ResultSetAndStatement(this.broker.serviceConnectionManager().getSupportedPlatform(), stmt, rs);
            return retval;
        }
        catch (PersistenceBrokerException e) {
            this.logger.error("PersistenceBrokerException during the execution of the query: " + e.getMessage(), (Throwable)((Object)e));
            if (retval != null) {
                retval.close();
            }
            throw e;
        }
        catch (SQLException e) {
            String msg = "SQLException during the execution of the query (for " + cld.getClassOfObject().getName() + "): " + e.getMessage();
            this.logger.error(msg, e);
            if (retval != null) {
                retval.close();
            }
            throw new PersistenceBrokerSQLException(msg, e);
        }
    }

    public ResultSetAndStatement executeSQL(String sqlStatement, ClassDescriptor cld, boolean scrollable) throws PersistenceBrokerException {
        return this.executeSQL(sqlStatement, cld, null, scrollable);
    }

    public ResultSetAndStatement executeSQL(String sqlStatement, ClassDescriptor cld, ValueContainer[] values, boolean scrollable) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeSQL: " + sqlStatement);
        }
        StatementManagerIF stmtMan = this.broker.serviceStatementManager();
        ResultSetAndStatement retval = null;
        try {
            PreparedStatement stmt = stmtMan.getPreparedStatement(cld, sqlStatement, scrollable);
            stmtMan.bindValues(stmt, values, 1);
            ResultSet rs = stmt.executeQuery();
            retval = new ResultSetAndStatement(this.broker.serviceConnectionManager().getSupportedPlatform(), stmt, rs);
            return retval;
        }
        catch (PersistenceBrokerException e) {
            this.logger.error("PersistenceBrokerException during the execution of the SQL query: " + e.getMessage(), (Throwable)((Object)e));
            if (retval != null) {
                retval.close();
            }
            throw e;
        }
        catch (SQLException e) {
            String msg = "SQLException during the execution of the SQL query: " + sqlStatement + ", message is: " + e.getMessage();
            this.logger.error(msg, e);
            if (retval != null) {
                retval.close();
            }
            throw new PersistenceBrokerSQLException(msg, e);
        }
    }

    public int executeUpdateSQL(String sqlStatement, ClassDescriptor cld) throws PersistenceBrokerException {
        return this.executeUpdateSQL(sqlStatement, cld, null, null);
    }

    public int executeUpdateSQL(String sqlStatement, ClassDescriptor cld, ValueContainer[] values1, ValueContainer[] values2) throws PersistenceBrokerException {
        int result;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeUpdateSQL: " + sqlStatement);
        }
        PreparedStatement stmt = null;
        StatementManagerIF stmtMan = this.broker.serviceStatementManager();
        try {
            stmt = stmtMan.getPreparedStatement(cld, sqlStatement, false);
            int index = stmtMan.bindValues(stmt, values1, 1);
            index = stmtMan.bindValues(stmt, values2, index);
            result = stmt.executeUpdate();
        }
        catch (PersistenceBrokerException e) {
            this.logger.error("PersistenceBrokerException during the execution of the Update SQL query: " + e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (SQLException e) {
            String msg = "SQLException during the execution of the update SQL query: " + sqlStatement;
            this.logger.error(msg, e);
            if (SQL_STATE_KEY_VIOLATED.equals(e.getSQLState())) {
                throw new KeyConstraintViolatedException(msg, e);
            }
            throw new PersistenceBrokerSQLException(msg, e);
        }
        finally {
            stmtMan.closeResources(stmt, null);
        }
        return result;
    }

    public void executeUpdate(ClassDescriptor cld, Object obj) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeUpdate: " + obj);
        }
        PreparedStatement stmt = null;
        if (cld.getNonPkRwFields().length == 0) {
            return;
        }
        ValueContainer[] oldLockingValues = cld.getCurrentLockingValues(obj);
        try {
            stmt = this.broker.serviceStatementManager().getUpdateStatement(cld);
            if (stmt == null) {
                this.logger.error("getUpdateStatement returned a null statement");
                throw new PersistenceBrokerException("getUpdateStatement returned a null statement");
            }
            this.broker.serviceStatementManager().bindUpdate(stmt, cld, obj);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeUpdate: " + stmt);
            }
            if (stmt.executeUpdate() == 0 && cld.isLocking()) {
                throw new OptimisticLockException("Object has been modified by someone else", obj);
            }
            this.harvestReturnValues(cld.getUpdateProcedure(), obj, stmt);
        }
        catch (OptimisticLockException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("OptimisticLockException during the execution of update: " + e.getMessage(), (Throwable)((Object)e));
            }
            throw e;
        }
        catch (PersistenceBrokerException e) {
            this.setLockingValues(cld, obj, oldLockingValues);
            this.logger.error("PersistenceBrokerException during the execution of the update: " + e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (SQLException e) {
            this.setLockingValues(cld, obj, oldLockingValues);
            String msg = "SQLException during the execution of the update (for a " + cld.getClassOfObject().getName() + "): " + e.getMessage();
            this.logger.error(msg, e);
            if (SQL_STATE_KEY_VIOLATED.equals(e.getSQLState())) {
                throw new KeyConstraintViolatedException(msg, e);
            }
            throw new PersistenceBrokerSQLException(msg, e);
        }
        finally {
            this.broker.serviceStatementManager().closeResources(stmt, null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object materializeObject(ClassDescriptor cld, Identity oid) throws PersistenceBrokerException {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = this.broker.serviceStatementManager().getSelectByPKStatement(cld);
            if (stmt == null) {
                this.logger.error("getSelectByPKStatement returned a null statement");
                throw new PersistenceBrokerException("getSelectByPKStatement returned a null statement");
            }
            this.broker.serviceStatementManager().bindSelect(stmt, oid, cld);
            rs = stmt.executeQuery();
            if (rs.next()) {
                HashMap row = new HashMap();
                cld.getRowReader().readObjectArrayFrom(rs, row);
                Object object = cld.getRowReader().readObjectFrom(row);
                this.broker.serviceStatementManager().closeResources(stmt, rs);
                return object;
            }
        }
        catch (PersistenceBrokerException e) {
            try {
                this.logger.error("PersistenceBrokerException during the execution of materializeObject: " + e.getMessage(), (Throwable)((Object)e));
                throw e;
                catch (SQLException e2) {
                    String msg = "SQLException during the execution of materializeObject (for a " + cld.getClassOfObject().getName() + "): " + e2.getMessage();
                    this.logger.error(msg, e2);
                    throw new PersistenceBrokerSQLException(msg, e2);
                }
            }
            catch (Throwable throwable) {
                this.broker.serviceStatementManager().closeResources(stmt, rs);
                throw throwable;
            }
        }
        {
            Object row = null;
            this.broker.serviceStatementManager().closeResources(stmt, rs);
            return row;
        }
    }

    private void setLockingValues(ClassDescriptor cld, Object obj, ValueContainer[] oldLockingValues) {
        FieldDescriptor[] fields = cld.getLockingFields();
        for (int i = 0; i < fields.length; ++i) {
            PersistentField field = fields[i].getPersistentField();
            Object lockVal = oldLockingValues[i].getValue();
            field.set(obj, lockVal);
        }
    }

    private void harvestReturnValues(ProcedureDescriptor proc, Object obj, PreparedStatement stmt) throws PersistenceBrokerSQLException {
        if (proc == null || !proc.hasReturnValues() || !(stmt instanceof CallableStatement)) {
            return;
        }
        CallableStatement callable = (CallableStatement)stmt;
        int index = 0;
        if (proc.hasReturnValue()) {
            this.harvestReturnValue(obj, callable, proc.getReturnValueFieldRef(), ++index);
        }
        Iterator iter = proc.getArguments().iterator();
        while (iter.hasNext()) {
            ++index;
            ArgumentDescriptor arg = (ArgumentDescriptor)iter.next();
            if (!arg.getIsReturnedByProcedure()) continue;
            this.harvestReturnValue(obj, callable, arg.getFieldRef(), index);
        }
    }

    private void harvestReturnValue(Object obj, CallableStatement callable, FieldDescriptor fmd, int index) throws PersistenceBrokerSQLException {
        try {
            if (callable != null && fmd != null && obj != null) {
                Object value = fmd.getJdbcType().getObjectFromColumn(callable, index);
                fmd.getPersistentField().set(obj, fmd.getFieldConversion().sqlToJava(value));
            }
        }
        catch (SQLException e) {
            String msg = "SQLException during the execution of harvestReturnValue class=" + obj.getClass().getName() + "," + " field=" + fmd.getAttributeName() + " : " + e.getMessage();
            this.logger.error(msg, e);
            throw new PersistenceBrokerSQLException(msg, e);
        }
    }
}

