/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.TransactionInProgressException;
import org.apache.ojb.broker.TransactionNotInProgressException;
import org.apache.ojb.broker.accesslayer.ConnectionFactory;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryFactory;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.accesslayer.OJBBatchUpdateException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.util.batch.BatchConnection;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionManagerImpl
implements ConnectionManagerIF {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionManagerImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionManagerImpl = ConnectionManagerImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionManagerImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionManagerImpl);
    private PersistenceBroker broker = null;
    private ConnectionFactory connectionFactory;
    private JdbcConnectionDescriptor jcd;
    private Platform platform;
    private Connection con = null;
    private PBKey pbKey;
    private boolean originalAutoCommitState;
    private boolean isInLocalTransaction;
    private boolean batchMode;
    private BatchConnection batchCon = null;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionManagerImpl;

    public ConnectionManagerImpl(PersistenceBroker broker) {
        this.broker = broker;
        this.pbKey = broker.getPBKey();
        this.jcd = MetadataManager.getInstance().connectionRepository().getDescriptor(this.pbKey);
        this.connectionFactory = ConnectionFactoryFactory.getInstance().createConnectionFactory();
        this.platform = PlatformFactory.getPlatformFor(this.jcd);
        this.setBatchMode(false);
    }

    public JdbcConnectionDescriptor getConnectionDescriptor() {
        return this.jcd;
    }

    public Platform getSupportedPlatform() {
        return this.platform;
    }

    public Connection getConnection() throws LookupException {
        if (this.con != null && !this.isInLocalTransaction() && !this.isAlive(this.con)) {
            this.releaseConnection();
        }
        if (this.con == null) {
            this.con = this.connectionFactory.lookupConnection(this.jcd);
            if (this.con == null) {
                throw new PersistenceBrokerException("Cannot get connection for " + this.jcd);
            }
            if (this.jcd.getUseAutoCommit() == 1) {
                try {
                    this.originalAutoCommitState = this.con.getAutoCommit();
                }
                catch (SQLException e) {
                    throw new PersistenceBrokerException("Cannot request autoCommit state on the connection", e);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Request new connection from ConnectionFactory: " + this.con);
            }
        }
        if (this.isBatchMode()) {
            if (this.batchCon == null) {
                this.batchCon = new BatchConnection(this.con, this.broker);
            }
            return this.batchCon;
        }
        return this.con;
    }

    public void localBegin() {
        if (this.isInLocalTransaction) {
            throw new TransactionInProgressException("Connection is already in transaction");
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (LookupException e) {
            throw new PersistenceBrokerException("Can't lookup a connection", (Throwable)((Object)e));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("localBegin was called for con " + connection);
        }
        if (this.jcd.getUseAutoCommit() == 1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Try to change autoCommit state to 'false'");
            }
            this.platform.changeAutoCommitState(this.jcd, connection, false);
        }
        this.isInLocalTransaction = true;
    }

    public void localCommit() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("commit was called");
        }
        if (!this.isInLocalTransaction) {
            throw new TransactionNotInProgressException("Not in transaction, call begin() before commit()");
        }
        try {
            block7: {
                try {
                    if (this.batchCon != null) {
                        this.batchCon.commit();
                        break block7;
                    }
                    if (this.con == null) break block7;
                    this.con.commit();
                }
                catch (SQLException e) {
                    this.log.error("Commit on underlying connection failed, try to rollback connection", e);
                    this.localRollback();
                    throw new TransactionAbortedException("Commit on connection failed", e);
                }
            }
            Object var3_1 = null;
            this.isInLocalTransaction = false;
            this.restoreAutoCommitState();
            this.releaseConnection();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.isInLocalTransaction = false;
            this.restoreAutoCommitState();
            this.releaseConnection();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localRollback() {
        this.log.info("Rollback was called, do rollback on current connection " + this.con);
        if (!this.isInLocalTransaction) {
            throw new PersistenceBrokerException("Not in transaction, cannot abort");
        }
        try {
            this.isInLocalTransaction = false;
            if (this.batchCon != null) {
                this.batchCon.rollback();
            } else if (this.con != null && !this.con.isClosed()) {
                this.con.rollback();
            }
        }
        catch (SQLException e) {
            this.log.error("Rollback on the underlying connection failed", e);
        }
        finally {
            try {
                this.restoreAutoCommitState();
            }
            catch (OJBRuntimeException oJBRuntimeException) {}
            this.releaseConnection();
        }
    }

    protected void restoreAutoCommitState() {
        try {
            if (this.jcd.getUseAutoCommit() == 1 && this.originalAutoCommitState && this.con != null && !this.con.isClosed()) {
                this.platform.changeAutoCommitState(this.jcd, this.con, true);
            }
        }
        catch (SQLException e) {
            throw new OJBRuntimeException("Restore of connection autocommit state failed", e);
        }
    }

    public boolean isAlive(Connection conn) {
        try {
            return this.con != null ? !this.con.isClosed() : false;
        }
        catch (SQLException e) {
            this.log.error("IsAlive check failed, running connection was invalid!!", e);
            return false;
        }
    }

    public boolean isInLocalTransaction() {
        return this.isInLocalTransaction;
    }

    public void releaseConnection() {
        if (this.con == null) {
            return;
        }
        if (this.isInLocalTransaction()) {
            this.log.error("Release connection: connection is in local transaction, missing 'localCommit' or 'localRollback' call - try to rollback the connection");
            this.localRollback();
        } else {
            this.connectionFactory.releaseConnection(this.jcd, this.con);
            this.con = null;
            this.batchCon = null;
        }
    }

    public ConnectionFactory getUnderlyingConnectionFactory() {
        return this.connectionFactory;
    }

    public void setBatchMode(boolean mode) {
        this.batchMode = mode && this.jcd.getBatchMode();
    }

    public boolean isBatchMode() {
        return this.batchMode && this.platform.supportsBatchOperations();
    }

    public void executeBatch() throws OJBBatchUpdateException {
        if (this.batchCon != null) {
            try {
                this.batchCon.executeBatch();
            }
            catch (Throwable th) {
                throw new OJBBatchUpdateException(th);
            }
        }
    }

    public void executeBatchIfNecessary() throws OJBBatchUpdateException {
        if (this.batchCon != null) {
            try {
                this.batchCon.executeBatchIfNecessary();
            }
            catch (Throwable th) {
                throw new OJBBatchUpdateException(th);
            }
        }
    }

    public void clearBatch() {
        if (this.batchCon != null) {
            this.batchCon.clearBatch();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

