/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.factory;

import java.util.HashMap;
import java.util.Iterator;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.UnavailableException;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.container.PortalAccessor;
import org.apache.jetspeed.factory.JetspeedPortletInstance;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.factory.PortletInstance;
import org.apache.jetspeed.om.common.portlet.PortletApplication;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletDefinition;

public class JetspeedPortletFactory
implements PortletFactory {
    private HashMap portletCache = new HashMap();
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$factory$JetspeedPortletFactory == null ? (class$org$apache$jetspeed$factory$JetspeedPortletFactory = JetspeedPortletFactory.class$("org.apache.jetspeed.factory.JetspeedPortletFactory")) : class$org$apache$jetspeed$factory$JetspeedPortletFactory));
    private final HashMap classLoaderMap = new HashMap();
    static /* synthetic */ Class class$org$apache$jetspeed$factory$JetspeedPortletFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPortletApplication(PortletApplication pa, ClassLoader cl) {
        HashMap hashMap = this.classLoaderMap;
        synchronized (hashMap) {
            this.unregisterPortletApplication(pa);
            this.classLoaderMap.put(pa.getId().toString(), cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPortletApplication(PortletApplication pa) {
        HashMap hashMap = this.classLoaderMap;
        synchronized (hashMap) {
            HashMap hashMap2 = this.portletCache;
            synchronized (hashMap2) {
                ClassLoader cl = (ClassLoader)this.classLoaderMap.remove(pa.getId().toString());
                if (cl != null) {
                    ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
                    Iterator portletDefinitions = pa.getPortletDefinitions().iterator();
                    while (portletDefinitions.hasNext()) {
                        PortletDefinition pd = (PortletDefinition)portletDefinitions.next();
                        Portlet portlet = (Portlet)this.portletCache.remove(pd.getId().toString());
                        if (portlet == null) continue;
                        try {
                            Thread.currentThread().setContextClassLoader(cl);
                            portlet.destroy();
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletInstance getPortletInstance(ServletContext servletContext, PortletDefinition pd) throws PortletException {
        PortletInstance portlet = null;
        String portletName = pd.getId().toString();
        PortletApplication pa = (PortletApplication)pd.getPortletApplicationDefinition();
        try {
            HashMap hashMap = this.portletCache;
            synchronized (hashMap) {
                portlet = (PortletInstance)this.portletCache.get(portletName);
                if (null != portlet) {
                    return portlet;
                }
                ClassLoader paCl = (ClassLoader)this.classLoaderMap.get(pa.getId().toString());
                if (paCl == null) {
                    throw new UnavailableException("Portlet Application " + pa.getName() + " not available");
                }
                ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = paCl.loadClass(pd.getClassName());
                    try {
                        Thread.currentThread().setContextClassLoader(paCl);
                        portlet = new JetspeedPortletInstance((Portlet)clazz.newInstance());
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                    }
                }
                catch (Exception e) {
                    String msg = "Cannot create Portlet instance " + pd.getClassName() + " for Portlet Application " + pa.getName();
                    log.error((Object)msg, (Throwable)e);
                    throw new UnavailableException(msg);
                }
                PortletContext portletContext = PortalAccessor.createPortletContext((ServletContext)servletContext, (PortletApplicationDefinition)pa);
                PortletConfig portletConfig = PortalAccessor.createPortletConfig((PortletContext)portletContext, (PortletDefinition)pd);
                try {
                    try {
                        Thread.currentThread().setContextClassLoader(paCl);
                        portlet.init(portletConfig);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                    }
                }
                catch (PortletException e1) {
                    log.error((Object)("Failed to initialize Portlet " + pd.getClassName() + " for Portlet Application " + pa.getName()), (Throwable)e1);
                    throw e1;
                }
                this.portletCache.put(portletName, portlet);
            }
        }
        catch (PortletException pe) {
            throw pe;
        }
        catch (Throwable e) {
            log.error((Object)("PortletFactory: Failed to load portlet " + pd.getClassName()), e);
            throw new UnavailableException("Failed to load portlet " + pd.getClassName() + ": " + e.toString());
        }
        return portlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getPortletApplicationClassLoader(PortletApplication pa) {
        HashMap hashMap = this.classLoaderMap;
        synchronized (hashMap) {
            if (pa != null) {
                return (ClassLoader)this.classLoaderMap.get(pa.getId().toString());
            }
            return null;
        }
    }

    public boolean isPortletApplicationRegistered(PortletApplication pa) {
        return this.getPortletApplicationClassLoader(pa) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

