/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.velocity;

import java.io.Serializable;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.util.HashMap;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.security.PortletPermission;

public class PageActionAccess
implements Serializable {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$velocity$PageActionAccess == null ? (class$org$apache$jetspeed$velocity$PageActionAccess = PageActionAccess.class$("org.apache.jetspeed.velocity.PageActionAccess")) : class$org$apache$jetspeed$velocity$PageActionAccess));
    private boolean anonymous;
    private boolean editAllowed;
    private HashMap fragmentActionAccess;
    static /* synthetic */ Class class$org$apache$jetspeed$velocity$PageActionAccess;

    public PageActionAccess(boolean anonymous, Page page) {
        this.anonymous = anonymous;
        this.editAllowed = this.checkEditPage(page);
        this.fragmentActionAccess = new HashMap();
    }

    public void checkReset(boolean anonymous, Page page) {
        if (this.anonymous != anonymous) {
            this.anonymous = anonymous;
            this.editAllowed = this.checkEditPage(page);
            this.fragmentActionAccess.clear();
        }
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isEditAllowed() {
        return this.editAllowed;
    }

    public boolean checkPortletMode(String fragmentId, String portletName, PortletMode mode) {
        return this.checkActionAccess(fragmentId, portletName, mode.toString());
    }

    public boolean checkWindowState(String fragmentId, String portletName, WindowState state) {
        return this.checkActionAccess(fragmentId, portletName, state.toString());
    }

    protected synchronized boolean checkActionAccess(String fragmentId, String portletName, String action) {
        try {
            int actionIndex = this.getActionMask(action);
            ActionAccess actionAccess = (ActionAccess)this.fragmentActionAccess.get(fragmentId);
            if (actionAccess == null) {
                actionAccess = new ActionAccess();
                this.fragmentActionAccess.put(fragmentId, actionAccess);
            }
            if ((actionAccess.checkedFlags & actionIndex) != actionIndex) {
                boolean access = true;
                if (access) {
                    actionAccess.actionFlags |= actionIndex;
                }
                actionAccess.checkedFlags |= actionIndex;
            }
            return (actionAccess.actionFlags & actionIndex) == actionIndex;
        }
        catch (IndexOutOfBoundsException e) {
            log.error((Object)("Unknown action: " + action), (Throwable)e);
            return false;
        }
    }

    protected boolean checkPermission(String resource, String action) {
        try {
            AccessController.checkPermission((Permission)new PortletPermission(resource, action));
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }

    protected boolean checkEditPage(Page page) {
        boolean allowed = false;
        try {
            page.checkAccess("edit");
            allowed = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return allowed;
    }

    protected int getActionMask(String action) throws IndexOutOfBoundsException {
        int i = 0;
        while (!JetspeedActions.ACTIONS[i++].equals(action)) {
        }
        return 1 << i;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ActionAccess
    implements Serializable {
        int checkedFlags;
        int actionFlags;

        private ActionAccess() {
        }
    }
}

