/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.velocity;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.locator.LocatorDescriptor;
import org.apache.jetspeed.locator.TemplateDescriptor;
import org.apache.jetspeed.locator.TemplateLocator;
import org.apache.jetspeed.locator.TemplateLocatorException;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.velocity.JetspeedPowerTool;
import org.apache.portals.bridges.velocity.BridgesVelocityViewServlet;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;

public class JetspeedVelocityViewServlet
extends BridgesVelocityViewServlet {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$velocity$JetspeedVelocityViewServlet == null ? (class$org$apache$jetspeed$velocity$JetspeedVelocityViewServlet = JetspeedVelocityViewServlet.class$("org.apache.jetspeed.velocity.JetspeedVelocityViewServlet")) : class$org$apache$jetspeed$velocity$JetspeedVelocityViewServlet));
    private static final long DEFAULT_CACHE_SIZE = 50L;
    private static final String CACHE_SIZE_PARAMETER = "org.apache.jetspeed.cache.size";
    private static final long DEFAULT_CACHE_VALIDATION_INTERVAL = 10000L;
    private static final String CACHE_VALIDATION_INTERVAL_PARAMETER = "org.apache.jetspeed.cache.validation.interval";
    private static ThreadLocal handlingRequestContext = new ThreadLocal();
    private TemplateLocator decorationLocator;
    private Map velocityEngineConfigCache;
    private Map velocityEngineCache;
    private long cacheValidationInterval;
    static /* synthetic */ Class class$org$apache$jetspeed$velocity$JetspeedVelocityViewServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ComponentManager cm = Jetspeed.getComponentManager();
        if (null == cm) {
            throw new ServletException("Could not get Jetspeed Component Manager");
        }
        this.decorationLocator = (TemplateLocator)cm.getComponent((Object)"DecorationLocator");
        int cacheSize = (int)this.getLongInitParameter(config, CACHE_SIZE_PARAMETER, 50L);
        this.velocityEngineConfigCache = new LRUMap(cacheSize);
        this.velocityEngineCache = new LRUMap(cacheSize / 2);
        this.cacheValidationInterval = this.getLongInitParameter(config, CACHE_VALIDATION_INTERVAL_PARAMETER, 10000L);
    }

    protected Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context ctx) throws Exception {
        RequestContext requestContext;
        PortletRequest renderRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        RenderResponse renderResponse = (RenderResponse)request.getAttribute("javax.portlet.response");
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        if (renderRequest != null) {
            renderRequest.setAttribute("org.apache.velocity.Context", (Object)ctx);
        }
        if ((requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext")) == null) {
            throw new IllegalStateException("JetspeedVelocityViewServlet unable to handle request because there is no RequestContext in the HttpServletRequest.");
        }
        JetspeedPowerTool jpt = (JetspeedPowerTool)renderRequest.getAttribute("org.apache.jetspeed.velocity.JetspeedPowerTool");
        if (jpt == null) {
            throw new IllegalStateException("JetspeedVelocityViewServlet unable to handle request because there is no JetspeedPowerTool in the HttpServletRequest.");
        }
        jpt.setVelocityContext(ctx);
        ctx.put("jetspeed", (Object)jpt);
        ctx.put("JS2RequestContext", (Object)requestContext);
        ctx.put("renderRequest", (Object)renderRequest);
        ctx.put("renderResponse", (Object)renderResponse);
        ctx.put("portletConfig", (Object)portletConfig);
        ctx.put("portletModeView", (Object)PortletMode.VIEW);
        ctx.put("portletModeEdit", (Object)PortletMode.EDIT);
        ctx.put("portletModeHelp", (Object)PortletMode.HELP);
        ctx.put("windowStateNormal", (Object)WindowState.NORMAL);
        ctx.put("windowStateMinimized", (Object)WindowState.MINIMIZED);
        ctx.put("windowStateMaximized", (Object)WindowState.MAXIMIZED);
        StringBuffer appRoot = new StringBuffer(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(renderRequest.getContextPath());
        ctx.put("appRoot", (Object)appRoot.toString());
        handlingRequestContext.set(ctx);
        return super.handleRequest(request, response, ctx);
    }

    public Template getTemplate(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        VelocityEngine velocity;
        Context ctx = (Context)handlingRequestContext.get();
        if (ctx != null && (velocity = this.getVelocityEngine(ctx)) != null) {
            return velocity.getTemplate(name);
        }
        return super.getTemplate(name);
    }

    public Template getTemplate(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        VelocityEngine velocity;
        Context ctx = (Context)handlingRequestContext.get();
        if (ctx != null && (velocity = this.getVelocityEngine(ctx)) != null) {
            return velocity.getTemplate(name, encoding);
        }
        return super.getTemplate(name, encoding);
    }

    protected ExtendedProperties loadConfiguration(ServletConfig config) throws IOException {
        ExtendedProperties configuration = super.loadConfiguration(config);
        configuration.clearProperty("runtime.log.logsystem.class");
        configuration.clearProperty("runtime.log.logsystem.log4j.category");
        configuration.setProperty("runtime.log.logsystem", (Object)new VelocityEngineLogger());
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VelocityEngine getVelocityEngine(Context ctx) {
        RenderRequest renderRequest = (RenderRequest)ctx.get("renderRequest");
        RequestContext requestContext = (RequestContext)ctx.get("JS2RequestContext");
        JetspeedPowerTool jpt = (JetspeedPowerTool)ctx.get("jetspeed");
        if (renderRequest != null && requestContext != null) {
            Fragment layout = (Fragment)renderRequest.getAttribute("layout");
            if (layout == null) {
                layout = jpt.getCurrentFragment();
            }
            String layoutType = layout.getType();
            String layoutDecoration = layout.getDecorator();
            if (layoutDecoration == null) {
                ContentPage page = requestContext.getPage();
                layoutDecoration = page.getDefaultDecorator(layoutType);
            }
            CapabilityMap capabilityMap = requestContext.getCapabilityMap();
            Locale locale = requestContext.getLocale();
            String layoutMediaType = capabilityMap.getPreferredMediaType().getName();
            String layoutLanguage = locale.getLanguage();
            String layoutCountry = locale.getCountry();
            String cacheKey = layoutDecoration + ":" + layoutType + ":" + layoutMediaType + ":" + layoutLanguage + ":" + layoutCountry;
            VelocityEngineConfig config = null;
            Map map = this.velocityEngineConfigCache;
            synchronized (map) {
                config = (VelocityEngineConfig)this.velocityEngineConfigCache.get(cacheKey);
            }
            long now = System.currentTimeMillis();
            if (config != null && now <= config.lastValidated + this.cacheValidationInterval) {
                if (config.macros != null) {
                    Map map2 = this.velocityEngineCache;
                    synchronized (map2) {
                        VelocityEngine velocity = (VelocityEngine)this.velocityEngineCache.get(config.macros.getAbsolutePath());
                        if (velocity != null) {
                            return velocity;
                        }
                    }
                } else {
                    return null;
                }
            }
            TemplateDescriptor macrosDescriptor = null;
            LocatorDescriptor descriptor = null;
            try {
                descriptor = this.decorationLocator.createLocatorDescriptor(null);
            }
            catch (TemplateLocatorException tle) {
                log.error((Object)"getVelocityEngine(): unable create base descriptor", (Throwable)tle);
            }
            descriptor.setMediaType(layoutMediaType);
            descriptor.setCountry(layoutCountry);
            descriptor.setLanguage(layoutLanguage);
            descriptor.setType(layoutType);
            descriptor.setName(layoutDecoration + "/" + "decorator" + ".properties");
            TemplateDescriptor propertiesDescriptor = null;
            try {
                propertiesDescriptor = this.decorationLocator.locateTemplate(descriptor);
            }
            catch (TemplateLocatorException tle) {
                try {
                    descriptor.setType("generic");
                    propertiesDescriptor = this.decorationLocator.locateTemplate(descriptor);
                }
                catch (TemplateLocatorException tleFallback) {
                    // empty catch block
                }
            }
            PropertiesConfiguration configuration = null;
            if (propertiesDescriptor != null) {
                try {
                    configuration = new PropertiesConfiguration(propertiesDescriptor.getAbsolutePath());
                }
                catch (ConfigurationException ce) {
                    log.warn((Object)("getVelocityEngine(): unable read decorator properties from " + propertiesDescriptor.getAbsolutePath()), (Throwable)ce);
                }
            }
            if (configuration != null) {
                String ext = configuration.getString("template.extension");
                String macros = configuration.getString("template.macros");
                if (ext != null && ext.length() > 0 && macros != null && macros.length() > 0) {
                    descriptor.setName(layoutDecoration + "/" + "decorator" + macros + ext);
                    try {
                        macrosDescriptor = this.decorationLocator.locateTemplate(descriptor);
                    }
                    catch (TemplateLocatorException tle) {
                        try {
                            String parent = configuration.getString("extends");
                            if (parent != null && parent.length() > 0) {
                                descriptor.setName(parent + "/" + "decorator" + macros + ext);
                                macrosDescriptor = this.decorationLocator.locateTemplate(descriptor);
                            }
                        }
                        catch (TemplateLocatorException tleExtends) {
                            // empty catch block
                        }
                    }
                }
            }
            boolean newVelocityEngineConfig = false;
            boolean forceVelocityEngineRefresh = false;
            if (config == null) {
                config = new VelocityEngineConfig(layoutDecoration, layoutType, layoutMediaType, layoutLanguage, layoutCountry);
                Map tle = this.velocityEngineConfigCache;
                synchronized (tle) {
                    this.velocityEngineConfigCache.put(cacheKey, config);
                }
                newVelocityEngineConfig = true;
            }
            if (macrosDescriptor == null && config.macros != null || macrosDescriptor != null && config.macros == null || macrosDescriptor != null && config.macros != null && (!macrosDescriptor.getAbsolutePath().equals(config.macros.getAbsolutePath()) || config.macros.lastModified() != config.macrosLastModified)) {
                config.lastValidated = now;
                if (macrosDescriptor != null) {
                    config.macros = new File(macrosDescriptor.getAbsolutePath());
                    config.macrosLastModified = config.macros.lastModified();
                } else {
                    config.macros = null;
                    config.macrosLastModified = -1L;
                }
                forceVelocityEngineRefresh = !newVelocityEngineConfig;
            } else {
                config.lastValidated = now;
            }
            VelocityEngine velocity = null;
            if (macrosDescriptor != null && config.macros != null) {
                Map map3 = this.velocityEngineCache;
                synchronized (map3) {
                    if (!forceVelocityEngineRefresh) {
                        velocity = (VelocityEngine)this.velocityEngineCache.get(config.macros.getAbsolutePath());
                    }
                    if (velocity == null && (velocity = this.initVelocity(macrosDescriptor)) != null) {
                        this.velocityEngineCache.put(config.macros.getAbsolutePath(), velocity);
                    }
                }
            }
            return velocity;
        }
        return null;
    }

    private VelocityEngine initVelocity(TemplateDescriptor macros) {
        try {
            VelocityEngine velocity = new VelocityEngine();
            velocity.setApplicationAttribute((Object)SERVLET_CONTEXT_KEY, (Object)this.getServletContext());
            velocity.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.tools.view.servlet.ServletLogger");
            velocity.setProperty("resource.loader", (Object)"webapp");
            velocity.setProperty("webapp.resource.loader.class", (Object)"org.apache.velocity.tools.view.servlet.WebappLoader");
            ExtendedProperties configuration = this.loadConfiguration(this.getServletConfig());
            configuration.addProperty("velocimacro.library", (Object)macros.getAppRelativePath());
            velocity.setExtendedProperties(configuration);
            velocity.init();
            log.debug((Object)("initVelocity(): create new VelocityEngine instance to support " + macros.getAppRelativePath() + " decoration template macros"));
            return velocity;
        }
        catch (Exception e) {
            log.error((Object)"initVelocity(): unable to initialize velocity engine instance, using default singleton", (Throwable)e);
            return null;
        }
    }

    private long getLongInitParameter(ServletConfig config, String name, long defaultValue) {
        String value = config.getInitParameter(name);
        if (value == null || value.length() == 0) {
            value = config.getServletContext().getInitParameter(name);
        }
        if (value != null && value.length() > 0) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class VelocityEngineLogger
    implements LogSystem {
        private static final Log velocityLog = LogFactory.getLog((String)"velocity");

        private VelocityEngineLogger() {
        }

        public void init(RuntimeServices rsvc) {
        }

        public void logVelocityMessage(int level, String message) {
            switch (level) {
                case 0: {
                    velocityLog.debug((Object)message);
                    break;
                }
                case 1: {
                    velocityLog.info((Object)message);
                    break;
                }
                case 2: {
                    velocityLog.warn((Object)message);
                    break;
                }
                case 3: {
                    velocityLog.error((Object)message);
                    break;
                }
                default: {
                    velocityLog.trace((Object)message);
                }
            }
        }
    }

    private class VelocityEngineConfig {
        public String decoration;
        public String type;
        public String mediaType;
        public String language;
        public String country;
        public File macros;
        public long macrosLastModified;
        public long lastValidated;

        public VelocityEngineConfig(String decoration, String type, String mediaType, String language, String country) {
            this.decoration = decoration;
            this.type = type;
            this.mediaType = mediaType;
            this.language = language;
            this.country = country;
            this.macrosLastModified = -1L;
            this.lastValidated = System.currentTimeMillis();
        }
    }
}

