/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.velocity;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent;
import org.apache.jetspeed.components.portletentity.PortletEntityNotGeneratedException;
import org.apache.jetspeed.components.portletentity.PortletEntityNotStoredException;
import org.apache.jetspeed.container.state.NavigationalState;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.jetspeed.container.window.FailedToRetrievePortletWindow;
import org.apache.jetspeed.container.window.PortletWindowAccessor;
import org.apache.jetspeed.locator.LocatorDescriptor;
import org.apache.jetspeed.locator.TemplateDescriptor;
import org.apache.jetspeed.locator.TemplateLocator;
import org.apache.jetspeed.locator.TemplateLocatorException;
import org.apache.jetspeed.om.common.portlet.MutablePortletEntity;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.services.title.DynamicTitleService;
import org.apache.jetspeed.util.ArgUtil;
import org.apache.jetspeed.util.Path;
import org.apache.jetspeed.velocity.DecoratorAction;
import org.apache.jetspeed.velocity.JetspeedPowerTool;
import org.apache.jetspeed.velocity.PageActionAccess;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.ContentTypeSet;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.velocity.context.Context;

public class JetspeedPowerToolImpl
implements JetspeedPowerTool {
    private static final String DECORATOR_ID_ATTR = "decoratorId";
    private static final String ACTION_IMAGE_EXTENSION_ATTR = "actionImageExtension";
    protected static final String PORTLET_CONFIG_ATTR = "javax.portlet.config";
    protected static final String RENDER_RESPONSE_ATTR = "javax.portlet.response";
    protected static final String RENDER_REQUEST_ATTR = "javax.portlet.request";
    protected static final String COLUMNS_ATTR = "columns";
    protected static final String COLUMN_SIZES = "columnSizes";
    protected RenderRequest renderRequest;
    protected RenderResponse renderResponse;
    protected PortletConfig portletConfig;
    protected Writer templateWriter;
    protected static final String POWER_TOOL_SESSION_ACTIONS = "org.apache.jetspeed.powertool.actions";
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$velocity$JetspeedPowerToolImpl == null ? (class$org$apache$jetspeed$velocity$JetspeedPowerToolImpl = JetspeedPowerToolImpl.class$("org.apache.jetspeed.velocity.JetspeedPowerToolImpl")) : class$org$apache$jetspeed$velocity$JetspeedPowerToolImpl));
    protected CapabilityMap capabilityMap;
    protected Locale locale;
    protected LocatorDescriptor templateLocatorDescriptor;
    protected TemplateLocator templateLocator;
    protected PortletEntityAccessComponent entityAccess;
    protected TemplateLocator decorationLocator;
    protected LocatorDescriptor decorationLocatorDescriptor;
    protected PortletWindowAccessor windowAccess;
    protected RequestContext requestContext;
    protected Context velocityContext;
    private DynamicTitleService titleService;
    static /* synthetic */ Class class$org$apache$jetspeed$velocity$JetspeedPowerToolImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$container$window$PortletWindowAccessor;
    static /* synthetic */ Class class$org$apache$jetspeed$components$portletentity$PortletEntityAccessComponent;
    static /* synthetic */ Class class$java$lang$String;

    public JetspeedPowerToolImpl(RequestContext requestContext, DynamicTitleService titleService) throws Exception {
        HttpServletRequest request = requestContext.getRequest();
        this.requestContext = requestContext;
        this.titleService = titleService;
        this.windowAccess = (PortletWindowAccessor)this.getComponent((class$org$apache$jetspeed$container$window$PortletWindowAccessor == null ? (class$org$apache$jetspeed$container$window$PortletWindowAccessor = JetspeedPowerToolImpl.class$("org.apache.jetspeed.container.window.PortletWindowAccessor")) : class$org$apache$jetspeed$container$window$PortletWindowAccessor).getName());
        this.entityAccess = (PortletEntityAccessComponent)this.getComponent((class$org$apache$jetspeed$components$portletentity$PortletEntityAccessComponent == null ? (class$org$apache$jetspeed$components$portletentity$PortletEntityAccessComponent = JetspeedPowerToolImpl.class$("org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent")) : class$org$apache$jetspeed$components$portletentity$PortletEntityAccessComponent).getName());
        this.renderRequest = (RenderRequest)request.getAttribute(RENDER_REQUEST_ATTR);
        this.renderResponse = (RenderResponse)request.getAttribute(RENDER_RESPONSE_ATTR);
        this.portletConfig = (PortletConfig)request.getAttribute(PORTLET_CONFIG_ATTR);
        this.templateLocator = (TemplateLocator)this.getComponent("TemplateLocator");
        this.decorationLocator = (TemplateLocator)this.getComponent("DecorationLocator");
        this.capabilityMap = requestContext.getCapabilityMap();
        this.locale = requestContext.getLocale();
        this.templateLocatorDescriptor = this.templateLocator.createLocatorDescriptor(null);
        this.templateLocatorDescriptor.setMediaType(this.capabilityMap.getPreferredMediaType().getName());
        this.templateLocatorDescriptor.setCountry(this.locale.getCountry());
        this.templateLocatorDescriptor.setLanguage(this.locale.getLanguage());
        this.decorationLocatorDescriptor = this.decorationLocator.createLocatorDescriptor(null);
        this.decorationLocatorDescriptor.setMediaType(this.capabilityMap.getPreferredMediaType().getName());
        this.decorationLocatorDescriptor.setCountry(this.locale.getCountry());
        this.decorationLocatorDescriptor.setLanguage(this.locale.getLanguage());
    }

    protected final RequestContext getRequestContext() {
        return this.requestContext;
    }

    public WindowState getWindowState() throws Exception {
        try {
            NavigationalState nav = this.getRequestContext().getPortalURL().getNavigationalState();
            return nav.getState(this.windowAccess.getPortletWindow(this.getCurrentFragment()));
        }
        catch (Exception e) {
            this.handleError(e, e.toString(), this.getCurrentFragment());
            return null;
        }
    }

    public PortletMode getPortletMode() throws Exception {
        NavigationalState nav = this.getRequestContext().getPortalURL().getNavigationalState();
        try {
            return nav.getMode(this.windowAccess.getPortletWindow(this.getCurrentFragment()));
        }
        catch (FailedToRetrievePortletWindow e) {
            this.handleError((Exception)((Object)e), e.toString(), this.getCurrentFragment());
            return null;
        }
    }

    public ContentFragment getCurrentFragment() {
        this.checkState();
        return (ContentFragment)this.renderRequest.getAttribute("org.apache.jetspeed.Fragment");
    }

    public void setCurrentFragment(ContentFragment f) {
        this.checkState();
        this.setAttribute("org.apache.jetspeed.Fragment", f);
    }

    public void setCurrentLayout() {
        this.checkState();
        ContentFragment f = (ContentFragment)this.getRequestContext().getRequest().getAttribute("layout");
        this.setAttribute("layout", f);
    }

    public ContentFragment getCurrentLayout() {
        this.checkState();
        return (ContentFragment)this.renderRequest.getAttribute("layout");
    }

    public Page getPage() {
        this.checkState();
        return this.requestContext.getPage();
    }

    public List[] getColumns() {
        this.checkState();
        return (List[])this.renderRequest.getAttribute(COLUMNS_ATTR);
    }

    public List getColumnSizes() {
        this.checkState();
        Object o = this.renderRequest.getAttribute(COLUMN_SIZES);
        if (o == null) {
            return null;
        }
        return (List)this.renderRequest.getAttribute(COLUMN_SIZES);
    }

    public PortletEntity getCurrentPortletEntity() throws Exception {
        try {
            return this.windowAccess.getPortletWindow(this.getCurrentFragment()).getPortletEntity();
        }
        catch (Exception e) {
            this.handleError(e, "JetspeedPowerTool failed to retreive the current PortletEntity.  " + e.toString(), this.getCurrentFragment());
            return null;
        }
    }

    public PortletEntity getPortletEntity(ContentFragment f) throws Exception {
        MutablePortletEntity portletEntity = this.entityAccess.getPortletEntityForFragment(f);
        if (portletEntity == null) {
            try {
                portletEntity = this.entityAccess.generateEntityFromFragment(f);
                this.entityAccess.storePortletEntity((PortletEntity)portletEntity);
            }
            catch (PortletEntityNotGeneratedException e) {
                String msg = "JetspeedPowerTool failed to retreive a PortletEntity for Fragment " + f.getId() + ".  " + e.toString();
                this.handleError((Exception)((Object)e), msg, f);
            }
            catch (PortletEntityNotStoredException e) {
                String msg = "JetspeedPowerTool failed to store a PortletEntity for Fragment " + f.getId() + ".  " + e.toString();
                this.handleError((Exception)((Object)e), msg, f);
            }
        }
        return portletEntity;
    }

    public boolean isHidden(ContentFragment f) {
        this.checkState();
        if (f == null) {
            throw new IllegalArgumentException("Fragment cannot be null for isHidden(Fragment)");
        }
        return f.getState() != null && f.getState().equals("hidden");
    }

    public TemplateDescriptor getTemplate(String path, String templateType) throws TemplateLocatorException {
        this.checkState();
        return this.getTemplate(path, templateType, this.templateLocator, this.templateLocatorDescriptor);
    }

    public Configuration getTypeConfiguration(String type, String name, String location) throws Exception {
        ArgUtil.assertNotNull((Class)(class$java$lang$String == null ? (class$java$lang$String = JetspeedPowerToolImpl.class$("java.lang.String")) : class$java$lang$String), (Object)type, (Object)this, (String)"getTypeConfiguration(String type, String name)");
        ArgUtil.assertNotNull((Class)(class$java$lang$String == null ? (class$java$lang$String = JetspeedPowerToolImpl.class$("java.lang.String")) : class$java$lang$String), (Object)name, (Object)this, (String)"getTypeConfiguration(String type, String name)");
        try {
            TemplateDescriptor locator = null;
            if (location.equals("templates")) {
                locator = this.getTemplate(name + "/" + type + ".properties", type);
            } else if (location.equals("decorations")) {
                locator = this.getDecoration(name + "/decorator.properties", type);
            } else {
                throw new IllegalArgumentException("Location type " + location + " is not supported by getTypeConfiguration().");
            }
            return new PropertiesConfiguration(locator.getAbsolutePath());
        }
        catch (TemplateLocatorException e) {
            log.warn((Object)e.toString(), (Throwable)e);
            return null;
        }
    }

    public TemplateDescriptor getDecoration(String path, String templateType) throws TemplateLocatorException {
        this.checkState();
        return this.getTemplate(path, templateType, this.decorationLocator, this.decorationLocatorDescriptor);
    }

    public String includeTemplate(String template, String templateType) throws IOException {
        this.checkState();
        try {
            TemplateDescriptor useLocator = this.getTemplate(template, templateType);
            return useLocator.getAppRelativePath();
        }
        catch (Exception e) {
            PrintWriter directError = new PrintWriter(this.renderResponse.getWriter());
            directError.write("Error occured process includeTemplate(): " + e.toString() + "\n\n");
            e.printStackTrace(directError);
            directError.close();
            return null;
        }
    }

    public String includeDecoration(String template, String templateType) throws IOException {
        this.checkState();
        try {
            return this.getDecoration(template, templateType).getAppRelativePath();
        }
        catch (Exception e) {
            PrintWriter directError = new PrintWriter(this.renderResponse.getWriter());
            directError.write("Error occured process includeDecoration(): " + e.toString() + "\n\n");
            e.printStackTrace(directError);
            directError.close();
            return null;
        }
    }

    public String decorateAndInclude(ContentFragment f) throws Exception {
        this.setCurrentFragment(f);
        this.setCurrentLayout();
        try {
            String fragmentType = f.getType();
            return this.decorateAndIncludePortlet(f);
        }
        catch (Exception e) {
            this.renderResponse.getWriter().write(e.toString());
            return null;
        }
    }

    protected String decorateAndIncludePortlet(ContentFragment f) throws Exception {
        TemplateDescriptor template;
        PropertiesConfiguration decoConf;
        block4: {
            TemplateDescriptor propsTemp;
            String fragmentType = f.getType();
            String decorator = f.getDecorator();
            if (decorator == null) {
                decorator = this.getPage().getDefaultDecorator(fragmentType);
            }
            if ((propsTemp = this.getTemplate(decorator + "/" + "decorator" + ".properties", fragmentType, this.decorationLocator, this.decorationLocatorDescriptor)) == null) {
                fragmentType = "generic";
                propsTemp = this.getTemplate(decorator + "/" + "decorator" + ".properties", fragmentType, this.decorationLocator, this.decorationLocatorDescriptor);
            }
            decoConf = new PropertiesConfiguration(propsTemp.getAbsolutePath());
            String ext = decoConf.getString("template.extension");
            String decoratorPath = decorator + "/" + "decorator" + ext;
            template = null;
            try {
                template = this.getDecoration(decoratorPath, fragmentType);
            }
            catch (TemplateLocatorException e) {
                String parent = decoConf.getString("extends");
                if (parent == null) break block4;
                template = this.getDecoration(parent + "/" + "decorator" + ext, fragmentType);
            }
        }
        this.setAttribute(DECORATOR_ID_ATTR, decoConf.getString("id"));
        this.setAttribute(ACTION_IMAGE_EXTENSION_ATTR, decoConf.getString("action.image.extension", ".gif"));
        return template.getAppRelativePath();
    }

    protected void checkState() {
        if (this.portletConfig == null || this.renderRequest == null || this.renderResponse == null) {
            throw new IllegalStateException("JetspeedPowerTool has not been properly initialized.  The JetspeedPowerTool generally only usuable during the rendering phase of  internal portlet applications.");
        }
    }

    protected TemplateDescriptor getTemplate(String path, String templateType, TemplateLocator locator, LocatorDescriptor descriptor) throws TemplateLocatorException {
        this.checkState();
        if (templateType == null) {
            templateType = "generic";
        }
        try {
            Path pathObject;
            descriptor.setName(path);
            descriptor.setType(templateType);
            TemplateDescriptor template = locator.locateTemplate(descriptor);
            if (template == null && (pathObject = new Path(path)).length() > 1) {
                template = this.getTemplate(pathObject.getSegment(1).toString(), templateType, locator, descriptor);
            }
            return template;
        }
        catch (TemplateLocatorException e) {
            log.error((Object)("Unable to locate template: " + path), (Throwable)e);
            System.out.println("Unable to locate template: " + path);
            throw e;
        }
    }

    protected void handleError(Exception e, String msg, ContentFragment fragment) {
        log.error((Object)msg, (Throwable)e);
        HashSet<Exception> exceptions = (HashSet<Exception>)this.renderRequest.getAttribute("fragment.processing.error." + fragment.getId());
        if (exceptions == null) {
            exceptions = new HashSet<Exception>();
            this.setAttribute("fragment.processing.error." + fragment.getId(), exceptions);
        }
        exceptions.add(e);
    }

    public List getDecoratorActions() {
        return this.getDecoratorActions(false);
    }

    public List getPageDecoratorActions() throws Exception {
        return this.getDecoratorActions(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getDecoratorActions(boolean layout) {
        try {
            String key = this.getPage().getId();
            boolean anonymous = !this.getLoggedOn();
            PageActionAccess pageActionAccess = null;
            HttpSession httpSession = this.getRequestContext().getRequest().getSession();
            synchronized (httpSession) {
                HashMap<String, PageActionAccess> sessionActions = (HashMap<String, PageActionAccess>)this.getRequestContext().getSessionAttribute(POWER_TOOL_SESSION_ACTIONS);
                if (sessionActions == null) {
                    sessionActions = new HashMap<String, PageActionAccess>();
                    this.getRequestContext().setSessionAttribute(POWER_TOOL_SESSION_ACTIONS, sessionActions);
                } else {
                    pageActionAccess = (PageActionAccess)sessionActions.get(key);
                }
                if (pageActionAccess == null) {
                    pageActionAccess = new PageActionAccess(anonymous, this.getPage());
                    sessionActions.put(key, pageActionAccess);
                } else {
                    pageActionAccess.checkReset(this.getLoggedOn(), this.getPage());
                }
            }
            PortletDefinitionComposite portlet = (PortletDefinitionComposite)this.getCurrentPortletEntity().getPortletDefinition();
            if (null == portlet) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<DecoratorAction> actions = new ArrayList<DecoratorAction>();
            PortletMode mode = this.getPortletMode();
            WindowState state = this.getWindowState();
            ContentTypeSet content = portlet.getContentTypeSet();
            ContentFragment fragment = this.getCurrentFragment();
            String fragmentId = fragment.getId();
            String portletName = portlet.getUniqueName();
            PortletWindow window = this.windowAccess.getPortletWindow(fragment);
            String resourceBase = this.getPageBasePath();
            if (!layout || pageActionAccess.isEditAllowed()) {
                if (mode.equals((Object)PortletMode.VIEW)) {
                    if (content.supportsPortletMode(PortletMode.EDIT) && pageActionAccess.isEditAllowed() && pageActionAccess.checkPortletMode(fragmentId, portletName, PortletMode.EDIT)) {
                        actions.add(this.createPortletModeAction(window, JetspeedActions.EDIT, PortletMode.EDIT, resourceBase));
                    }
                    if (content.supportsPortletMode(PortletMode.HELP) && pageActionAccess.checkPortletMode(fragmentId, portletName, PortletMode.HELP)) {
                        actions.add(this.createPortletModeAction(window, JetspeedActions.HELP, PortletMode.HELP, resourceBase));
                    }
                } else if (mode.equals((Object)PortletMode.EDIT)) {
                    if (pageActionAccess.checkPortletMode(fragmentId, portletName, PortletMode.VIEW)) {
                        actions.add(this.createPortletModeAction(window, JetspeedActions.VIEW, PortletMode.VIEW, resourceBase));
                    }
                    if (content.supportsPortletMode(PortletMode.HELP) && pageActionAccess.checkPortletMode(fragmentId, portletName, PortletMode.HELP)) {
                        actions.add(this.createPortletModeAction(window, JetspeedActions.HELP, PortletMode.HELP, resourceBase));
                    }
                } else {
                    if (pageActionAccess.checkPortletMode(fragmentId, portletName, PortletMode.VIEW)) {
                        actions.add(this.createPortletModeAction(window, JetspeedActions.VIEW, PortletMode.VIEW, resourceBase));
                    }
                    if (content.supportsPortletMode(PortletMode.EDIT) && pageActionAccess.isEditAllowed() && pageActionAccess.checkPortletMode(fragmentId, portletName, PortletMode.EDIT)) {
                        actions.add(this.createPortletModeAction(window, JetspeedActions.EDIT, PortletMode.EDIT, resourceBase));
                    }
                }
            }
            if (!layout) {
                if (state.equals((Object)WindowState.NORMAL)) {
                    if (pageActionAccess.checkWindowState(fragmentId, portletName, WindowState.MINIMIZED)) {
                        actions.add(this.createWindowStateAction(window, JetspeedActions.MINIMIZE, WindowState.MINIMIZED, resourceBase));
                    }
                    if (pageActionAccess.checkWindowState(fragmentId, portletName, WindowState.MAXIMIZED)) {
                        actions.add(this.createWindowStateAction(window, JetspeedActions.MAXIMIZE, WindowState.MAXIMIZED, resourceBase));
                    }
                } else if (state.equals((Object)WindowState.MAXIMIZED)) {
                    if (pageActionAccess.checkWindowState(fragmentId, portletName, WindowState.MINIMIZED)) {
                        actions.add(this.createWindowStateAction(window, JetspeedActions.MINIMIZE, WindowState.MINIMIZED, resourceBase));
                    }
                    if (pageActionAccess.checkWindowState(fragmentId, portletName, JetspeedActions.RESTORED)) {
                        actions.add(this.createWindowStateAction(window, JetspeedActions.RESTORE, WindowState.NORMAL, resourceBase));
                    }
                } else {
                    if (pageActionAccess.checkWindowState(fragmentId, portletName, WindowState.MAXIMIZED)) {
                        actions.add(this.createWindowStateAction(window, JetspeedActions.MAXIMIZE, WindowState.MAXIMIZED, resourceBase));
                    }
                    if (pageActionAccess.checkWindowState(fragmentId, portletName, JetspeedActions.RESTORED)) {
                        actions.add(this.createWindowStateAction(window, JetspeedActions.RESTORE, WindowState.NORMAL, resourceBase));
                    }
                }
            }
            return actions;
        }
        catch (Exception e) {
            log.warn((Object)("Unable to generate decortator actions: " + e.toString()));
            return Collections.EMPTY_LIST;
        }
    }

    protected DecoratorAction createDecoratorAction(String resourceBase, String actionName) {
        String imageExt = (String)this.renderRequest.getAttribute(ACTION_IMAGE_EXTENSION_ATTR);
        if (imageExt == null) {
            imageExt = ".gif";
        }
        String link = this.renderResponse.encodeURL(resourceBase + "/content/images/" + actionName + ".gif");
        return new DecoratorAction(actionName, actionName, link);
    }

    protected DecoratorAction createPortletModeAction(PortletWindow window, String actionName, PortletMode mode, String resourceBase) {
        DecoratorAction action = this.createDecoratorAction(resourceBase, actionName);
        PortalURL portalURL = this.getRequestContext().getPortalURL();
        action.setAction(this.renderResponse.encodeURL(portalURL.createPortletURL(window, mode, null, portalURL.isSecure()).toString()));
        return action;
    }

    protected DecoratorAction createWindowStateAction(PortletWindow window, String actionName, WindowState state, String resourceBase) {
        DecoratorAction action = this.createDecoratorAction(resourceBase, actionName);
        PortalURL portalURL = this.getRequestContext().getPortalURL();
        action.setAction(this.renderResponse.encodeURL(portalURL.createPortletURL(window, null, state, portalURL.isSecure()).toString()));
        return action;
    }

    public String getTitle(PortletEntity entity, ContentFragment f) {
        String title = null;
        if (f != null) {
            title = f.getTitle();
        }
        if (title == null) {
            title = this.getTitle(entity);
        }
        return title;
    }

    public String getTitle(PortletEntity entity) {
        try {
            return this.titleService.getDynamicTitle(this.windowAccess.getPortletWindow(this.getCurrentFragment()), this.getRequestContext().getRequest());
        }
        catch (Exception e) {
            log.error((Object)("Unable to reteive portlet title: " + e.getMessage()), (Throwable)e);
            return "Title Error: " + e.getMessage();
        }
    }

    public Object getComponent(String name) {
        return Jetspeed.getComponentManager().getComponent((Object)name);
    }

    public String getAbsoluteUrl(String relativePath) {
        if (relativePath != null && relativePath.indexOf("://") == -1) {
            HttpServletRequest request = this.getRequestContext().getRequest();
            StringBuffer path = new StringBuffer();
            return this.renderResponse.encodeURL(path.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(request.getContextPath()).append(request.getServletPath()).append(relativePath).toString());
        }
        return relativePath;
    }

    public Subject getSubject() {
        return this.requestContext.getSubject();
    }

    public boolean getLoggedOn() {
        Principal principal = this.requestContext.getRequest().getUserPrincipal();
        return principal != null;
    }

    public String getBasePath() {
        return this.getRequestContext().getPortalURL().getBasePath();
    }

    public String getPageBasePath() {
        return this.getRequestContext().getPortalURL().getPageBasePath();
    }

    public void setVelocityContext(Context velocityContext) {
        this.velocityContext = velocityContext;
    }

    protected void setAttribute(String name, Object object) {
        this.renderRequest.setAttribute(name, object);
        if (this.velocityContext != null) {
            this.velocityContext.put(name, object);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

