/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.descriptor;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.servlet.MutableWebApplication;
import org.apache.jetspeed.tools.deploy.JetspeedWebApplicationRewriter;
import org.apache.jetspeed.tools.pamanager.PortletApplicationException;
import org.apache.jetspeed.util.DirectoryHelper;
import org.apache.jetspeed.util.FileSystemHelper;
import org.apache.jetspeed.util.descriptor.ExtendedPortletMetadata;
import org.apache.jetspeed.util.descriptor.MetaDataException;
import org.apache.jetspeed.util.descriptor.PortletApplicationDescriptor;
import org.apache.jetspeed.util.descriptor.WebApplicationDescriptor;
import org.apache.pluto.om.common.SecurityRoleRef;
import org.apache.pluto.om.common.SecurityRoleRefSet;
import org.apache.pluto.om.common.SecurityRoleSet;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PortletApplicationWar {
    protected static final String WEB_XML_STRING = "<?xml version='1.0' encoding='ISO-8859-1'?><!DOCTYPE web-app PUBLIC '-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN' 'http://java.sun.com/dtd/web-app_2_3.dtd'>\n<web-app></web-app>";
    protected static final String PORTLET_XML_PATH = "WEB-INF/portlet.xml";
    protected static final String WEB_XML_PATH = "WEB-INF/web.xml";
    protected static final String EXTENDED_PORTLET_XML_PATH = "WEB-INF/jetspeed-portlet.xml";
    public static final String JETSPEED_SERVLET_XPATH = "/web-app/servlet/servlet-name[contains(child::text(), \"JetspeedContainer\")]";
    public static final String JETSPEED_SERVLET_MAPPING_XPATH = "/web-app/servlet-mapping/servlet-name[contains(child::text(), \"JetspeedContainer\")]";
    protected static final Log log = LogFactory.getLog((String)"deployment");
    protected String paName;
    protected String webAppContextRoot;
    protected FileSystemHelper warStruct;
    private MutableWebApplication webApp;
    private MutablePortletApplication portletApp;
    private long paChecksum;
    protected final List openedResources;
    protected static final String[] ELEMENTS_BEFORE_SERVLET = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet"};
    protected static final String[] ELEMENTS_BEFORE_SERVLET_MAPPING = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping"};

    public PortletApplicationWar(FileSystemHelper warStruct, String paName, String webAppContextRoot) throws IOException {
        this.validatePortletApplicationName(paName);
        this.paName = paName;
        this.webAppContextRoot = webAppContextRoot;
        this.openedResources = new ArrayList();
        this.warStruct = warStruct;
        this.paChecksum = warStruct.getChecksum(PORTLET_XML_PATH);
        if (this.paChecksum == 0L) {
            throw new IOException("Cannot find required WEB-INF/portlet.xml for Portlet Application " + paName);
        }
    }

    public long getPortletApplicationChecksum() {
        return this.paChecksum;
    }

    private void validatePortletApplicationName(String paName) {
        if (paName == null || paName.startsWith("/") || paName.startsWith("\\") || paName.endsWith("/") || paName.endsWith("\\")) {
            throw new IllegalStateException("Invalid paName \"" + paName + "\".  paName cannot be null nor can it begin nor end with any slashes.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableWebApplication createWebApp() throws PortletApplicationException, IOException {
        MutableWebApplication mutableWebApplication;
        Reader webXmlReader = this.getReader(WEB_XML_PATH);
        try {
            WebApplicationDescriptor webAppDescriptor = new WebApplicationDescriptor(webXmlReader, this.webAppContextRoot);
            mutableWebApplication = this.webApp = webAppDescriptor.createWebApplication();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (webXmlReader != null) {
                    webXmlReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (webXmlReader != null) {
                webXmlReader.close();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return mutableWebApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutablePortletApplication createPortletApp(ClassLoader classLoader) throws PortletApplicationException, IOException {
        Reader portletXmlReader = this.getReader(PORTLET_XML_PATH);
        try {
            PortletApplicationDescriptor paDescriptor = new PortletApplicationDescriptor(portletXmlReader, this.paName);
            this.portletApp = paDescriptor.createPortletApplication(classLoader);
            Reader extMetaDataXml = null;
            try {
                extMetaDataXml = this.getReader(EXTENDED_PORTLET_XML_PATH);
                if (extMetaDataXml != null) {
                    ExtendedPortletMetadata extMetaData = new ExtendedPortletMetadata(extMetaDataXml, this.portletApp);
                    extMetaData.load();
                }
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    log.info((Object)"No extended metadata found.");
                } else {
                    log.warn((Object)("Failed to load existing metadata: " + e.toString()));
                }
            }
            catch (MetaDataException e) {
                log.warn((Object)("Failed to load existing metadata.  " + e.toString()), (Throwable)((Object)e));
            }
            finally {
                if (null != extMetaDataXml) {
                    extMetaDataXml.close();
                }
            }
            this.portletApp.setChecksum(this.paChecksum);
            MutablePortletApplication mutablePortletApplication = this.portletApp;
            return mutablePortletApplication;
        }
        finally {
            if (portletXmlReader != null) {
                portletXmlReader.close();
            }
        }
    }

    public MutablePortletApplication createPortletApp() throws PortletApplicationException, IOException {
        return this.createPortletApp(this.getClass().getClassLoader());
    }

    protected Reader getReader(String path) throws IOException {
        return new InputStreamReader(this.getInputStream(path));
    }

    protected InputStream getInputStream(String path) throws IOException {
        File child = new File(this.warStruct.getRootDirectory(), path);
        if (child == null || !child.exists()) {
            throw new FileNotFoundException("Unable to locate file or path " + child);
        }
        FileInputStream fileInputStream = new FileInputStream(child);
        this.openedResources.add(fileInputStream);
        return fileInputStream;
    }

    protected OutputStream getOutputStream(String path) throws IOException {
        File child = new File(this.warStruct.getRootDirectory(), path);
        if (child == null) {
            throw new FileNotFoundException("Unable to locate file or path " + child);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(child);
        this.openedResources.add(fileOutputStream);
        return fileOutputStream;
    }

    protected Writer getWriter(String path) throws IOException {
        return new OutputStreamWriter(this.getOutputStream(path));
    }

    public PortletApplicationWar copyWar(String targetAppRoot) throws IOException {
        DirectoryHelper target = new DirectoryHelper(new File(targetAppRoot));
        try {
            target.copyFrom(this.warStruct.getRootDirectory());
            PortletApplicationWar portletApplicationWar = new PortletApplicationWar((FileSystemHelper)target, this.paName, this.webAppContextRoot);
            return portletApplicationWar;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            target.close();
        }
    }

    public void removeWar() throws IOException {
        if (!this.warStruct.getRootDirectory().exists()) {
            throw new FileNotFoundException("PortletApplicationWar ," + this.warStruct.getRootDirectory() + ", does not exist.");
        }
        this.warStruct.remove();
    }

    public void validate() throws PortletApplicationException {
        if (this.portletApp == null || this.webApp == null) {
            throw new IllegalStateException("createWebApp() and createPortletApp() must be called before invoking validate()");
        }
        SecurityRoleSet roles = this.webApp.getSecurityRoles();
        Collection portlets = this.portletApp.getPortletDefinitions();
        Iterator portletIterator = portlets.iterator();
        while (portletIterator.hasNext()) {
            PortletDefinition portlet = (PortletDefinition)portletIterator.next();
            SecurityRoleRefSet securityRoleRefs = portlet.getInitSecurityRoleRefSet();
            Iterator roleRefsIterator = securityRoleRefs.iterator();
            while (roleRefsIterator.hasNext()) {
                SecurityRoleRef roleRef = (SecurityRoleRef)roleRefsIterator.next();
                String roleName = roleRef.getRoleLink();
                if (roleName == null || roleName.length() == 0) {
                    roleName = roleRef.getRoleName();
                }
                if (roles.get(roleName) != null) continue;
                String errorMsg = "Undefined security role " + roleName + " referenced from portlet " + portlet.getName();
                throw new PortletApplicationException(errorMsg);
            }
        }
    }

    /*
     * Loose catch block
     */
    public void processWebXML() throws MetaDataException {
        block19: {
            IOException e122;
            InputStream webXmlIn;
            Writer webXmlWriter;
            block18: {
                block17: {
                    String path;
                    SAXBuilder builder = new SAXBuilder();
                    webXmlWriter = null;
                    webXmlIn = null;
                    builder.setEntityResolver(new EntityResolver(){

                        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                            if (systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd")) {
                                return new InputSource(this.getClass().getResourceAsStream("web-app_2_3.dtd"));
                            }
                            return null;
                        }
                    });
                    Document doc = null;
                    try {
                        webXmlIn = this.getInputStream(WEB_XML_PATH);
                        doc = builder.build(webXmlIn);
                    }
                    catch (FileNotFoundException fnfe) {
                        File file = File.createTempFile("j2-temp-", ".xml");
                        FileWriter writer = new FileWriter(file);
                        writer.write(WEB_XML_STRING);
                        writer.close();
                        doc = builder.build(file);
                        file.delete();
                    }
                    if (webXmlIn != null) {
                        webXmlIn.close();
                    }
                    JetspeedWebApplicationRewriter rewriter = new JetspeedWebApplicationRewriter(doc);
                    rewriter.processWebXML();
                    if (rewriter.isChanged()) {
                        System.out.println("Writing out infused web.xml for " + this.paName);
                        XMLOutputter output = new XMLOutputter(Format.getPrettyFormat());
                        webXmlWriter = this.getWriter(WEB_XML_PATH);
                        output.output(doc, webXmlWriter);
                        webXmlWriter.flush();
                    }
                    if (!rewriter.isPortletTaglibAdded() || (path = Jetspeed.getRealPath("WEB-INF/tld")) == null) break block17;
                    File portletTaglibDir = new File(path);
                    File child = new File(this.warStruct.getRootDirectory(), "WEB-INF/tld");
                    DirectoryHelper dh = new DirectoryHelper(child);
                    dh.copyFrom(portletTaglibDir, new FileFilter(){

                        public boolean accept(File pathname) {
                            return pathname.getName().indexOf("portlet.tld") != -1;
                        }
                    });
                    dh.close();
                }
                Object var11_12 = null;
                if (webXmlWriter == null) break block18;
                try {
                    webXmlWriter.close();
                }
                catch (IOException e122) {
                    // empty catch block
                }
            }
            if (webXmlIn != null) {
                try {
                    webXmlIn.close();
                }
                catch (IOException e122) {}
            }
            break block19;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    throw new MetaDataException("Unable to process web.xml for infusion " + e.toString(), e);
                }
            }
            catch (Throwable throwable) {
                IOException e122;
                Object var11_13 = null;
                if (webXmlWriter != null) {
                    try {
                        webXmlWriter.close();
                    }
                    catch (IOException e122) {
                        // empty catch block
                    }
                }
                if (webXmlIn != null) {
                    try {
                        webXmlIn.close();
                    }
                    catch (IOException e122) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public void close() throws IOException {
        Iterator resources = this.openedResources.iterator();
        while (resources.hasNext()) {
            try {
                Object res = resources.next();
                if (res instanceof InputStream) {
                    ((InputStream)res).close();
                    continue;
                }
                if (!(res instanceof OutputStream)) continue;
                ((OutputStream)res).close();
            }
            catch (Exception exception) {}
        }
    }

    public ClassLoader createClassloader(ClassLoader parent) throws IOException {
        File webInfLib;
        ArrayList<URL> urls = new ArrayList<URL>();
        File webInfClasses = null;
        webInfClasses = new File(this.warStruct.getRootDirectory(), "WEB-INF/classes/");
        if (webInfClasses.exists()) {
            log.info((Object)("Adding " + webInfClasses.toURL() + " to class path."));
            urls.add(webInfClasses.toURL());
        }
        if ((webInfLib = new File(this.warStruct.getRootDirectory(), "WEB-INF/lib")).exists()) {
            File[] jars = webInfLib.listFiles();
            for (int i = 0; i < jars.length; ++i) {
                File jar = jars[i];
                log.info((Object)("Adding " + jar.toURL() + " to class path."));
                urls.add(jar.toURL());
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }

    public String getPortletApplicationName() {
        return this.paName;
    }

    public String getDeployedPath() {
        try {
            return this.warStruct.getRootDirectory().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public FileSystemHelper getFileSystem() {
        return this.warStruct;
    }
}

