/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.descriptor;

import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.om.common.Support;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.om.portlet.impl.PortletApplicationDefinitionImpl;
import org.apache.jetspeed.tools.pamanager.PortletApplicationException;
import org.apache.jetspeed.util.descriptor.PortletApplicationRule;
import org.apache.jetspeed.util.descriptor.PortletPreferenceRuleSet;
import org.apache.jetspeed.util.descriptor.PortletRule;
import org.apache.pluto.om.common.SecurityRoleRef;
import org.apache.pluto.om.common.SecurityRoleRefSet;
import org.apache.pluto.om.common.SecurityRoleSet;
import org.apache.pluto.om.portlet.PortletDefinition;

public class PortletApplicationDescriptor {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$util$descriptor$PortletApplicationDescriptor == null ? (class$org$apache$jetspeed$util$descriptor$PortletApplicationDescriptor = PortletApplicationDescriptor.class$("org.apache.jetspeed.util.descriptor.PortletApplicationDescriptor")) : class$org$apache$jetspeed$util$descriptor$PortletApplicationDescriptor));
    protected Reader portletXmlReader;
    private String appName;
    static /* synthetic */ Class class$org$apache$jetspeed$util$descriptor$PortletApplicationDescriptor;
    static /* synthetic */ Class class$org$apache$jetspeed$om$impl$PortletDisplayNameImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$impl$PortletDescriptionImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$impl$PortletInitParameterImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$impl$ParameterDescriptionImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$portlet$impl$ContentTypeImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$impl$LanguageImpl;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$jetspeed$om$impl$UserAttributeImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$impl$SecurityRoleRefImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$impl$SecurityRoleRefDescriptionImpl;

    public PortletApplicationDescriptor(Reader portletXmlReader, String appName) {
        this.portletXmlReader = portletXmlReader;
        this.appName = appName;
    }

    public MutablePortletApplication createPortletApplication() throws PortletApplicationException {
        return this.createPortletApplication(this.getClass().getClassLoader());
    }

    public MutablePortletApplication createPortletApplication(ClassLoader classLoader) throws PortletApplicationException {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(this.getClass().getClassLoader());
            digester.addRule("portlet-app", (Rule)new PortletApplicationRule(this.appName));
            digester.addSetProperties("portlet-app", "id", "applicationIdentifier");
            digester.addRule("portlet-app/portlet", (Rule)new PortletRule());
            digester.addSetProperties("portlet-app/portlet", "id", "portletIdentifier");
            digester.addBeanPropertySetter("portlet-app/portlet/portlet-name", "name");
            digester.addBeanPropertySetter("portlet-app/portlet/portlet-class", "className");
            digester.addBeanPropertySetter("portlet-app/portlet/expiration-cache", "expirationCache");
            digester.addBeanPropertySetter("portlet-app/portlet/resource-bundle", "resourceBundle");
            digester.addCallMethod("portlet-app/portlet/supported-locale", "addSupportedLocale", 0);
            digester.addObjectCreate("portlet-app/portlet/display-name", class$org$apache$jetspeed$om$impl$PortletDisplayNameImpl == null ? (class$org$apache$jetspeed$om$impl$PortletDisplayNameImpl = PortletApplicationDescriptor.class$("org.apache.jetspeed.om.impl.PortletDisplayNameImpl")) : class$org$apache$jetspeed$om$impl$PortletDisplayNameImpl);
            digester.addSetProperties("portlet-app/portlet/display-name", "xml:lang", "language");
            digester.addBeanPropertySetter("portlet-app/portlet/display-name", "displayName");
            digester.addSetNext("portlet-app/portlet/display-name", "addDisplayName");
            digester.addObjectCreate("portlet-app/portlet/description", class$org$apache$jetspeed$om$impl$PortletDescriptionImpl == null ? (class$org$apache$jetspeed$om$impl$PortletDescriptionImpl = PortletApplicationDescriptor.class$("org.apache.jetspeed.om.impl.PortletDescriptionImpl")) : class$org$apache$jetspeed$om$impl$PortletDescriptionImpl);
            digester.addSetProperties("portlet-app/portlet/description", "xml:lang", "language");
            digester.addBeanPropertySetter("portlet-app/portlet/description", "description");
            digester.addSetNext("portlet-app/portlet/description", "addDescription");
            digester.addObjectCreate("portlet-app/portlet/init-param", class$org$apache$jetspeed$om$impl$PortletInitParameterImpl == null ? (class$org$apache$jetspeed$om$impl$PortletInitParameterImpl = PortletApplicationDescriptor.class$("org.apache.jetspeed.om.impl.PortletInitParameterImpl")) : class$org$apache$jetspeed$om$impl$PortletInitParameterImpl);
            digester.addBeanPropertySetter("portlet-app/portlet/init-param/name", "name");
            digester.addBeanPropertySetter("portlet-app/portlet/init-param/value", "value");
            digester.addSetNext("portlet-app/portlet/init-param", "addInitParameter");
            digester.addObjectCreate("portlet-app/portlet/init-param/description", class$org$apache$jetspeed$om$impl$ParameterDescriptionImpl == null ? (class$org$apache$jetspeed$om$impl$ParameterDescriptionImpl = PortletApplicationDescriptor.class$("org.apache.jetspeed.om.impl.ParameterDescriptionImpl")) : class$org$apache$jetspeed$om$impl$ParameterDescriptionImpl);
            digester.addSetProperties("portlet-app/portlet/init-param/description", "xml:lang", "language");
            digester.addBeanPropertySetter("portlet-app/portlet/init-param/description", "description");
            digester.addSetNext("portlet-app/portlet/init-param/description", "addDescription");
            digester.addObjectCreate("portlet-app/portlet/supports", class$org$apache$jetspeed$om$portlet$impl$ContentTypeImpl == null ? (class$org$apache$jetspeed$om$portlet$impl$ContentTypeImpl = PortletApplicationDescriptor.class$("org.apache.jetspeed.om.portlet.impl.ContentTypeImpl")) : class$org$apache$jetspeed$om$portlet$impl$ContentTypeImpl);
            digester.addBeanPropertySetter("portlet-app/portlet/supports/mime-type", "contentType");
            digester.addCallMethod("portlet-app/portlet/supports/portlet-mode", "addPortletMode", 0);
            digester.addSetNext("portlet-app/portlet/supports", "addContentType");
            digester.addObjectCreate("portlet-app/portlet/portlet-info", class$org$apache$jetspeed$om$impl$LanguageImpl == null ? (class$org$apache$jetspeed$om$impl$LanguageImpl = PortletApplicationDescriptor.class$("org.apache.jetspeed.om.impl.LanguageImpl")) : class$org$apache$jetspeed$om$impl$LanguageImpl);
            digester.addBeanPropertySetter("portlet-app/portlet/portlet-info/title", "title");
            digester.addBeanPropertySetter("portlet-app/portlet/portlet-info/short-title", "shortTitle");
            digester.addCallMethod("portlet-app/portlet/portlet-info/keywords", "setKeywords", 0, new Class[]{class$java$lang$String == null ? (class$java$lang$String = PortletApplicationDescriptor.class$("java.lang.String")) : class$java$lang$String});
            digester.addSetNext("portlet-app/portlet/portlet-info", "addLanguage");
            digester.addRuleSet((RuleSet)new PortletPreferenceRuleSet());
            digester.addObjectCreate("portlet-app/user-attribute", class$org$apache$jetspeed$om$impl$UserAttributeImpl == null ? (class$org$apache$jetspeed$om$impl$UserAttributeImpl = PortletApplicationDescriptor.class$("org.apache.jetspeed.om.impl.UserAttributeImpl")) : class$org$apache$jetspeed$om$impl$UserAttributeImpl);
            digester.addBeanPropertySetter("portlet-app/user-attribute/description", "description");
            digester.addBeanPropertySetter("portlet-app/user-attribute/name", "name");
            digester.addSetNext("portlet-app/user-attribute", "addUserAttribute");
            digester.addObjectCreate("portlet-app/portlet/security-role-ref", class$org$apache$jetspeed$om$impl$SecurityRoleRefImpl == null ? (class$org$apache$jetspeed$om$impl$SecurityRoleRefImpl = PortletApplicationDescriptor.class$("org.apache.jetspeed.om.impl.SecurityRoleRefImpl")) : class$org$apache$jetspeed$om$impl$SecurityRoleRefImpl);
            digester.addBeanPropertySetter("portlet-app/portlet/security-role-ref/role-name", "roleName");
            digester.addBeanPropertySetter("portlet-app/portlet/security-role-ref/role-link", "roleLink");
            digester.addSetNext("portlet-app/portlet/security-role-ref", "addSecurityRoleRef");
            digester.addObjectCreate("portlet-app/portlet/security-role-ref/description", class$org$apache$jetspeed$om$impl$SecurityRoleRefDescriptionImpl == null ? (class$org$apache$jetspeed$om$impl$SecurityRoleRefDescriptionImpl = PortletApplicationDescriptor.class$("org.apache.jetspeed.om.impl.SecurityRoleRefDescriptionImpl")) : class$org$apache$jetspeed$om$impl$SecurityRoleRefDescriptionImpl);
            digester.addSetProperties("portlet-app/portlet/security-role-ref/description", "xml:lang", "language");
            digester.addBeanPropertySetter("portlet-app/portlet/security-role-ref/description", "description");
            digester.addSetNext("portlet-app/portlet/security-role-ref/description", "addDescription");
            PortletApplicationDefinitionImpl pd = (PortletApplicationDefinitionImpl)digester.parse(this.portletXmlReader);
            if (pd.getApplicationIdentifier() == null) {
                pd.setApplicationIdentifier(this.appName);
            }
            Iterator portletDefs = pd.getPortletDefinitions().iterator();
            while (portletDefs.hasNext()) {
                Object obj = portletDefs.next();
                PortletDefinitionComposite portletDef = (PortletDefinitionComposite)obj;
                if (portletDef.getPortletIdentifier() == null) {
                    portletDef.setPortletIdentifier(portletDef.getName());
                }
                ((Support)obj).postLoad((Object)classLoader);
            }
            return pd;
        }
        catch (Throwable t) {
            t.printStackTrace();
            String msg = "Could not unmarshal portlet.xml. " + t.toString();
            log.error((Object)msg, t);
            throw new PortletApplicationException(msg, t);
        }
    }

    public void validate(MutablePortletApplication app) throws PortletApplicationException {
        SecurityRoleSet roles = app.getWebApplicationDefinition().getSecurityRoles();
        Collection portlets = app.getPortletDefinitions();
        Iterator portletIterator = portlets.iterator();
        while (portletIterator.hasNext()) {
            PortletDefinition portlet = (PortletDefinition)portletIterator.next();
            SecurityRoleRefSet securityRoleRefs = portlet.getInitSecurityRoleRefSet();
            Iterator roleRefsIterator = securityRoleRefs.iterator();
            while (roleRefsIterator.hasNext()) {
                SecurityRoleRef roleRef = (SecurityRoleRef)roleRefsIterator.next();
                String roleName = roleRef.getRoleLink();
                if (roleName == null || roleName.length() == 0) {
                    roleName = roleRef.getRoleName();
                }
                if (roles.get(roleName) != null) continue;
                String errorMsg = "Undefined security role " + roleName + " referenced from portlet " + portlet.getName();
                log.error((Object)errorMsg);
                throw new PortletApplicationException(errorMsg);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

