/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.userinfo.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.common.UserAttributeRef;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SecurityHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.userinfo.UserInfoManager;
import org.apache.jetspeed.userinfo.impl.AbstractUserInfoManagerImpl;
import org.apache.pluto.om.common.ObjectID;

public class UserInfoManagerImpl
extends AbstractUserInfoManagerImpl
implements UserInfoManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$userinfo$impl$UserInfoManagerImpl == null ? (class$org$apache$jetspeed$userinfo$impl$UserInfoManagerImpl = UserInfoManagerImpl.class$("org.apache.jetspeed.userinfo.impl.UserInfoManagerImpl")) : class$org$apache$jetspeed$userinfo$impl$UserInfoManagerImpl));
    private static Map userInfoMapCache;
    String userInfoPropertySet;
    UserManager userMgr;
    PortletRegistry registry;
    String oid;
    static /* synthetic */ Class class$org$apache$jetspeed$userinfo$impl$UserInfoManagerImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;

    public UserInfoManagerImpl(UserManager userMgr, PortletRegistry registry) {
        this.userMgr = userMgr;
        this.registry = registry;
        this.userInfoPropertySet = "userinfo";
        this.initUserInfoMapCache();
    }

    public UserInfoManagerImpl(UserManager userMgr, PortletRegistry registry, String userInfoPropertySet) {
        this.userMgr = userMgr;
        this.registry = registry;
        this.userInfoPropertySet = userInfoPropertySet;
        this.initUserInfoMapCache();
    }

    public Map getUserInfoMap(ObjectID oid, RequestContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting user info for portlet application: " + oid.toString()));
        }
        if (userInfoMapCache.containsKey(oid)) {
            return (Map)userInfoMapCache.get(oid);
        }
        Preferences userPrefs = this.getUserPreferences(context);
        if (null == userPrefs) {
            log.debug((Object)"javax.portlet.userinfo is set to null");
            return null;
        }
        MutablePortletApplication pa = this.registry.getPortletApplication(oid);
        if (null == pa) {
            log.debug((Object)"javax.portlet.userinfo is set to null");
            return null;
        }
        Preferences userInfoPrefs = userPrefs.node(this.userInfoPropertySet);
        Collection userAttributes = pa.getUserAttributes();
        Collection userAttributeRefs = pa.getUserAttributeRefs();
        Map userInfoMap = this.mapUserInfo(userInfoPrefs, userAttributes, userAttributeRefs);
        return userInfoMap;
    }

    private Map mapUserInfo(Preferences userInfoPrefs, Collection userAttributes, Collection userAttributeRefs) {
        if (null == userAttributes || userAttributes.size() == 0) {
            return null;
        }
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        String[] propertyKeys = null;
        try {
            propertyKeys = userInfoPrefs.keys();
            if (null != propertyKeys && log.isDebugEnabled()) {
                log.debug((Object)("Found " + propertyKeys.length + " children for " + userInfoPrefs.absolutePath()));
            }
        }
        catch (BackingStoreException bse) {
            log.error((Object)("BackingStoreException: " + bse.toString()));
        }
        if (null == propertyKeys) {
            return null;
        }
        Collection linkedUserAttributes = this.mapLinkedUserAttributes(userAttributes, userAttributeRefs);
        Iterator iter = linkedUserAttributes.iterator();
        while (iter.hasNext()) {
            UserAttributeRef currentAttributeRef = (UserAttributeRef)iter.next();
            if (null == currentAttributeRef) continue;
            for (int i = 0; i < propertyKeys.length; ++i) {
                if (null != currentAttributeRef.getNameLink()) {
                    if (!currentAttributeRef.getNameLink().equals(propertyKeys[i])) continue;
                    userInfoMap.put(currentAttributeRef.getName(), userInfoPrefs.get(propertyKeys[i], null));
                    continue;
                }
                if (!currentAttributeRef.getName().equals(propertyKeys[i])) continue;
                userInfoMap.put(currentAttributeRef.getName(), userInfoPrefs.get(propertyKeys[i], null));
            }
        }
        userInfoMapCache.put(this.oid, userInfoMap);
        return userInfoMap;
    }

    private Preferences getUserPreferences(RequestContext context) {
        Principal userPrincipal;
        Preferences userPrefs = null;
        Subject subject = context.getSubject();
        if (null != subject && null != (userPrincipal = SecurityHelper.getPrincipal((Subject)subject, (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = UserInfoManagerImpl.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal)))) {
            log.debug((Object)("Got user principal: " + userPrincipal.getName()));
            try {
                if (this.userMgr.userExists(userPrincipal.getName())) {
                    User user = this.userMgr.getUser(userPrincipal.getName());
                    userPrefs = user.getPreferences();
                }
            }
            catch (SecurityException sex) {
                log.warn((Object)"Unexpected SecurityException in UserInfoManager", (Throwable)sex);
            }
        }
        return userPrefs;
    }

    private void initUserInfoMapCache() {
        if (null == userInfoMapCache) {
            userInfoMapCache = new HashMap();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

