/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.pamanager.servletcontainer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.tools.pamanager.servletcontainer.ApplicationServerManager;
import org.apache.jetspeed.tools.pamanager.servletcontainer.ApplicationServerManagerResult;

public class TomcatManager
implements ApplicationServerManager {
    private static final String DEFAULT_MANAGER_APP_PATH = "/manager";
    protected static final Log log = LogFactory.getLog((String)"deployment");
    private String catalinaBase;
    private String catalinaEngine;
    private String catalinaContextPath;
    private String hostUrl;
    private int hostPort;
    private String userName;
    private String password;
    private String managerAppPath = "/manager";
    private String stopPath = this.managerAppPath + "/stop";
    private String startPath = this.managerAppPath + "/start";
    private String deployPath = this.managerAppPath + "/deploy";
    private String undeployPath = this.managerAppPath + "/undeploy";
    private String reloadPath = this.managerAppPath + "/reload";
    private String serverInfoPath = this.managerAppPath + "/serverinfo";
    private HttpClient client;
    private HttpMethod start;
    private HttpMethod stop;
    private HttpMethod reload;
    private HttpMethod undeploy;
    private PutMethod deploy;
    private HttpMethod install;

    public TomcatManager(String catalinaBase, String catalinaEngine, String hostName, int hostPort, String userName, String password) throws IOException {
        this.catalinaBase = !catalinaBase.endsWith("/") ? catalinaBase + "/" : catalinaBase;
        this.catalinaEngine = catalinaEngine;
        this.hostUrl = hostName;
        this.hostPort = hostPort;
        this.userName = userName;
        this.password = password;
        this.catalinaContextPath = this.catalinaBase + "/conf/" + this.catalinaEngine + "/" + this.hostUrl + "/";
    }

    private ApplicationServerManagerResult parseResult(String responseBody) {
        if (responseBody.startsWith("OK - ")) {
            return new ApplicationServerManagerResult(true, responseBody.substring(5), responseBody);
        }
        if (responseBody.startsWith("FAIL - ")) {
            return new ApplicationServerManagerResult(false, responseBody.substring(7), responseBody);
        }
        return new ApplicationServerManagerResult(false, responseBody, responseBody);
    }

    public void start() {
        this.client = new HttpClient();
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(this.hostUrl, this.hostPort, "http");
        this.client.setHostConfiguration(hostConfig);
        this.client.getState().setAuthenticationPreemptive(true);
        this.client.getState().setCredentials(null, this.hostUrl, (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
        this.start = new GetMethod(this.startPath);
        this.stop = new GetMethod(this.stopPath);
        this.reload = new GetMethod(this.reloadPath);
        this.undeploy = new GetMethod(this.undeployPath);
        this.deploy = new PutMethod(this.deployPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationServerManagerResult start(String appPath) throws IOException {
        try {
            this.start.setQueryString(this.buildPathQueryArgs(appPath));
            this.client.executeMethod(this.start);
            ApplicationServerManagerResult applicationServerManagerResult = this.parseResult(this.start.getResponseBodyAsString());
            return applicationServerManagerResult;
        }
        finally {
            this.start.recycle();
            this.start.setPath(this.startPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationServerManagerResult stop(String appPath) throws IOException {
        try {
            this.stop.setQueryString(this.buildPathQueryArgs(appPath));
            this.client.executeMethod(this.stop);
            ApplicationServerManagerResult applicationServerManagerResult = this.parseResult(this.stop.getResponseBodyAsString());
            return applicationServerManagerResult;
        }
        finally {
            this.stop.recycle();
            this.stop.setPath(this.stopPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationServerManagerResult reload(String appPath) throws IOException {
        ApplicationServerManagerResult applicationServerManagerResult;
        try {
            this.stop(appPath);
            Thread.sleep(1500L);
            applicationServerManagerResult = this.start(appPath);
            Object var5_4 = null;
        }
        catch (InterruptedException e) {
            ApplicationServerManagerResult applicationServerManagerResult2;
            try {
                applicationServerManagerResult2 = this.parseResult("FAIL - " + e.toString());
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.stop.recycle();
                this.stop.setPath(this.stopPath);
                this.start.recycle();
                this.start.setPath(this.startPath);
                throw throwable;
            }
            this.stop.recycle();
            this.stop.setPath(this.stopPath);
            this.start.recycle();
            this.start.setPath(this.startPath);
            return applicationServerManagerResult2;
        }
        this.stop.recycle();
        this.stop.setPath(this.stopPath);
        this.start.recycle();
        this.start.setPath(this.startPath);
        return applicationServerManagerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationServerManagerResult undeploy(String appPath) throws IOException {
        try {
            this.undeploy.setQueryString(this.buildPathQueryArgs(appPath));
            this.client.executeMethod(this.undeploy);
            ApplicationServerManagerResult applicationServerManagerResult = this.parseResult(this.undeploy.getResponseBodyAsString());
            return applicationServerManagerResult;
        }
        finally {
            this.undeploy.recycle();
            this.undeploy.setPath(this.undeployPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationServerManagerResult deploy(String appPath, InputStream is, int size) throws IOException {
        try {
            this.deploy.setQueryString(this.buildPathQueryArgs(appPath));
            if (size != -1) {
                this.deploy.setRequestContentLength(size);
            }
            this.deploy.setRequestBody(is);
            this.client.executeMethod((HttpMethod)this.deploy);
            ApplicationServerManagerResult applicationServerManagerResult = this.parseResult(this.deploy.getResponseBodyAsString());
            return applicationServerManagerResult;
        }
        finally {
            this.deploy.recycle();
            this.deploy.setPath(this.deployPath);
        }
    }

    protected NameValuePair[] buildPathQueryArgs(String appPath) {
        if (!appPath.startsWith("/")) {
            appPath = "/" + appPath;
        }
        return new NameValuePair[]{new NameValuePair("path", appPath)};
    }

    protected NameValuePair[] buildWarQueryArgs(String warPath, String appPath) throws MalformedURLException {
        return new NameValuePair[]{new NameValuePair("war", new File(warPath).toURL().toString()), new NameValuePair("path", appPath)};
    }

    protected NameValuePair[] buildConfigQueryArgs(String configPath, String appPath) throws MalformedURLException {
        return new NameValuePair[]{new NameValuePair("config", new File(configPath).toURL().toString()), new NameValuePair("path", appPath)};
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public String getHostUrl() {
        return this.hostUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isConnected() {
        Socket checkSocket = null;
        checkSocket = new Socket(this.hostUrl, this.hostPort);
        boolean bl = true;
        Object var5_5 = null;
        try {
            if (checkSocket != null) {
                checkSocket.close();
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        return bl;
        catch (UnknownHostException e1) {
            log.error((Object)("Unknown server: " + e1.toString()));
            boolean bl2 = false;
            Object var5_6 = null;
            try {
                if (checkSocket != null) {
                    checkSocket.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            return bl2;
        }
        catch (IOException e1) {
            log.error((Object)("IOException: " + e1.toString()));
            boolean bl3 = false;
            Object var5_7 = null;
            {
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    try {
                        if (checkSocket != null) {
                            checkSocket.close();
                        }
                    }
                    catch (IOException e2) {}
                    throw throwable;
                }
            }
            try {
                if (checkSocket != null) {
                    checkSocket.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            return bl3;
        }
    }

    public void stop() {
    }

    public String getAppServerTarget(String appName) {
        return appName;
    }
}

