/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.pamanager;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent;
import org.apache.jetspeed.components.portletentity.PortletEntityNotDeletedException;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.RegistryException;
import org.apache.jetspeed.container.window.PortletWindowAccessor;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.PortletApplication;
import org.apache.jetspeed.om.common.servlet.MutableWebApplication;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.tools.pamanager.PortletApplicationManagement;
import org.apache.jetspeed.util.FileSystemHelper;
import org.apache.jetspeed.util.descriptor.PortletApplicationWar;
import org.apache.pluto.om.common.SecurityRole;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.entity.PortletEntityCtrl;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.servlet.WebApplicationDefinition;

public class PortletApplicationManager
implements PortletApplicationManagement {
    private static final Log log = LogFactory.getLog((String)"deployment");
    private static final String PORTLET_XML = "WEB-INF/portlet.xml";
    protected PortletEntityAccessComponent entityAccess;
    protected PortletFactory portletFactory;
    protected PortletRegistry registry;
    protected PortletWindowAccessor windowAccess;
    protected SearchEngine searchEngine;
    protected RoleManager roleManager;
    protected boolean autoCreateRoles;

    public PortletApplicationManager(PortletFactory portletFactory, PortletRegistry registry, PortletEntityAccessComponent entityAccess, PortletWindowAccessor windowAccess) {
        this.portletFactory = portletFactory;
        this.registry = registry;
        this.entityAccess = entityAccess;
        this.windowAccess = windowAccess;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public void setAutoCreateRoles(boolean autoCreateRoles) {
        this.autoCreateRoles = autoCreateRoles;
    }

    public void setSearchEngine(SearchEngine searchEngine) {
        this.searchEngine = searchEngine;
    }

    public void startLocalPortletApplication(String contextName, FileSystemHelper warStruct, ClassLoader paClassLoader) throws RegistryException {
        this.checkValidContextName(contextName, true);
        this.startPA(contextName, warStruct, paClassLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPortletApplication(String contextName, FileSystemHelper warStruct, ClassLoader paClassLoader) throws RegistryException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.checkValidContextName(contextName, false);
            this.startPA(contextName, warStruct, paClassLoader, false);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void stopLocalPortletApplication(String contextName) throws RegistryException {
        this.checkValidContextName(contextName, true);
        this.stopPA(contextName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPortletApplication(String contextName) throws RegistryException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.checkValidContextName(contextName, false);
            this.stopPA(contextName);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPortletApplication(String paName) throws RegistryException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            MutablePortletApplication pa = null;
            try {
                pa = this.registry.getPortletApplication(paName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (pa != null) {
                if (this.portletFactory.getPortletApplicationClassLoader((PortletApplication)pa) != null) {
                    throw new RegistryException("Portlet Application " + paName + " still running");
                }
                this.unregisterPortletApplication(pa, true);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    protected void checkValidContextName(String contextName, boolean local) throws RegistryException {
        int prefixLength = "jetspeed-".length();
        if (contextName.length() >= prefixLength && contextName.substring(0, prefixLength).equalsIgnoreCase("jetspeed-")) {
            if (!local) {
                throw new RegistryException("Prefix \"jetspeed-\" is reserved for Local Portlet Applications only.");
            }
        } else if (local) {
            throw new RegistryException("Prefix \"jetspeed-\" is required for Local Portlet Applications.");
        }
    }

    protected MutablePortletApplication registerPortletApplication(PortletApplicationWar paWar, MutablePortletApplication oldPA, boolean local, ClassLoader paClassLoader) throws RegistryException {
        if (oldPA != null) {
            this.unregisterPortletApplication(oldPA, false);
            oldPA = null;
        }
        MutablePortletApplication pa = null;
        boolean registered = false;
        String paName = paWar.getPortletApplicationName();
        try {
            log.info((Object)("Loading portlet.xml...." + paName));
            pa = paWar.createPortletApp(paClassLoader);
            if (local) {
                pa.setApplicationType(1);
            } else {
                pa.setApplicationType(0);
            }
            log.info((Object)("Loading web.xml...." + paName));
            MutableWebApplication wa = paWar.createWebApp();
            paWar.validate();
            if (local) {
                wa.setContextRoot("<portal>");
            }
            pa.setWebApplicationDefinition((WebApplicationDefinition)wa);
            Collection portletDefs = pa.getPortletDefinitions();
            if (portletDefs != null && portletDefs.size() > 0) {
                Iterator pdItr = portletDefs.iterator();
                while (pdItr.hasNext()) {
                    PortletDefinition pd = (PortletDefinition)pdItr.next();
                    Collection portletEntites = this.entityAccess.getPortletEntities(pd);
                    if (portletEntites == null || portletEntites.size() <= 0) continue;
                    Iterator peItr = portletEntites.iterator();
                    while (peItr.hasNext()) {
                        PortletEntityCtrl portletEntity = (PortletEntityCtrl)peItr.next();
                        portletEntity.setPortletDefinition(pd);
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = "Failed to load portlet application for " + paWar.getPortletApplicationName();
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        try {
            this.registry.registerPortletApplication((PortletApplicationDefinition)pa);
            registered = true;
            log.info((Object)("Registered the portlet application " + paName));
            if (this.searchEngine != null) {
                this.searchEngine.add((Object)pa);
                this.searchEngine.add(pa.getPortletDefinitions());
                log.info((Object)("Registered the portlet application in the search engine... " + paName));
            }
            if (this.autoCreateRoles && this.roleManager != null && pa.getWebApplicationDefinition().getSecurityRoles() != null) {
                try {
                    Iterator rolesIter = pa.getWebApplicationDefinition().getSecurityRoles().iterator();
                    while (rolesIter.hasNext()) {
                        SecurityRole sr = (SecurityRole)rolesIter.next();
                        if (this.roleManager.roleExists(sr.getRoleName())) continue;
                        this.roleManager.addRole(sr.getRoleName());
                        log.info((Object)("AutoCreated role: " + sr.getRoleName() + " from portlet application " + paName + " its web definition"));
                    }
                }
                catch (SecurityException sex) {
                    log.warn((Object)("Failed to autoCreate roles for portlet application " + paName + ": " + sex.getMessage()), (Throwable)sex);
                }
            }
            return pa;
        }
        catch (Exception e) {
            String msg = "Failed to register portlet application, " + paName;
            log.error((Object)msg, (Throwable)e);
            if (registered) {
                try {
                    this.unregisterPortletApplication(pa, local);
                }
                catch (Exception re) {
                    log.error((Object)("Failed to rollback registration of portlet application" + paName), (Throwable)re);
                }
            }
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void startPA(String contextName, FileSystemHelper warStruct, ClassLoader paClassLoader, boolean local) throws RegistryException {
        PortletApplicationWar paWar = null;
        try {
            try {
                paWar = new PortletApplicationWar(warStruct, contextName, "/" + contextName);
                if (paClassLoader == null) {
                    paClassLoader = paWar.createClassloader(this.getClass().getClassLoader());
                }
            }
            catch (IOException e) {
                String msg = "Failed to create PA WAR for " + contextName;
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
            MutablePortletApplication pa = this.registry.getPortletApplication(contextName);
            if (pa != null && paWar.getPortletApplicationChecksum() == pa.getChecksum()) {
                this.portletFactory.unregisterPortletApplication((PortletApplication)pa);
            } else {
                pa = this.registerPortletApplication(paWar, pa, local, paClassLoader);
            }
            this.portletFactory.registerPortletApplication((PortletApplication)pa, paClassLoader);
            Object var9_9 = null;
            if (paWar == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (paWar == null) throw throwable;
            try {
                paWar.close();
                throw throwable;
            }
            catch (IOException e) {
                log.error((Object)("Failed to close PA WAR for " + contextName), (Throwable)e);
            }
            throw throwable;
        }
        try {
            paWar.close();
            return;
        }
        catch (IOException e) {
            log.error((Object)("Failed to close PA WAR for " + contextName), (Throwable)e);
        }
    }

    protected void stopPA(String contextName) throws RegistryException {
        MutablePortletApplication pa = null;
        try {
            pa = this.registry.getPortletApplication(contextName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pa != null) {
            this.portletFactory.unregisterPortletApplication((PortletApplication)pa);
        }
    }

    protected void unregisterPortletApplication(MutablePortletApplication pa, boolean purgeEntityInfo) throws RegistryException {
        if (this.searchEngine != null) {
            this.searchEngine.remove((Object)pa);
            this.searchEngine.remove(pa.getPortletDefinitions());
        }
        log.info((Object)("Remove all registry entries defined for portlet application " + pa.getName()));
        Iterator portlets = pa.getPortletDefinitions().iterator();
        while (portlets.hasNext()) {
            PortletDefinition portletDefinition = (PortletDefinition)portlets.next();
            Iterator entities = this.entityAccess.getPortletEntities(portletDefinition).iterator();
            while (entities.hasNext()) {
                PortletEntity entity = (PortletEntity)entities.next();
                if (purgeEntityInfo) {
                    try {
                        this.entityAccess.removePortletEntity(entity);
                    }
                    catch (PortletEntityNotDeletedException e) {
                        String msg = "Failed to delete Portlet Entity " + entity.getId();
                        log.error((Object)msg, (Throwable)e);
                        throw new RegistryException(msg, (Throwable)e);
                    }
                }
                this.entityAccess.removeFromCache(entity);
                this.windowAccess.removeWindows(entity);
            }
        }
        this.registry.removeApplication((PortletApplicationDefinition)pa);
    }
}

