/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.title;

import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.services.title.DynamicTitleService;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.window.PortletWindow;

public class DynamicTitleServiceImpl
implements DynamicTitleService {
    public void setDynamicTitle(PortletWindow window, HttpServletRequest request, String titleArg) {
        String title = this.getTitleFromPreference(window, request);
        if (title == null || title.length() < 0) {
            title = titleArg == null || titleArg.length() == 0 ? this.getTitleFromPortletDefinition(window, request) : titleArg;
        }
        request.setAttribute("org.apache.jetspeed.portlet.title::window.id::" + window.getId(), (Object)title);
    }

    public String getDynamicTitle(PortletWindow window, HttpServletRequest request) {
        return (String)request.getAttribute("org.apache.jetspeed.portlet.title::window.id::" + window.getId());
    }

    protected final String getTitleFromPortletDefinition(PortletWindow window, HttpServletRequest request) {
        String title = null;
        RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        PortletEntity entity = window.getPortletEntity();
        if (entity != null && entity.getPortletDefinition() != null) {
            title = requestContext.getPreferedLanguage(entity.getPortletDefinition()).getTitle();
        }
        if (title == null && entity.getPortletDefinition() != null) {
            title = entity.getPortletDefinition().getName();
        } else if (title == null) {
            title = "Invalid portlet entity " + entity.getId();
        }
        return title;
    }

    protected final String getTitleFromPreference(PortletWindow window, HttpServletRequest request) {
        Iterator values;
        Locale locale = request.getLocale();
        String titleKey = DynamicTitleServiceImpl.createTitleKey(locale, false);
        Preference titlePref = window.getPortletEntity().getPreferenceSet().get(titleKey);
        if (titlePref == null) {
            titleKey = DynamicTitleServiceImpl.createTitleKey(locale, true);
            titlePref = window.getPortletEntity().getPreferenceSet().get(titleKey);
        }
        if (titlePref != null && (values = titlePref.getValues()).hasNext()) {
            return (String)titlePref.getValues().next();
        }
        return null;
    }

    public static String createTitleKey(Locale locale, boolean languageOnly) {
        if (languageOnly) {
            return "jetspeed.title." + locale.getLanguage();
        }
        return "jetspeed.title." + locale.toString();
    }
}

