/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.util.Arrays;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.PasswordCredentialValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityHelper;

public class PasswordCredentialValveImpl
extends AbstractValve
implements PasswordCredentialValve {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$security$impl$PasswordCredentialValveImpl == null ? (class$org$apache$jetspeed$security$impl$PasswordCredentialValveImpl = PasswordCredentialValveImpl.class$("org.apache.jetspeed.security.impl.PasswordCredentialValveImpl")) : class$org$apache$jetspeed$security$impl$PasswordCredentialValveImpl));
    private static final String CHECKED_KEY = (class$org$apache$jetspeed$security$impl$PasswordCredentialValveImpl == null ? (class$org$apache$jetspeed$security$impl$PasswordCredentialValveImpl = PasswordCredentialValveImpl.class$("org.apache.jetspeed.security.impl.PasswordCredentialValveImpl")) : class$org$apache$jetspeed$security$impl$PasswordCredentialValveImpl).getName() + ".checked";
    private int[] expirationWarningDays;
    static /* synthetic */ Class class$org$apache$jetspeed$security$impl$PasswordCredentialValveImpl;

    public PasswordCredentialValveImpl(List expirationWarningDays) {
        if (expirationWarningDays != null) {
            this.expirationWarningDays = new int[expirationWarningDays.size()];
            for (int i = 0; i < this.expirationWarningDays.length; ++i) {
                this.expirationWarningDays[i] = Integer.parseInt((String)expirationWarningDays.get(i));
            }
            Arrays.sort(this.expirationWarningDays);
        } else {
            this.expirationWarningDays = new int[0];
        }
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        try {
            if (request.getRequest().getUserPrincipal() != null) {
                Subject subject = request.getSubject();
                PasswordCredential pwdCredential = SecurityHelper.getPasswordCredential((Subject)subject);
                Integer passwordDaysValid = null;
                if (pwdCredential != null) {
                    if (pwdCredential.isUpdateRequired()) {
                        passwordDaysValid = new Integer(0);
                    }
                    if (request.getSessionAttribute(CHECKED_KEY) == null) {
                        request.setSessionAttribute(CHECKED_KEY, (Object)Boolean.TRUE);
                        if (pwdCredential.getPreviousAuthenticationDate() != null && pwdCredential.getExpirationDate() != null) {
                            long lastAuthTime;
                            long expirationTime = pwdCredential.getExpirationDate().getTime();
                            int lastAuthDaysBeforeExpiration = (int)((expirationTime - (lastAuthTime = pwdCredential.getLastAuthenticationDate().getTime())) / 86400000L);
                            if (lastAuthDaysBeforeExpiration < 1) {
                                passwordDaysValid = new Integer(1);
                            } else if (this.expirationWarningDays.length > 0) {
                                int prevAuthDaysBeforeExpiration;
                                long prevAuthTime = Long.MIN_VALUE;
                                if (pwdCredential.getPreviousAuthenticationDate() != null) {
                                    prevAuthTime = pwdCredential.getPreviousAuthenticationDate().getTime();
                                }
                                if ((prevAuthDaysBeforeExpiration = (int)((expirationTime - prevAuthTime) / 86400000L)) > lastAuthDaysBeforeExpiration) {
                                    for (int i = 0; i < this.expirationWarningDays.length; ++i) {
                                        int daysBefore = this.expirationWarningDays[i] - 1;
                                        if (lastAuthDaysBeforeExpiration != daysBefore && (lastAuthDaysBeforeExpiration >= daysBefore || prevAuthDaysBeforeExpiration <= daysBefore)) continue;
                                        passwordDaysValid = new Integer(lastAuthDaysBeforeExpiration + 1);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                if (passwordDaysValid != null) {
                    request.setAttribute("org.apache.jetspeed.profiler.ProfileLocator", (Object)"security");
                    request.setAttribute(PasswordCredential.PASSWORD_CREDENTIAL_DAYS_VALID_REQUEST_ATTR_KEY, (Object)passwordDaysValid);
                }
            }
            context.invokeNext(request);
        }
        catch (Exception e) {
            log.error((Object)("Exception in request pipeline: " + e.getMessage()), (Throwable)e);
            throw new PipelineException(e.toString(), e);
        }
    }

    public String toString() {
        return "PasswordCredentialValve";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

