/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.login.LoginConstants;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.LoginValidationValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SecurityHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.UserPrincipal;

public class LoginValidationValveImpl
extends AbstractValve
implements LoginValidationValve {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$security$impl$LoginValidationValveImpl == null ? (class$org$apache$jetspeed$security$impl$LoginValidationValveImpl = LoginValidationValveImpl.class$("org.apache.jetspeed.security.impl.LoginValidationValveImpl")) : class$org$apache$jetspeed$security$impl$LoginValidationValveImpl));
    private int maxNumberOfAuthenticationFailures;
    static /* synthetic */ Class class$org$apache$jetspeed$security$impl$LoginValidationValveImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserManager;
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;

    public LoginValidationValveImpl(int maxNumberOfAuthenticationFailures) {
        this.maxNumberOfAuthenticationFailures = maxNumberOfAuthenticationFailures;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        try {
            block12: {
                if (request.getRequest().getUserPrincipal() == null && request.getSessionAttribute("org.apache.jetspeed.login.retrycount") != null) {
                    String userName = (String)request.getSessionAttribute("org.apache.jetspeed.login.username");
                    if (userName != null) {
                        UserManager um = (UserManager)Jetspeed.getComponentManager().getComponent((Object)(class$org$apache$jetspeed$security$UserManager == null ? (class$org$apache$jetspeed$security$UserManager = LoginValidationValveImpl.class$("org.apache.jetspeed.security.UserManager")) : class$org$apache$jetspeed$security$UserManager));
                        if (um != null) {
                            User user = null;
                            try {
                                user = um.getUser(userName);
                                UserPrincipal userPrincipal = (UserPrincipal)SecurityHelper.getPrincipal((Subject)user.getSubject(), (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = LoginValidationValveImpl.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal));
                                if (!userPrincipal.isEnabled()) {
                                    request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_USER_DISABLED);
                                    break block12;
                                }
                                PasswordCredential pwdCredential = SecurityHelper.getPasswordCredential((Subject)user.getSubject());
                                if (pwdCredential == null || !pwdCredential.isEnabled()) {
                                    request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_CREDENTIAL_DISABLED);
                                    break block12;
                                }
                                if (pwdCredential.isExpired()) {
                                    request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_CREDENTIAL_EXPIRED);
                                    break block12;
                                }
                                if (this.maxNumberOfAuthenticationFailures > 1 && pwdCredential.getAuthenticationFailures() == this.maxNumberOfAuthenticationFailures - 1) {
                                    request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_FINAL_LOGIN_ATTEMPT);
                                    break block12;
                                }
                                request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_INVALID_PASSWORD);
                            }
                            catch (SecurityException sex) {
                                request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_UNKNOWN_USER);
                            }
                        }
                    } else {
                        request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_UNKNOWN_USER);
                    }
                }
            }
            context.invokeNext(request);
        }
        catch (Exception e) {
            log.error((Object)("Exception in request pipeline: " + e.getMessage()), (Throwable)e);
            throw new PipelineException(e.toString(), e);
        }
    }

    public String toString() {
        return "LoginValidationValve";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

