/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.request;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.aggregator.ContentDispatcher;
import org.apache.jetspeed.aggregator.ContentDispatcherCtrl;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.jetspeed.engine.servlet.ServletRequestFactory;
import org.apache.jetspeed.engine.servlet.ServletResponseFactory;
import org.apache.jetspeed.om.impl.LanguageImpl;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.PortalRequestFactory;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.userinfo.UserInfoManager;
import org.apache.pluto.om.common.Language;
import org.apache.pluto.om.common.LanguageSet;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.window.PortletWindow;

public class JetspeedRequestContext
implements RequestContext {
    private static final String ACTION_ERROR_ATTR = "org.apache.jetspeed.action.error:";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletConfig config;
    private Map locators;
    private ContentPage page;
    private PortletDefinition portletDefinition;
    private Subject subject;
    private Locale locale;
    private ContentDispatcher dispatcher;
    private CapabilityMap capabilityMap;
    private String mimeType;
    private String mediaType;
    private PortalURL url;
    private PortletWindow actionWindow;
    private String encoding;
    private String requestPath = null;
    private UserInfoManager userInfoMgr;
    private Map requestsForWindows;
    private Map responsesForWindows;
    static /* synthetic */ Class class$org$apache$jetspeed$request$PortalRequestFactory;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    public JetspeedRequestContext(HttpServletRequest request, HttpServletResponse response, ServletConfig config, UserInfoManager userInfoMgr) {
        this.request = request;
        this.response = response;
        this.config = config;
        this.userInfoMgr = userInfoMgr;
        this.requestsForWindows = new HashMap();
        this.responsesForWindows = new HashMap();
        if (null != this.request) {
            this.request.setAttribute("org.apache.jetspeed.request.RequestContext", (Object)this);
            PortalRequestFactory prf = null;
            try {
                prf = (PortalRequestFactory)Jetspeed.getComponentManager().getComponent((Object)(class$org$apache$jetspeed$request$PortalRequestFactory == null ? (class$org$apache$jetspeed$request$PortalRequestFactory = JetspeedRequestContext.class$("org.apache.jetspeed.request.PortalRequestFactory")) : class$org$apache$jetspeed$request$PortalRequestFactory));
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.request = prf != null ? prf.createPortalRequest(this.request) : new HttpServletRequestWrapper(this.request);
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletConfig getConfig() {
        return this.config;
    }

    public Map getProfileLocators() {
        return this.locators;
    }

    public void setProfileLocators(Map locators) {
        this.locators = locators;
    }

    public ContentPage getPage() {
        return this.page;
    }

    public void setPage(ContentPage page) {
        this.page = page;
    }

    public PortletDefinition getPortletDefinition() {
        return this.portletDefinition;
    }

    public void setPortletDefinition(PortletDefinition portletDefinition) {
        this.portletDefinition = portletDefinition;
    }

    public ContentDispatcher getContentDispatcher() {
        return this.dispatcher;
    }

    public void setContentDispatcher(ContentDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public CapabilityMap getCapabilityMap() {
        return this.capabilityMap;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public PortletWindow getActionWindow() {
        return this.actionWindow;
    }

    public void setActionWindow(PortletWindow portletWindow) {
        this.actionWindow = portletWindow;
    }

    public void setCapabilityMap(CapabilityMap map) {
        this.capabilityMap = map;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void setCharacterEncoding(String enc) {
        String preferedEnc = (String)this.request.getSession().getAttribute("org.apache.jetspeed.prefered.characterencoding");
        if (preferedEnc == null || !enc.equals(preferedEnc)) {
            this.request.setAttribute("org.apache.jetspeed.prefered.characterencoding", (Object)enc);
        }
        this.encoding = enc;
    }

    public HttpServletRequest getRequestForWindow(PortletWindow window) {
        if (!this.requestsForWindows.containsKey(window.getId())) {
            ServletRequestFactory reqFac = (ServletRequestFactory)Jetspeed.getEngine().getFactory(class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = JetspeedRequestContext.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest);
            HttpServletRequest requestWrapper = reqFac.getServletRequest(this.request, window);
            this.requestsForWindows.put(window.getId(), requestWrapper);
            return requestWrapper;
        }
        return (HttpServletRequest)this.requestsForWindows.get(window.getId());
    }

    public HttpServletResponse getResponseForWindow(PortletWindow window) {
        HttpServletResponse wrappedResponse = null;
        if (!this.responsesForWindows.containsKey(window.getId())) {
            if (this.getContentDispatcher() != null) {
                wrappedResponse = ((ContentDispatcherCtrl)this.getContentDispatcher()).getResponseForWindow(window, (RequestContext)this);
            } else {
                ServletResponseFactory rspFac = (ServletResponseFactory)Jetspeed.getEngine().getFactory(class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = JetspeedRequestContext.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse);
                wrappedResponse = rspFac.getServletResponse(this.response);
            }
            this.responsesForWindows.put(window.getId(), wrappedResponse);
            return wrappedResponse;
        }
        return (HttpServletResponse)this.responsesForWindows.get(window.getId());
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        Locale preferedLocale = (Locale)this.request.getSession().getAttribute("org.apache.jetspeed.prefered.locale");
        if (preferedLocale == null || !locale.equals(preferedLocale)) {
            this.request.getSession().setAttribute("org.apache.jetspeed.prefered.language", new WeakHashMap());
            this.request.getSession().setAttribute("org.apache.jetspeed.prefered.locale", (Object)locale);
            this.request.setAttribute("org.apache.jetspeed.prefered.locale", (Object)locale);
        }
        this.locale = locale;
    }

    public String getRequestParameter(String key) {
        return this.request.getParameter(key);
    }

    public Map getParameterMap() {
        return this.request.getParameterMap();
    }

    public Object getRequestAttribute(String key) {
        return this.request.getAttribute(key);
    }

    public Object getSessionAttribute(String key) {
        return this.request.getSession().getAttribute(key);
    }

    public void setSessionAttribute(String key, Object value) {
        this.request.getSession().setAttribute(key, value);
    }

    public void setAttribute(String key, Object value) {
        this.request.setAttribute(key, value);
    }

    public Object getAttribute(String key) {
        return this.request.getAttribute(key);
    }

    public String getPath() {
        if (this.requestPath == null) {
            this.requestPath = this.getPortalURL().getPath();
        }
        return this.requestPath;
    }

    public void setPortalURL(PortalURL url) {
        if (this.url != null) {
            throw new IllegalStateException("PortalURL already set");
        }
        if (url == null) {
            throw new IllegalArgumentException("PortalURL may not be nullified");
        }
        this.url = url;
    }

    public PortalURL getPortalURL() {
        return this.url;
    }

    public Map getUserInfoMap(ObjectID oid) {
        return this.userInfoMgr.getUserInfoMap(oid, (RequestContext)this);
    }

    public Language getPreferedLanguage(PortletDefinition portlet) {
        LanguageSet languageSet = portlet.getLanguageSet();
        Language language = languageSet.get(this.locale);
        Enumeration locales = this.request.getLocales();
        while (locales.hasMoreElements() && language == null) {
            Locale aLocale = (Locale)locales.nextElement();
            language = languageSet.get(aLocale);
        }
        Iterator langItr = languageSet.iterator();
        if (langItr.hasNext() && language == null) {
            language = (Language)langItr.next();
        }
        if (language == null) {
            language = languageSet.get(languageSet.getDefaultLocale());
        }
        if (language == null) {
            LanguageImpl languageCtl = new LanguageImpl();
            languageCtl.setLocale(this.locale);
            languageCtl.setShortTitle(portlet.getName());
            languageCtl.setTitle(portlet.getName());
            language = languageCtl;
        }
        return language;
    }

    public void setPath(String path) {
        this.requestPath = path;
    }

    public Throwable popActionFailure(PortletWindow window) {
        String key = ACTION_ERROR_ATTR + window.getId();
        Throwable t = (Throwable)this.request.getSession().getAttribute(key);
        this.request.getSession().removeAttribute(key);
        return t;
    }

    public void setActionFailure(PortletWindow window, Throwable actionFailure) {
        this.setSessionAttribute(ACTION_ERROR_ATTR + window.getId(), actionFailure);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

