/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.impl;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.psml.ContentPageImpl;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.PageProfilerValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.portalsite.PortalSite;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portalsite.PortalSiteSessionContext;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.ProfilerException;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityHelper;

public class ProfilerValveImpl
extends AbstractValve
implements PageProfilerValve {
    protected Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$profiler$impl$ProfilerValveImpl == null ? (class$org$apache$jetspeed$profiler$impl$ProfilerValveImpl = ProfilerValveImpl.class$("org.apache.jetspeed.profiler.impl.ProfilerValveImpl")) : class$org$apache$jetspeed$profiler$impl$ProfilerValveImpl));
    public static final String PORTAL_SITE_SESSION_CONTEXT_ATTR_KEY = "org.apache.jetspeed.portalsite.PortalSiteSessionContext";
    public static final String PORTAL_SITE_REQUEST_CONTEXT_ATTR_KEY = "org.apache.jetspeed.portalsite.PortalSiteRequestContext";
    public static final String PROFILED_PAGE_CONTEXT_ATTR_KEY = "org.apache.jetspeed.profiledPageContext";
    private Profiler profiler;
    private PortalSite portalSite;
    private PageManager pageManager;
    static /* synthetic */ Class class$org$apache$jetspeed$profiler$impl$ProfilerValveImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;

    public ProfilerValveImpl(Profiler profiler, PortalSite portalSite, PageManager pageManager) {
        this.profiler = profiler;
        this.portalSite = portalSite;
        this.pageManager = pageManager;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        try {
            ProfileLocator locator;
            Subject subject = request.getSubject();
            if (subject == null) {
                throw new ProfilerException("Missing subject for request: " + request.getPath());
            }
            Principal principal = SecurityHelper.getBestPrincipal((Subject)subject, (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = ProfilerValveImpl.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal));
            if (principal == null) {
                throw new ProfilerException("Missing principal for request: " + request.getPath());
            }
            HashMap<String, ProfileLocator> locators = null;
            String locatorName = (String)request.getAttribute("org.apache.jetspeed.profiler.ProfileLocator");
            if (locatorName != null && (locator = this.profiler.getProfile(request, locatorName)) != null) {
                locators = new HashMap<String, ProfileLocator>();
                locators.put("page", locator);
            }
            if (locators == null) {
                locators = this.profiler.getProfileLocators(request, principal);
            }
            if (locators.size() == 0) {
                locators = this.profiler.getDefaultProfileLocators(request);
            }
            if (locators.size() == 0) {
                locators.put("page", this.profiler.getProfile(request, "page"));
            }
            if (locators != null) {
                PortalSiteSessionContext sessionContext = (PortalSiteSessionContext)request.getSessionAttribute(PORTAL_SITE_SESSION_CONTEXT_ATTR_KEY);
                if (sessionContext == null) {
                    sessionContext = this.portalSite.newSessionContext();
                    request.setSessionAttribute(PORTAL_SITE_SESSION_CONTEXT_ATTR_KEY, (Object)sessionContext);
                }
                PortalSiteRequestContext requestContext = sessionContext.newRequestContext(locators);
                request.setAttribute(PORTAL_SITE_REQUEST_CONTEXT_ATTR_KEY, (Object)requestContext);
                request.setAttribute(PROFILED_PAGE_CONTEXT_ATTR_KEY, (Object)requestContext);
                request.setPage((ContentPage)new ContentPageImpl(requestContext.getManagedPage()));
                request.setProfileLocators(requestContext.getLocators());
            }
            context.invokeNext(request);
        }
        catch (SecurityException se) {
            if (request.getRequest().getUserPrincipal() == null && request.getPath() != null && !request.getPath().equals("/")) {
                try {
                    request.getResponse().sendRedirect(request.getRequest().getContextPath());
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            this.log.error((Object)se.getMessage(), (Throwable)se);
            try {
                request.getResponse().sendError(403, se.getMessage());
            }
            catch (IOException ioe) {
                this.log.error((Object)("Failed to invoke HttpServletReponse.sendError: " + ioe.getMessage()), (Throwable)ioe);
            }
        }
        catch (NodeNotFoundException nnfe) {
            this.log.error((Object)nnfe.getMessage(), (Throwable)nnfe);
            try {
                request.getResponse().sendError(404, nnfe.getMessage());
            }
            catch (IOException ioe) {
                this.log.error((Object)("Failed to invoke HttpServletReponse.sendError: " + ioe.getMessage()), (Throwable)ioe);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Exception in request pipeline: " + e.getMessage()), (Throwable)e);
            throw new PipelineException(e.toString(), e);
        }
    }

    public String toString() {
        return "ProfilerValve";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

