/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.localization.impl;

import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.i18n.CurrentLocale;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.LocalizationValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SecurityHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.util.JetspeedLocale;

public class LocalizationValveImpl
extends AbstractValve
implements LocalizationValve {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$localization$impl$LocalizationValveImpl == null ? (class$org$apache$jetspeed$localization$impl$LocalizationValveImpl = LocalizationValveImpl.class$("org.apache.jetspeed.localization.impl.LocalizationValveImpl")) : class$org$apache$jetspeed$localization$impl$LocalizationValveImpl));
    private Locale defaultLocale = null;
    static /* synthetic */ Class class$org$apache$jetspeed$localization$impl$LocalizationValveImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserManager;

    public LocalizationValveImpl() {
    }

    public LocalizationValveImpl(String defaultLanguage) {
        String language;
        String string = language = defaultLanguage != null ? defaultLanguage.trim() : "";
        if (language.length() > 0) {
            String country = "";
            String variant = "";
            int countryIndex = language.indexOf(95);
            if (countryIndex > -1) {
                country = language.substring(countryIndex + 1).trim();
                language = language.substring(0, countryIndex).trim();
                int vDash = country.indexOf("_");
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                }
            }
            this.defaultLocale = new Locale(language, country, variant);
            if (this.defaultLocale.getLanguage().length() == 0) {
                this.defaultLocale = null;
                log.warn((Object)("Invalid or unrecognized default language: " + language));
            } else {
                log.info((Object)("Default language set: " + this.defaultLocale));
            }
        }
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        Principal userPrincipal;
        Locale locale = null;
        Subject subject = request.getSubject();
        if (null != subject && null != (userPrincipal = SecurityHelper.getPrincipal((Subject)subject, (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = LocalizationValveImpl.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal)))) {
            log.debug((Object)("Got user principal: " + userPrincipal.getName()));
            UserManager userMgr = (UserManager)Jetspeed.getComponentManager().getComponent((Object)(class$org$apache$jetspeed$security$UserManager == null ? (class$org$apache$jetspeed$security$UserManager = LocalizationValveImpl.class$("org.apache.jetspeed.security.UserManager")) : class$org$apache$jetspeed$security$UserManager));
            try {
                User user;
                Preferences prefs;
                String localeString;
                if (!userMgr.getAnonymousUser().equals(userPrincipal.getName()) && userMgr.userExists(userPrincipal.getName()) && (localeString = (prefs = (user = userMgr.getUser(userPrincipal.getName())).getPreferences()).get("org.apache.jetspeed.prefered.locale", null)) != null) {
                    locale = JetspeedLocale.convertStringToLocale((String)localeString);
                }
            }
            catch (SecurityException e) {
                log.warn((Object)"Unexpected SecurityException in UserInfoManager", (Throwable)e);
            }
        }
        if (locale == null) {
            locale = (Locale)request.getSessionAttribute("org.apache.jetspeed.prefered.locale");
        }
        if (locale == null && this.defaultLocale != null) {
            locale = this.defaultLocale;
        }
        if (locale == null) {
            locale = request.getRequest().getLocale();
        }
        if (locale == null) {
            Enumeration preferedLocales = request.getRequest().getLocales();
            while (preferedLocales.hasMoreElements() && locale == null) {
                locale = (Locale)preferedLocales.nextElement();
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        request.setLocale(locale);
        request.getRequest().setAttribute("org.apache.jetspeed.prefered.locale", (Object)locale);
        request.getRequest().getSession().setAttribute("org.apache.jetspeed.prefered.locale", (Object)locale);
        CurrentLocale.set((Locale)locale);
        context.invokeNext(request);
    }

    public String toString() {
        return "LocalizationValve";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

