/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.engine.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.http.HttpSession;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.container.namespace.JetspeedNamespaceMapper;
import org.apache.jetspeed.container.namespace.JetspeedNamespaceMapperFactory;
import org.apache.jetspeed.engine.servlet.HttpSessionWrapper;
import org.apache.pluto.om.common.ObjectID;

public class NamespaceEncodedSession
extends HttpSessionWrapper {
    private JetspeedNamespaceMapper nameSpaceMapper;
    private ObjectID webAppId;
    private HashSet mappedNames = new HashSet();
    static /* synthetic */ Class class$org$apache$pluto$util$NamespaceMapper;

    public NamespaceEncodedSession(HttpSession session, ObjectID webAppId) {
        super(session);
        this.nameSpaceMapper = ((JetspeedNamespaceMapperFactory)Jetspeed.getComponentManager().getComponent((Object)(class$org$apache$pluto$util$NamespaceMapper == null ? (class$org$apache$pluto$util$NamespaceMapper = NamespaceEncodedSession.class$("org.apache.pluto.util.NamespaceMapper")) : class$org$apache$pluto$util$NamespaceMapper))).getJetspeedNamespaceMapper();
        this.webAppId = webAppId;
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        if (this.skipEncode(name)) {
            super.setAttribute(name, value);
        } else {
            String encodedKey = this.nameSpaceMapper.encode(this.webAppId, name);
            this.mappedNames.add(name);
            super.setAttribute(encodedKey, value);
        }
    }

    public Object getAttribute(String name) {
        if (this.skipEncode(name)) {
            return super.getAttribute(name);
        }
        return super.getAttribute(this.nameSpaceMapper.encode(this.webAppId, name));
    }

    private boolean skipEncode(String name) {
        return name.startsWith(this.nameSpaceMapper.getPrefix()) || name.startsWith("javax.portlet") || name.startsWith("javax.servlet") || name.startsWith("org.apache.jetspeed");
    }

    public Enumeration getAttributeNames() {
        Enumeration names = super.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!this.skipEncode(name)) continue;
            this.mappedNames.add(name);
        }
        return Collections.enumeration(this.mappedNames);
    }

    public void removeAttribute(String name) {
        if (this.skipEncode(name)) {
            super.removeAttribute(name);
        } else {
            this.mappedNames.add(name);
            super.removeAttribute(this.nameSpaceMapper.encode(this.webAppId, name));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

