/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.engine.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.jetspeed.PortalContext;
import org.apache.pluto.services.information.PortalContextProvider;

public class PortalContextProviderImpl
implements PortalContextProvider {
    private final PortalContext portalContext;
    private String info;
    private final String portalName;
    private final String portalVersion;
    private Vector modes;
    private Vector states;

    public PortalContextProviderImpl(PortalContext portalContext) {
        this.portalContext = portalContext;
        this.modes = this.getDefaultModes();
        this.states = this.getDefaultStates();
        this.portalName = this.portalContext.getConfiguration().getString("portal.name");
        this.portalVersion = this.portalContext.getConfiguration().getString("portal.version");
        this.info = this.portalName + "/" + this.portalVersion;
    }

    public PortalContext getPortalContext() {
        return this.portalContext;
    }

    public String getPortalInfo() {
        return this.info;
    }

    public String getProperty(String name) {
        return this.portalContext.getProperty(name);
    }

    public Collection getPropertyNames() {
        Iterator itr = this.portalContext.getConfiguration().getKeys();
        ArrayList names = new ArrayList();
        while (itr.hasNext()) {
            names.add(itr.next());
        }
        return names;
    }

    public Collection getSupportedPortletModes() {
        return this.modes;
    }

    public Collection getSupportedWindowStates() {
        return this.states;
    }

    private Vector getDefaultModes() {
        Vector<PortletMode> m = new Vector<PortletMode>();
        Enumeration supportedPortletModes = this.portalContext.getSupportedPortletModes();
        while (supportedPortletModes.hasMoreElements()) {
            m.add((PortletMode)supportedPortletModes.nextElement());
        }
        return m;
    }

    private Vector getDefaultStates() {
        Vector<WindowState> s = new Vector<WindowState>();
        Enumeration supportedWindowStates = this.portalContext.getSupportedWindowStates();
        while (supportedWindowStates.hasMoreElements()) {
            s.add((WindowState)supportedWindowStates.nextElement());
        }
        return s;
    }

    public void setProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        this.portalContext.getConfiguration().setProperty(name, (Object)value);
    }

    public void setSupportedPortletModes(Enumeration portletModes) {
        Vector v = new Vector();
        while (portletModes.hasMoreElements()) {
            v.add(portletModes.nextElement());
        }
        this.modes = v;
    }

    public void setSupportedWindowStates(Enumeration windowStates) {
        Vector v = new Vector();
        while (windowStates.hasMoreElements()) {
            v.add(windowStates.nextElement());
        }
        this.states = v;
    }

    public void reset(String portalInfo) {
        this.info = new String(portalInfo);
        this.modes = this.getDefaultModes();
        this.states = this.getDefaultStates();
    }
}

