/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.engine;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.components.SpringComponentManager;
import org.apache.jetspeed.components.factorybeans.ServletConfigFactoryBean;
import org.apache.jetspeed.engine.Engine;
import org.apache.jetspeed.engine.JetspeedEngine;
import org.apache.jetspeed.engine.JetspeedEngineConstants;
import org.apache.jetspeed.engine.servlet.ServletHelper;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.request.RequestContextComponent;

public class JetspeedServlet
extends HttpServlet
implements JetspeedEngineConstants {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$engine$JetspeedServlet == null ? (class$org$apache$jetspeed$engine$JetspeedServlet = JetspeedServlet.class$("org.apache.jetspeed.engine.JetspeedServlet")) : class$org$apache$jetspeed$engine$JetspeedServlet));
    private static final Log console = LogFactory.getLog((String)"console");
    private static boolean firstInit = true;
    private static Throwable initFailure = null;
    private static boolean firstDoGet = true;
    private static Engine engine;
    private static String webappRoot;
    private static final String INIT_START_MSG = "Jetspeed Starting Initialization...";
    private static final String INIT_DONE_MSG = "Jetspeed Initialization complete, Ready to service requests.";
    static /* synthetic */ Class class$org$apache$jetspeed$engine$JetspeedServlet;
    static /* synthetic */ Class class$org$apache$jetspeed$request$RequestContextComponent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(ServletConfig config) throws ServletException {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            console.info((Object)INIT_START_MSG);
            super.init(config);
            if (!firstInit) {
                log.info((Object)"Double initialization of Jetspeed was attempted!");
                console.info((Object)"Double initialization of Jetspeed was attempted!");
                return;
            }
            firstInit = false;
            try {
                ServletContext context = config.getServletContext();
                String propertiesFilename = ServletHelper.findInitParameter(context, config, "properties", "/WEB-INF/conf/jetspeed.properties");
                String applicationRoot = ServletHelper.findInitParameter(context, config, "applicationRoot", "webContext");
                console.info((Object)"JetspeedServlet identifying web application root...");
                webappRoot = config.getServletContext().getRealPath("/");
                console.info((Object)("JetspeedServlet identifed web application root as " + webappRoot));
                if (applicationRoot == null || applicationRoot.equals("webContext")) {
                    applicationRoot = webappRoot;
                }
                PropertiesConfiguration properties = new PropertiesConfiguration(ServletHelper.getRealPath(config, propertiesFilename));
                properties.setProperty("applicationRoot", (Object)applicationRoot);
                properties.setProperty("webappRoot", (Object)webappRoot);
                console.info((Object)"JetspeedServlet attempting to create the  portlet engine...");
                engine = new JetspeedEngine((Configuration)properties, applicationRoot, config, this.initializeComponentManager(config, applicationRoot, (Configuration)properties));
                console.info((Object)"JetspeedServlet attempting to start the Jetspeed Portal Engine...");
                engine.start();
                Jetspeed.setEngine(engine);
                console.info((Object)"JetspeedServlet has successfuly started the Jetspeed Portal Engine....");
            }
            catch (Throwable e) {
                String msg = "Jetspeed: init() failed: ";
                initFailure = e;
                log.fatal((Object)"Jetspeed: init() failed: ", e);
                console.fatal((Object)"Jetspeed: init() failed: ", e);
            }
            console.info((Object)INIT_DONE_MSG);
            log.info((Object)INIT_DONE_MSG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(HttpServletRequest request, HttpServletResponse response) {
        Class clazz = class$org$apache$jetspeed$engine$JetspeedServlet == null ? (class$org$apache$jetspeed$engine$JetspeedServlet = JetspeedServlet.class$("org.apache.jetspeed.engine.JetspeedServlet")) : class$org$apache$jetspeed$engine$JetspeedServlet;
        synchronized (clazz) {
            if (firstDoGet) {
                firstDoGet = false;
            }
        }
    }

    public final void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            String wasFiltered;
            if (initFailure != null) {
                throw new ServletException("Failed to initalize jetspeed.  " + initFailure.toString(), initFailure);
            }
            if (firstDoGet) {
                this.init(req, res);
            }
            if ((wasFiltered = (String)req.getAttribute("org.apache.jetspeed.content.filtered")) == null || !wasFiltered.equals("true")) {
                RequestContextComponent contextComponent = (RequestContextComponent)Jetspeed.getComponentManager().getComponent((Object)(class$org$apache$jetspeed$request$RequestContextComponent == null ? (class$org$apache$jetspeed$request$RequestContextComponent = JetspeedServlet.class$("org.apache.jetspeed.request.RequestContextComponent")) : class$org$apache$jetspeed$request$RequestContextComponent));
                RequestContext context = contextComponent.create(req, res, this.getServletConfig());
                engine.service(context);
                contextComponent.release(context);
            }
        }
        catch (JetspeedException e) {
            String msg = "Fatal error encountered while processing portal request: " + e.toString();
            log.fatal((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
    }

    public final void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public final void destroy() {
        try {
            Jetspeed.shutdown();
        }
        catch (JetspeedException e) {
            log.fatal((Object)"Jetspeed: shutdown() failed: ", (Throwable)e);
            System.err.println(ExceptionUtils.getStackTrace((Throwable)e));
        }
        firstInit = true;
        log.info((Object)"Done shutting down!");
    }

    private void debugHeaders(HttpServletRequest req) {
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = req.getHeader(name);
            System.out.println("name = " + name);
            System.out.println("value = " + value);
        }
    }

    protected ComponentManager initializeComponentManager(ServletConfig servletConfig, String appRoot, Configuration configuration) throws IOException {
        ServletConfigFactoryBean.setServletConfig((ServletConfig)servletConfig);
        String relativeApplicationRoot = appRoot;
        String absApplicationRoot = new File(relativeApplicationRoot).getCanonicalPath();
        String assemblyDir = configuration.getString("assembly.dir", "/WEB-INF/assembly");
        String assemblyFileExtension = configuration.getString("assembly.extension", ".xml");
        String[] bootConfigs = new String[]{"/WEB-INF/assembly/boot/*.xml"};
        String[] appConfigs = new String[]{assemblyDir + "/*" + assemblyFileExtension};
        ServletContext servletContext = servletConfig.getServletContext();
        SpringComponentManager cm = new SpringComponentManager(bootConfigs, appConfigs, servletContext, appRoot);
        return cm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

