/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.engine;

import java.io.File;
import java.io.FileInputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.servlet.ServletConfig;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.JetspeedPortalContext;
import org.apache.jetspeed.PortalContext;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.engine.Engine;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.pipeline.Pipeline;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.request.RequestContextComponent;
import org.apache.jetspeed.util.IsolatedLog4JLogger;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootCategory;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.factory.Factory;
import org.apache.pluto.services.ContainerService;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class JetspeedEngine
implements Engine {
    private final PortalContext context;
    private final ServletConfig config;
    private final ComponentManager componentManager;
    private final Configuration configuration;
    private final String applicationRoot;
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$engine$JetspeedEngine == null ? (class$org$apache$jetspeed$engine$JetspeedEngine = JetspeedEngine.class$("org.apache.jetspeed.engine.JetspeedEngine")) : class$org$apache$jetspeed$engine$JetspeedEngine));
    private static final Log console = LogFactory.getLog((String)"console");
    protected String defaultPipelineName;
    static /* synthetic */ Class class$org$apache$jetspeed$engine$JetspeedEngine;
    static /* synthetic */ Class class$org$apache$pluto$PortletContainer;
    static /* synthetic */ Class class$org$apache$jetspeed$request$RequestContextComponent;
    static /* synthetic */ Class class$org$apache$pluto$services$factory$FactoryManagerService;

    public JetspeedEngine(Configuration configuration, String applicationRoot, ServletConfig config, ComponentManager componentManager) {
        this.configuration = configuration;
        this.applicationRoot = applicationRoot;
        this.componentManager = componentManager;
        this.context = new JetspeedPortalContext(this, configuration, applicationRoot);
        this.config = config;
        this.context.setApplicationRoot(applicationRoot);
        this.context.setConfiguration(configuration);
        this.defaultPipelineName = configuration.getString("pipeline.default", "jetspeed-pipeline");
        configuration.setProperty("applicationRoot", (Object)applicationRoot);
        componentManager.addComponent("Engine", (Object)this);
        componentManager.addComponent("PortalContext", (Object)this.context);
    }

    public void start() throws JetspeedException {
        Date endTime2;
        DateFormat format = DateFormat.getInstance();
        Date startTime = new Date();
        try {
            try {
                String log4jFile = this.configuration.getString("log4j.file", "/WEB-INF/conf/Log4j.properties");
                log4jFile = this.getRealPath(log4jFile);
                Properties p = new Properties();
                p.load(new FileInputStream(log4jFile));
                p.setProperty("applicationRoot", this.context.getApplicationRoot());
                Hierarchy h = new Hierarchy((Logger)new RootCategory(Level.INFO));
                new PropertyConfigurator().doConfigure(p, (LoggerRepository)h);
                IsolatedLog4JLogger.setHierarchy(h);
                log.info((Object)("Configured log4j from " + log4jFile));
                log.info((Object)("Starting Jetspeed Engine (" + this.getClass().getName() + ") at " + format.format(startTime)));
                ClassLoader ploader2 = this.getClass().getClassLoader();
                ClassHelper.setClassLoader((ClassLoader)ploader2);
                this.componentManager.start();
            }
            catch (Throwable e) {
                e.printStackTrace();
                log.error((Object)e.toString());
                throw new JetspeedException("Jetspeed Initialization exception!", e);
            }
            Object var8_8 = null;
            endTime2 = new Date();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Date endTime2 = new Date();
            long elapsedTime = (endTime2.getTime() - startTime.getTime()) / 1000L;
            log.info((Object)("Finished starting Jetspeed Engine (" + this.getClass().getName() + ") at " + format.format(endTime2) + ".  Elapsed time: " + elapsedTime + " seconds."));
            throw throwable;
        }
        long elapsedTime = (endTime2.getTime() - startTime.getTime()) / 1000L;
        log.info((Object)("Finished starting Jetspeed Engine (" + this.getClass().getName() + ") at " + format.format(endTime2) + ".  Elapsed time: " + elapsedTime + " seconds."));
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void shutdown() throws JetspeedException {
        try {
            PortletContainer container = (PortletContainer)this.componentManager.getComponent((Object)(class$org$apache$pluto$PortletContainer == null ? (class$org$apache$pluto$PortletContainer = JetspeedEngine.class$("org.apache.pluto.PortletContainer")) : class$org$apache$pluto$PortletContainer));
            if (container != null) {
                container.shutdown();
            }
            this.componentManager.stop();
        }
        catch (PortletContainerException e) {
            throw new JetspeedException((Throwable)e);
        }
        System.gc();
    }

    public void service(RequestContext context) throws JetspeedException {
        Pipeline specificPipeline;
        String targetPipeline = context.getRequestParameter("pipeline");
        if (null == targetPipeline) {
            targetPipeline = (String)context.getAttribute("pipeline");
        }
        Pipeline pipeline = this.getPipeline();
        if (targetPipeline != null && (specificPipeline = this.getPipeline(targetPipeline)) != null) {
            pipeline = specificPipeline;
        }
        pipeline.invoke(context);
    }

    public PortalContext getContext() {
        return this.context;
    }

    public String getRealPath(String path) {
        String result = "";
        String base = this.context.getApplicationRoot();
        if (base.endsWith(File.separator)) {
            if (path.startsWith("/")) {
                result = base.concat(path.substring(1));
                return result;
            }
        } else if (!path.startsWith("/")) {
            result = base.concat("/").concat(path);
            return result;
        }
        return base.concat(path);
    }

    public Pipeline getPipeline(String pipelineName) {
        return (Pipeline)this.componentManager.getComponent((Object)pipelineName);
    }

    public Pipeline getPipeline() {
        return this.getPipeline(this.defaultPipelineName);
    }

    public RequestContext getCurrentRequestContext() {
        RequestContextComponent contextComponent = (RequestContextComponent)this.getComponentManager().getComponent((Object)(class$org$apache$jetspeed$request$RequestContextComponent == null ? (class$org$apache$jetspeed$request$RequestContextComponent = JetspeedEngine.class$("org.apache.jetspeed.request.RequestContextComponent")) : class$org$apache$jetspeed$request$RequestContextComponent));
        return contextComponent.getRequestContext();
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public Factory getFactory(Class theClass) {
        return (Factory)this.getComponentManager().getComponent((Object)theClass);
    }

    public ContainerService getContainerService(Class service) {
        if (service.equals(class$org$apache$pluto$services$factory$FactoryManagerService == null ? (class$org$apache$pluto$services$factory$FactoryManagerService = JetspeedEngine.class$("org.apache.pluto.services.factory.FactoryManagerService")) : class$org$apache$pluto$services$factory$FactoryManagerService)) {
            return this;
        }
        try {
            return (ContainerService)this.getComponentManager().getComponent((Object)service);
        }
        catch (NoSuchBeanDefinitionException e) {
            log.warn((Object)("No ContainerService defined for " + service.getName()));
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

