/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.deployment.simpleregistry.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.deployment.simpleregistry.Entry;
import org.apache.jetspeed.deployment.simpleregistry.SimpleRegistry;
import org.apache.jetspeed.deployment.simpleregistry.SimpleRegistryException;

public class InMemoryRegistryImpl
implements SimpleRegistry {
    protected Map registry = new HashMap();

    public void register(Entry entry) throws SimpleRegistryException {
        this.checkArguments(entry);
        if (this.isRegistered(entry)) {
            throw new SimpleRegistryException(entry.getId() + " is already registered.");
        }
        this.registry.put(entry.getId(), entry);
    }

    public void deRegister(Entry entry) {
        this.checkArguments(entry);
        this.registry.remove(entry.getId());
    }

    public boolean isRegistered(Entry entry) {
        this.checkArguments(entry);
        return this.registry.containsKey(entry.getId());
    }

    public Collection getRegistry() {
        return this.registry.values();
    }

    protected void checkArguments(Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be null.");
        }
        if (entry.getId() == null) {
            throw new IllegalArgumentException("Entry.getId() cannot be null.");
        }
    }
}

