/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.deployment.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jetspeed.deployment.DeploymentObject;
import org.apache.jetspeed.deployment.impl.FileNotDeployableException;

public class StandardDeploymentObject
implements DeploymentObject {
    protected File deploymentObject;
    protected ZipFile zipFile;

    public StandardDeploymentObject(File deploymentObject) throws FileNotDeployableException {
        if (!this.verifyExtension(deploymentObject)) {
            throw new FileNotDeployableException("File type for " + deploymentObject.getName() + " is not supported by StandardDeploymentObject.");
        }
        this.deploymentObject = deploymentObject;
    }

    public void close() throws IOException {
        if (this.zipFile != null) {
            this.zipFile.close();
            this.zipFile = null;
        }
    }

    public InputStream getConfiguration(String configPath) throws IOException {
        ZipFile zipFile = this.getZipFile();
        ZipEntry entry = zipFile.getEntry(configPath);
        if (entry != null) {
            return zipFile.getInputStream(entry);
        }
        return null;
    }

    public String getName() {
        return this.deploymentObject.getName();
    }

    public String getPath() {
        return this.deploymentObject.getAbsolutePath();
    }

    public ZipFile getZipFile() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.deploymentObject);
        }
        return this.zipFile;
    }

    public File getFile() {
        return this.deploymentObject;
    }

    protected boolean verifyExtension(File file) {
        String fileName = file.getName();
        int dot = fileName.lastIndexOf(46);
        if (dot != -1) {
            String ext = fileName.substring(dot);
            return ext.equals(".war") || ext.equals(".jar") || ext.equals(".zip");
        }
        return false;
    }
}

