/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.deployment.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.deployment.DeploymentEvent;
import org.apache.jetspeed.deployment.DeploymentEventListener;
import org.apache.jetspeed.deployment.DeploymentException;
import org.apache.jetspeed.deployment.DeploymentManager;
import org.apache.jetspeed.deployment.DeploymentStatus;
import org.apache.jetspeed.deployment.impl.DeploymentEventImpl;
import org.apache.jetspeed.deployment.impl.StandardDeploymentObject;

public class StandardDeploymentManager
implements DeploymentManager {
    protected Log log = LogFactory.getLog((String)"deployment");
    protected FileSystemScanner scanner;
    protected PortletRegistry registry;
    protected Collection deploymentListeners;
    protected long scanningDelay;
    protected String stagingDirectories;
    protected File[] stagingDirectoriesAsFiles;
    protected HashMap ignoredFiles;

    public StandardDeploymentManager(String stagingDirectories, long scanningDelay, Collection deploymentListeners) {
        this.scanningDelay = scanningDelay;
        this.stagingDirectories = stagingDirectories;
        StringTokenizer dirTokenizer = new StringTokenizer(stagingDirectories, ",");
        this.stagingDirectoriesAsFiles = new File[dirTokenizer.countTokens()];
        int i = 0;
        while (dirTokenizer.hasMoreTokens()) {
            this.stagingDirectoriesAsFiles[i] = new File(dirTokenizer.nextToken());
            ++i;
        }
        this.deploymentListeners = deploymentListeners;
        this.ignoredFiles = new HashMap();
    }

    public void start() {
        this.log.info((Object)("Starting auto deployment service: " + this.getClass().getName()));
        this.log.info((Object)("Deployment scanning delay: " + this.scanningDelay));
        this.log.info((Object)("Deployment staging directory: " + this.stagingDirectories));
        for (int i = 0; i < this.stagingDirectoriesAsFiles.length; ++i) {
            if (this.stagingDirectoriesAsFiles[i].exists()) continue;
            this.log.error((Object)(this.stagingDirectoriesAsFiles[i].getAbsolutePath() + " does not exist, auto deployment disabled."));
            this.stop();
            return;
        }
        Iterator itr = this.deploymentListeners.iterator();
        while (itr.hasNext()) {
            ((DeploymentEventListener)itr.next()).initialize();
        }
        if (this.scanningDelay > -1L) {
            try {
                this.scanner = new FileSystemScanner(Thread.currentThread().getThreadGroup(), "Autodeployment File Scanner Thread");
                this.scanner.setDaemon(true);
                this.scanner.setContextClassLoader(this.getClass().getClassLoader());
                this.scanner.start();
                this.log.info((Object)"Deployment scanner successfuly started!");
            }
            catch (Exception e) {
                this.log.warn((Object)("Unable to intialize Catalina Portlet Application Manager.  Auto deployment will be disabled: " + e.toString()), (Throwable)e);
                this.stop();
                return;
            }
        } else {
            this.log.info((Object)("Scanning delay set to " + this.scanningDelay + " has disabled automatic scanning of staging directory."));
        }
    }

    public void stop() {
        if (this.scanner != null) {
            this.scanner.safeStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized DeploymentStatus deploy(File aFile) throws DeploymentException {
        StandardDeploymentObject deploymentObject = new StandardDeploymentObject(aFile);
        DeploymentEventImpl event = null;
        try {
            event = new DeploymentEventImpl(deploymentObject);
            this.dispatch(event);
            Object var5_4 = null;
            if (deploymentObject == null) return event;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (deploymentObject == null) throw throwable;
            try {
                deploymentObject.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            deploymentObject.close();
            return event;
        }
        catch (IOException e) {}
        return event;
    }

    public void fireDeploymentEvent() {
        File[] stagedFiles = this.getAllStagedFiles();
        for (int i = 0; i < stagedFiles.length; ++i) {
            File aFile = stagedFiles[i];
            if (this.ignoreFile(aFile)) continue;
            boolean failed = false;
            boolean unknown = false;
            DeploymentStatus status = null;
            Exception de = null;
            try {
                status = this.deploy(aFile);
            }
            catch (Exception e) {
                de = e;
            }
            if (status != null && status.getStatus() == 1) {
                if (!aFile.exists()) continue;
                this.log.info((Object)("File: " + aFile.getAbsolutePath() + " deployed"));
                boolean result = aFile.delete();
                if (result) continue;
                this.log.error((Object)("Failed to remove: " + aFile));
                continue;
            }
            if (status == null || status.getStatus() == 0) {
                this.log.warn((Object)("Unrecognized file " + aFile.getAbsolutePath()));
            } else if (de != null) {
                this.log.error((Object)("Failure deploying " + aFile.getAbsolutePath()), (Throwable)de);
            } else {
                this.log.error((Object)("Failure deploying " + aFile.getAbsolutePath()));
            }
            this.ignoredFiles.put(aFile.getAbsolutePath(), new Long(aFile.lastModified()));
        }
    }

    public void dispatch(DeploymentEvent event) {
        try {
            Iterator itr = this.deploymentListeners.iterator();
            while (itr.hasNext()) {
                DeploymentEventListener listener = (DeploymentEventListener)itr.next();
                listener.invokeDeploy(event);
                if (event.getStatus() == 0) continue;
                break;
            }
        }
        catch (DeploymentException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            event.setStatus(-1);
        }
    }

    protected boolean ignoreFile(File aFile) {
        Long previousModified = (Long)this.ignoredFiles.get(aFile.getAbsolutePath());
        if (previousModified != null) {
            if (previousModified.longValue() != aFile.lastModified()) {
                this.ignoredFiles.remove(aFile.getAbsolutePath());
            } else {
                return true;
            }
        }
        return false;
    }

    protected File[] getAllStagedFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        for (int i = 0; i < this.stagingDirectoriesAsFiles.length; ++i) {
            fileList.addAll(Arrays.asList(this.stagingDirectoriesAsFiles[i].listFiles()));
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public class FileSystemScanner
    extends Thread {
        private boolean started = true;

        public FileSystemScanner(ThreadGroup threadGroup, String name) throws FileNotFoundException, IOException {
            super(threadGroup, name);
            this.setPriority(1);
        }

        public void run() {
            try {
                FileSystemScanner.sleep(StandardDeploymentManager.this.scanningDelay * 2L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            while (this.started) {
                StandardDeploymentManager.this.fireDeploymentEvent();
                try {
                    FileSystemScanner.sleep(StandardDeploymentManager.this.scanningDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void safeStop() {
            this.started = false;
        }
    }
}

