/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.deployment.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.deployment.DeploymentEvent;
import org.apache.jetspeed.deployment.DeploymentEventListener;
import org.apache.jetspeed.deployment.DeploymentException;
import org.apache.jetspeed.deployment.impl.JarExpander;
import org.apache.jetspeed.tools.deploy.JetspeedDeploy;
import org.apache.jetspeed.tools.pamanager.PortletApplicationManagement;
import org.apache.jetspeed.util.DirectoryHelper;
import org.apache.jetspeed.util.FileSystemHelper;

public class DeployPortletAppEventListener
implements DeploymentEventListener {
    protected static final Log log = LogFactory.getLog((String)"deployment");
    private String webAppDir;
    private String localAppDir;
    private boolean stripLoggers;
    private PortletApplicationManagement pam;
    private PortletRegistry registry;

    public DeployPortletAppEventListener(PortletApplicationManagement pam, PortletRegistry registry, String webAppDir, String localAppDir, boolean stripLoggers) throws FileNotFoundException {
        this.pam = pam;
        this.registry = registry;
        this.stripLoggers = stripLoggers;
        File webAppDirFile = new File(webAppDir);
        if (webAppDirFile.exists()) {
            try {
                this.webAppDir = webAppDirFile.getCanonicalPath();
            }
            catch (IOException e) {}
        } else {
            throw new FileNotFoundException("The depoyment directory for portlet applications \"" + webAppDirFile.getAbsolutePath() + "\" does not exist.");
        }
        File localAppDirFile = new File(localAppDir);
        if (!localAppDirFile.exists()) {
            localAppDirFile.mkdirs();
        } else if (!localAppDirFile.isDirectory()) {
            throw new FileNotFoundException("Invalid depoyment directory for local portlet applications: \"" + localAppDirFile.getAbsolutePath());
        }
        try {
            this.localAppDir = localAppDirFile.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void initialize() {
        File[] localApps = new File(this.localAppDir).listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        for (int i = 0; i < localApps.length; ++i) {
            if (!new File(localApps[i], "WEB-INF/portlet.xml").exists()) {
                log.warn((Object)("Not a local application " + localApps[i].getName()));
                continue;
            }
            DirectoryHelper paDirHelper = new DirectoryHelper(localApps[i]);
            try {
                this.pam.startLocalPortletApplication(localApps[i].getName(), (FileSystemHelper)paDirHelper, this.createLocalPAClassLoader(localApps[i]));
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Failed to start Local Portlet Application " + localApps[i]), (Throwable)e);
            }
        }
    }

    public void invokeDeploy(DeploymentEvent event) throws DeploymentException {
        String fileName = event.getName();
        if (fileName.endsWith(".war")) {
            int prefixLength = "jetspeed-".length();
            if (fileName.length() > prefixLength && fileName.substring(0, prefixLength).equalsIgnoreCase("jetspeed-")) {
                this.deployLocalPortletApplication(event);
            } else {
                this.deployPortletApplication(event);
            }
        }
    }

    protected void deployPortletApplication(DeploymentEvent event) throws DeploymentException {
        try {
            File toFile = new File(this.webAppDir, event.getName());
            new JetspeedDeploy(event.getPath(), toFile.getAbsolutePath(), this.stripLoggers);
            event.setStatus(1);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected void deployLocalPortletApplication(DeploymentEvent event) throws DeploymentException {
        try {
            String fileName = event.getName();
            String appName = fileName.substring(0, fileName.length() - 4);
            this.pam.stopLocalPortletApplication(appName);
            File targetDir = new File(this.localAppDir, appName);
            JarExpander.expand(event.getDeploymentObject().getFile(), targetDir);
            DirectoryHelper paDirHelper = new DirectoryHelper(targetDir);
            this.pam.startLocalPortletApplication(appName, (FileSystemHelper)paDirHelper, this.createLocalPAClassLoader(targetDir));
            event.setStatus(1);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected ClassLoader createLocalPAClassLoader(File paDir) throws IOException {
        File webInfLib;
        ArrayList<URL> urls = new ArrayList<URL>();
        File webInfClasses = null;
        webInfClasses = new File(paDir, "WEB-INF/classes/");
        if (webInfClasses.exists()) {
            log.info((Object)("Adding " + webInfClasses.toURL() + " to class path for Local PA " + paDir.getName()));
            urls.add(webInfClasses.toURL());
        }
        if ((webInfLib = new File(paDir, "WEB-INF/lib")).exists()) {
            File[] jars = webInfLib.listFiles();
            for (int i = 0; i < jars.length; ++i) {
                File jar = jars[i];
                log.info((Object)("Adding " + jar.toURL() + " to class path for Local PA " + paDir.getName()));
                urls.add(jar.toURL());
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
    }
}

