/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.deployment.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.deployment.DeploymentEvent;
import org.apache.jetspeed.deployment.DeploymentEventListener;
import org.apache.jetspeed.deployment.DeploymentException;
import org.apache.jetspeed.deployment.impl.JarExpander;
import org.apache.jetspeed.util.DirectoryHelper;

public class DeployDecoratorEventListener
implements DeploymentEventListener {
    protected static final Log log = LogFactory.getLog((String)"deployment");
    protected String deployToDir;

    public DeployDecoratorEventListener(String deployToDir) throws FileNotFoundException {
        File checkFile = new File(deployToDir);
        if (checkFile.exists()) {
            try {
                this.deployToDir = checkFile.getCanonicalPath();
            }
            catch (IOException iOException) {}
        } else {
            throw new FileNotFoundException("The deployment directory, " + checkFile.getAbsolutePath() + ", does not exist");
        }
    }

    public void initialize() {
    }

    public void invokeDeploy(DeploymentEvent event) throws DeploymentException {
        String fileName = event.getName();
        if (!fileName.endsWith(".jar") && !fileName.endsWith(".zip")) {
            return;
        }
        PropertiesConfiguration conf = this.getDecoratorConfiguration(event);
        if (conf == null) {
            return;
        }
        String id = conf.getString("id");
        if (id == null) {
            throw new DeploymentException("Unable to deploy decorator, \"id\" attribute not defined in configuration");
        }
        log.info((Object)("Found decorator deployment archive " + id));
        try {
            String baseDeployPath = this.getBaseDeployPath(conf);
            String deployPath = baseDeployPath + File.separator + id;
            File deployPathFile = new File(deployPath);
            if (deployPathFile.exists()) {
                this.invokeUndeploy(deployPathFile);
            }
            log.info((Object)("Deploying decorator " + id + " to " + deployPath));
            JarExpander.expand(event.getDeploymentObject().getFile(), deployPathFile);
            File metaInf = new File(deployPathFile, "META-INF");
            if (metaInf.exists()) {
                DirectoryHelper cleanup = new DirectoryHelper(metaInf);
                cleanup.remove();
                cleanup.close();
            }
            final List localeSpecificDeployPathsList = this.getLocaleSpecificDeployPaths(deployPathFile);
            Iterator deployPathsIter = localeSpecificDeployPathsList.iterator();
            while (deployPathsIter.hasNext()) {
                File localeDeployPathFile = (File)deployPathsIter.next();
                File deployToPathFile = new File(baseDeployPath + localeDeployPathFile.getPath().substring(deployPath.length()) + File.separator + id);
                log.info((Object)("Deploying locale specific decorator component to " + deployToPathFile.getPath()));
                deployToPathFile.mkdirs();
                File[] filesToDeploy = localeDeployPathFile.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return !localeSpecificDeployPathsList.contains(pathname);
                    }
                });
                for (int i = 0; i < filesToDeploy.length; ++i) {
                    filesToDeploy[i].renameTo(new File(deployToPathFile, filesToDeploy[i].getName()));
                }
            }
            Iterator cleanupDeployPathsIter = localeSpecificDeployPathsList.iterator();
            while (cleanupDeployPathsIter.hasNext()) {
                File cleanupLocaleDeployPathFile = (File)cleanupDeployPathsIter.next();
                if (!cleanupLocaleDeployPathFile.exists()) continue;
                DirectoryHelper cleanup = new DirectoryHelper(cleanupLocaleDeployPathFile);
                cleanup.remove();
                cleanup.close();
            }
            log.info((Object)("Decorator " + id + " deployed successfuly."));
            event.setStatus(1);
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeploymentException("Error deploying decorator " + id, (Throwable)e);
        }
    }

    public void invokeUndeploy(File deployPathFile) throws DeploymentException {
        if (!(deployPathFile != null && deployPathFile.exists() && deployPathFile.isDirectory() && deployPathFile.getParentFile() != null && deployPathFile.getParentFile().getParentFile() != null && this.deployToDir.equals(deployPathFile.getParentFile().getParentFile().getParent()))) {
            throw new DeploymentException("Cannot undeploy decorator at " + deployPathFile + ": invalid decorator path");
        }
        String id = deployPathFile.getName();
        try {
            log.info((Object)("Undeploying decorator " + id + " at " + deployPathFile.getAbsolutePath()));
            List localeSpecificDeployPathsList = this.getLocaleSpecificDeployPaths(deployPathFile.getParentFile());
            for (int i = localeSpecificDeployPathsList.size() - 1; i > -1; --i) {
                File localeDeployPathFile = new File((File)localeSpecificDeployPathsList.get(i), id);
                if (!localeDeployPathFile.exists()) continue;
                log.info((Object)("Undeploying locale specific decorator component at " + localeDeployPathFile.getPath()));
                DirectoryHelper cleanup = new DirectoryHelper(localeDeployPathFile);
                cleanup.remove();
                cleanup.close();
                localeDeployPathFile.getParentFile().delete();
            }
            DirectoryHelper cleanup = new DirectoryHelper(deployPathFile);
            cleanup.remove();
            cleanup.close();
            log.info((Object)("Decorator " + id + " undeployed successfuly."));
        }
        catch (Exception e) {
            throw new DeploymentException("Error undeploying decorator " + id, (Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    private PropertiesConfiguration getDecoratorConfiguration(DeploymentEvent event) throws DeploymentException {
        PropertiesConfiguration propertiesConfiguration;
        InputStream stream;
        block15: {
            block13: {
                PropertiesConfiguration propertiesConfiguration2;
                block14: {
                    block11: {
                        PropertiesConfiguration propertiesConfiguration3;
                        block12: {
                            stream = null;
                            if (event.getDeploymentObject() != null) break block11;
                            propertiesConfiguration3 = null;
                            Object var6_7 = null;
                            if (stream == null) break block12;
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        return propertiesConfiguration3;
                    }
                    stream = event.getDeploymentObject().getConfiguration("decorator.properties");
                    if (stream != null) break block13;
                    propertiesConfiguration2 = null;
                    Object var6_8 = null;
                    if (stream == null) break block14;
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return propertiesConfiguration2;
            }
            PropertiesConfiguration configuration = new PropertiesConfiguration();
            configuration.load(stream);
            propertiesConfiguration = configuration;
            Object var6_9 = null;
            if (stream == null) break block15;
            try {
                stream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return propertiesConfiguration;
        catch (Exception e1) {
            try {
                throw new DeploymentException("Error reading decorator.properties from " + event.getPath(), (Throwable)e1);
            }
            catch (Throwable throwable) {
                block16: {
                    Object var6_10 = null;
                    if (stream == null) break block16;
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
        }
    }

    private String getBaseDeployPath(PropertiesConfiguration configuration) {
        String layoutType = configuration.getString("decorates", "generic");
        if (layoutType.equalsIgnoreCase("any")) {
            layoutType = "generic";
        }
        String mediaType = configuration.getString("media.type", "html");
        return this.deployToDir + File.separator + layoutType + File.separator + mediaType;
    }

    private List getLocaleSpecificDeployPaths(File rootPath) {
        ArrayList<File> localeSpecificDeployPathsList = new ArrayList<File>();
        File[] localeLanguageSpecificRoots = rootPath.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().length() == 2;
            }
        });
        for (int i = 0; i < localeLanguageSpecificRoots.length; ++i) {
            localeSpecificDeployPathsList.add(localeLanguageSpecificRoots[i]);
            File[] localeCountrySpecificPaths = localeLanguageSpecificRoots[i].listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().length() == 2;
                }
            });
            for (int j = 0; j < localeCountrySpecificPaths.length; ++j) {
                localeSpecificDeployPathsList.add(localeCountrySpecificPaths[j]);
            }
        }
        return localeSpecificDeployPathsList;
    }
}

