/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.window.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent;
import org.apache.jetspeed.components.portletentity.PortletEntityNotGeneratedException;
import org.apache.jetspeed.components.portletentity.PortletEntityNotStoredException;
import org.apache.jetspeed.container.window.FailedToCreateWindowException;
import org.apache.jetspeed.container.window.FailedToRetrievePortletWindow;
import org.apache.jetspeed.container.window.PortletWindowAccessor;
import org.apache.jetspeed.om.common.portlet.MutablePortletEntity;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.window.impl.PortletWindowImpl;
import org.apache.jetspeed.util.ArgUtil;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.om.window.PortletWindowCtrl;

public class PortletWindowAccessorImpl
implements PortletWindowAccessor {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$container$window$impl$PortletWindowAccessorImpl == null ? (class$org$apache$jetspeed$container$window$impl$PortletWindowAccessorImpl = PortletWindowAccessorImpl.class$("org.apache.jetspeed.container.window.impl.PortletWindowAccessorImpl")) : class$org$apache$jetspeed$container$window$impl$PortletWindowAccessorImpl));
    private Map windows = new HashMap();
    private PortletEntityAccessComponent entityAccessor;
    private boolean validateWindows = false;
    static /* synthetic */ Class class$org$apache$jetspeed$container$window$impl$PortletWindowAccessorImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$page$ContentFragment;
    static /* synthetic */ Class class$java$lang$String;

    public PortletWindowAccessorImpl(PortletEntityAccessComponent entityAccessor, boolean validateWindows) {
        this.entityAccessor = entityAccessor;
        this.validateWindows = validateWindows;
    }

    public PortletWindow createPortletWindow(PortletEntity entity, String windowId) {
        if (entity == null) {
            throw new IllegalArgumentException("cratePortletWindow requires a non-null PortletEntity");
        }
        PortletWindow found = this.getWindowFromCache(windowId);
        if (found != null) {
            ((PortletWindowCtrl)found).setPortletEntity(entity);
            return found;
        }
        PortletWindowImpl window = new PortletWindowImpl(windowId);
        window.setPortletEntity(entity);
        this.windows.put(windowId, window);
        return window;
    }

    public PortletWindow createPortletWindow(String windowId) {
        PortletWindow found = this.getWindowFromCache(windowId);
        if (found != null) {
            return found;
        }
        PortletWindowImpl window = new PortletWindowImpl(windowId);
        return window;
    }

    public PortletWindow getPortletWindow(String windowId) {
        return this.getWindowFromCache(windowId);
    }

    public PortletWindow getPortletWindow(ContentFragment fragment) throws FailedToRetrievePortletWindow, PortletEntityNotStoredException {
        ArgUtil.assertNotNull((Class)(class$org$apache$jetspeed$om$page$ContentFragment == null ? (class$org$apache$jetspeed$om$page$ContentFragment = PortletWindowAccessorImpl.class$("org.apache.jetspeed.om.page.ContentFragment")) : class$org$apache$jetspeed$om$page$ContentFragment), (Object)fragment, (Object)this, (String)"getPortletWindow(Fragment fragment)");
        PortletWindow portletWindow = this.getWindowFromCache(fragment);
        if (portletWindow == null) {
            try {
                return this.createPortletWindow(fragment);
            }
            catch (FailedToCreateWindowException e) {
                throw new FailedToRetrievePortletWindow(e.toString(), (Throwable)e);
            }
        }
        if (this.validateWindows) {
            this.validateWindow(fragment, portletWindow);
        }
        return portletWindow;
    }

    protected void validateWindow(ContentFragment fragment, PortletWindow portletWindow) throws FailedToRetrievePortletWindow, PortletEntityNotStoredException {
        MutablePortletEntity portletEntity = this.entityAccessor.getPortletEntityForFragment(fragment);
        if (portletEntity == null) {
            this.removeWindow(portletWindow);
            throw new FailedToRetrievePortletWindow("No PortletEntity exists for for id " + fragment.getId() + " removing window from cache.");
        }
        ((PortletWindowCtrl)portletWindow).setPortletEntity((PortletEntity)portletEntity);
    }

    public PortletWindow getPortletWindow(ContentFragment fragment, String principal) throws FailedToRetrievePortletWindow, FailedToCreateWindowException, PortletEntityNotStoredException {
        ArgUtil.assertNotNull((Class)(class$org$apache$jetspeed$om$page$ContentFragment == null ? (class$org$apache$jetspeed$om$page$ContentFragment = PortletWindowAccessorImpl.class$("org.apache.jetspeed.om.page.ContentFragment")) : class$org$apache$jetspeed$om$page$ContentFragment), (Object)fragment, (Object)this, (String)"getPortletWindow(Fragment fragment, String principal)");
        ArgUtil.assertNotNull((Class)(class$java$lang$String == null ? (class$java$lang$String = PortletWindowAccessorImpl.class$("java.lang.String")) : class$java$lang$String), (Object)principal, (Object)this, (String)"getPortletWindow(Fragment fragment, String principal)");
        PortletWindow portletWindow = this.getWindowFromCache(fragment);
        if (portletWindow == null) {
            return this.createPortletWindow(fragment, principal);
        }
        this.validateWindow(fragment, portletWindow);
        return portletWindow;
    }

    private PortletWindow createPortletWindow(ContentFragment fragment) throws FailedToCreateWindowException, PortletEntityNotStoredException {
        return this.createPortletWindow(fragment, null);
    }

    private PortletWindow createPortletWindow(ContentFragment fragment, String principal) throws FailedToCreateWindowException, PortletEntityNotStoredException {
        PortletWindowImpl portletWindow = new PortletWindowImpl(fragment.getId());
        MutablePortletEntity portletEntity = this.entityAccessor.getPortletEntityForFragment(fragment, principal);
        if (portletEntity == null) {
            log.info((Object)("No portlet entity defined for fragment ID " + fragment.getId() + " attempting to auto-generate..."));
            try {
                portletEntity = this.entityAccessor.generateEntityFromFragment(fragment, principal);
                if (portletEntity.getPortletDefinition() != null) {
                    this.entityAccessor.storePortletEntity((PortletEntity)portletEntity);
                }
            }
            catch (PortletEntityNotGeneratedException e) {
                throw new FailedToCreateWindowException("Error generating new PortletEntity: " + e.toString(), (Throwable)e);
            }
            catch (PortletEntityNotStoredException e) {
                throw new FailedToCreateWindowException("Error storing new PortletEntity: " + e.toString(), (Throwable)e);
            }
            if (portletEntity == null) {
                throw new FailedToCreateWindowException("Unable to generate portlet entity.");
            }
        }
        ((PortletWindowCtrl)portletWindow).setPortletEntity((PortletEntity)portletEntity);
        this.windows.put(fragment.getId(), portletWindow);
        return portletWindow;
    }

    public void removeWindows(PortletEntity portletEntity) {
        Iterator entityWindows = portletEntity.getPortletWindowList().iterator();
        while (entityWindows.hasNext()) {
            Object obj = entityWindows.next();
            PortletWindow window = (PortletWindow)obj;
            this.removeWindow(window);
        }
    }

    public void removeWindow(PortletWindow window) {
        this.windows.remove(window.getId().toString());
    }

    private PortletWindow getWindowFromCache(ContentFragment fragment) {
        return (PortletWindow)this.windows.get(fragment.getId());
    }

    private PortletWindow getWindowFromCache(String id) {
        return (PortletWindow)this.windows.get(id);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

