/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.url.impl;

import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.PortalContext;
import org.apache.jetspeed.container.state.NavigationalState;
import org.apache.jetspeed.container.url.impl.AbstractPortalURL;

public class PathInfoEncodingPortalURL
extends AbstractPortalURL {
    public PathInfoEncodingPortalURL(NavigationalState navState, PortalContext portalContext) {
        super(navState, portalContext);
    }

    public PathInfoEncodingPortalURL(String characterEncoding, NavigationalState navState, PortalContext portalContext) {
        super(characterEncoding, navState, portalContext);
    }

    public PathInfoEncodingPortalURL(HttpServletRequest request, String characterEncoding, NavigationalState navState, PortalContext portalContext) {
        super(request, characterEncoding, navState, portalContext);
    }

    protected void decodePathAndNavigationalState(HttpServletRequest request) {
        String path = null;
        String encodedNavState = null;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            StringTokenizer tokenizer = new StringTokenizer(request.getPathInfo(), "/");
            StringBuffer buffer = new StringBuffer();
            boolean foundNavState = false;
            String navStatePrefix = PathInfoEncodingPortalURL.getNavigationalStateParameterName() + ":";
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!foundNavState && token.startsWith(navStatePrefix)) {
                    foundNavState = true;
                    if (token.length() <= navStatePrefix.length()) continue;
                    encodedNavState = token.substring(navStatePrefix.length());
                    continue;
                }
                buffer.append("/");
                buffer.append(token);
            }
            path = buffer.length() > 0 ? buffer.toString() : "/";
        }
        this.setPath(path);
        this.setEncodedNavigationalState(encodedNavState);
    }

    protected String createPortletURL(String encodedNavState, boolean secure) {
        StringBuffer buffer = new StringBuffer(this.getBaseURL(secure));
        buffer.append(this.getBasePath());
        if (encodedNavState != null) {
            buffer.append("/");
            buffer.append(PathInfoEncodingPortalURL.getNavigationalStateParameterName());
            buffer.append(":");
            buffer.append(encodedNavState);
        }
        if (this.getPath() != null) {
            buffer.append(this.getPath());
        }
        return buffer.toString();
    }
}

