/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.url.impl;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.PortalContext;
import org.apache.jetspeed.container.state.NavigationalState;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.jetspeed.util.ArgUtil;
import org.apache.pluto.om.window.PortletWindow;

public abstract class AbstractPortalURL
implements PortalURL {
    public static final String DEFAULT_NAV_STATE_PARAMETER = "_ns";
    private static String navStateParameter;
    private NavigationalState navState;
    private String serverName;
    private String serverScheme;
    private String contextPath;
    private String basePath;
    private String path;
    private String encodedNavState;
    private String secureBaseURL;
    private String nonSecureBaseURL;
    private int serverPort;
    private boolean secure;
    private String characterEncoding = "UTF-8";
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;

    public AbstractPortalURL(NavigationalState navState, PortalContext portalContext) {
        if (navStateParameter == null) {
            navStateParameter = portalContext.getConfigurationProperty("portalurl.navigationalstate.parameter.name", DEFAULT_NAV_STATE_PARAMETER);
        }
        this.navState = navState;
    }

    public AbstractPortalURL(String characterEncoding, NavigationalState navState, PortalContext portalContext) {
        this(navState, portalContext);
        this.characterEncoding = characterEncoding;
    }

    public AbstractPortalURL(HttpServletRequest request, String characterEncoding, NavigationalState navState, PortalContext portalContext) {
        this(characterEncoding, navState, portalContext);
        this.setRequest(request);
    }

    public static String getNavigationalStateParameterName() {
        return navStateParameter;
    }

    protected void decodeBaseURL(HttpServletRequest request) {
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        this.serverScheme = request.getScheme();
        this.secure = request.isSecure();
        StringBuffer buffer = new StringBuffer("https");
        buffer.append("://").append(this.serverName);
        if (this.serverPort != 443 && this.serverPort != 80) {
            buffer.append(":").append(this.serverPort);
        }
        this.secureBaseURL = buffer.toString();
        buffer = new StringBuffer("http");
        buffer.append("://").append(this.serverName);
        if (this.serverPort != 443 && this.serverPort != 80) {
            buffer.append(":").append(this.serverPort);
        }
        this.nonSecureBaseURL = buffer.toString();
    }

    protected void decodeBasePath(HttpServletRequest request) {
        String servletPath;
        this.contextPath = (String)request.getAttribute("org.apache.jetspeed.context");
        if (this.contextPath == null) {
            this.contextPath = request.getContextPath();
        }
        if (this.contextPath == null) {
            this.contextPath = "";
        }
        if ((servletPath = request.getServletPath()) == null) {
            servletPath = "";
        }
        this.basePath = this.contextPath + servletPath;
    }

    protected void setEncodedNavigationalState(String encodedNavigationalState) {
        this.encodedNavState = encodedNavigationalState;
        try {
            this.navState.init(this.encodedNavState, this.characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            IllegalStateException ise = new IllegalStateException("An unsupported encoding was defined for this NavigationalState.");
            ise.initCause(e);
            throw ise;
        }
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public String getBaseURL() {
        return this.getBaseURL(this.secure);
    }

    public String getBaseURL(boolean secure) {
        return secure ? this.secureBaseURL : this.nonSecureBaseURL;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getPath() {
        return this.path;
    }

    public String getPageBasePath() {
        if (null == this.path || 1 == this.path.length() && '/' == this.path.charAt(0)) {
            return this.basePath;
        }
        if (-1 != this.path.indexOf(47) && !this.path.endsWith("/")) {
            return this.basePath + this.path.substring(0, this.path.lastIndexOf(47));
        }
        return this.basePath + this.path;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public NavigationalState getNavigationalState() {
        return this.navState;
    }

    public String createPortletURL(PortletWindow window, Map parameters, PortletMode mode, WindowState state, boolean action, boolean secure) {
        try {
            return this.createPortletURL(this.navState.encode(window, parameters, mode, state, action), secure);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String createPortletURL(PortletWindow window, PortletMode mode, WindowState state, boolean secure) {
        try {
            return this.createPortletURL(this.navState.encode(window, mode, state), secure);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract void decodePathAndNavigationalState(HttpServletRequest var1);

    protected abstract String createPortletURL(String var1, boolean var2);

    public void setRequest(HttpServletRequest request) {
        ArgUtil.assertNotNull((Class)(class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = AbstractPortalURL.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest), (Object)request, (Object)this, (String)"setRequest");
        this.decodeBaseURL(request);
        this.decodeBasePath(request);
        this.decodePathAndNavigationalState(request);
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

