/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.state.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.PortalContext;
import org.apache.jetspeed.container.state.impl.NavigationalStateCodec;
import org.apache.jetspeed.container.state.impl.PortletWindowRequestNavigationalState;
import org.apache.jetspeed.container.state.impl.PortletWindowRequestNavigationalStates;
import org.apache.jetspeed.container.window.PortletWindowAccessor;
import org.apache.pluto.om.window.PortletWindow;

public class JetspeedNavigationalStateCodec
implements NavigationalStateCodec {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$container$state$impl$JetspeedNavigationalStateCodec == null ? (class$org$apache$jetspeed$container$state$impl$JetspeedNavigationalStateCodec = JetspeedNavigationalStateCodec.class$("org.apache.jetspeed.container.state.impl.JetspeedNavigationalStateCodec")) : class$org$apache$jetspeed$container$state$impl$JetspeedNavigationalStateCodec));
    protected static final char PARAMETER_SEPARATOR = '|';
    protected static final char PARAMETER_ELEMENT_SEPARATOR = '=';
    protected static final char RENDER_WINDOW_ID_KEY = 'a';
    protected static final char ACTION_WINDOW_ID_KEY = 'b';
    protected static final char MODE_KEY = 'c';
    protected static final char STATE_KEY = 'd';
    protected static final char PARAM_KEY = 'e';
    protected static final char CLEAR_PARAMS_KEY = 'f';
    protected static final String keytable = "01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected final PortletMode[] portletModes;
    protected final WindowState[] windowStates;
    private final PortalContext portalContext;
    private final PortletWindowAccessor windowAccessor;
    static /* synthetic */ Class class$org$apache$jetspeed$container$state$impl$JetspeedNavigationalStateCodec;

    public JetspeedNavigationalStateCodec(PortalContext portalContext, PortletWindowAccessor windowAccessor) {
        Object o;
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration portletModesEnum = portalContext.getSupportedPortletModes();
        this.portalContext = portalContext;
        this.windowAccessor = windowAccessor;
        list.add(PortletMode.VIEW);
        list.add(PortletMode.EDIT);
        list.add(PortletMode.HELP);
        while (portletModesEnum.hasMoreElements()) {
            o = portletModesEnum.nextElement();
            if (list.contains(o)) continue;
            list.add(o);
        }
        this.portletModes = list.toArray(new PortletMode[list.size()]);
        if (this.portletModes.length > keytable.length()) {
            throw new UnsupportedOperationException("Too many supported PortletModes found. Can only handle max: " + keytable.length());
        }
        list.clear();
        list.add(WindowState.NORMAL);
        list.add(WindowState.MAXIMIZED);
        list.add(WindowState.MINIMIZED);
        Enumeration windowStatesEnum = portalContext.getSupportedWindowStates();
        while (windowStatesEnum.hasMoreElements()) {
            o = windowStatesEnum.nextElement();
            if (list.contains(o)) continue;
            list.add(o);
        }
        this.windowStates = list.toArray(new WindowState[list.size()]);
        if (this.windowStates.length > keytable.length()) {
            throw new UnsupportedOperationException("Too many supported WindowModes found. Can only handle max: " + keytable.length());
        }
    }

    public PortletWindowRequestNavigationalStates decode(String parameters, String characterEncoding) throws UnsupportedEncodingException {
        PortletWindowRequestNavigationalStates states = new PortletWindowRequestNavigationalStates(characterEncoding);
        if (parameters != null && parameters.length() > 0) {
            String decodedParameters = this.decodeParameters(parameters, characterEncoding);
            int position = 0;
            StringBuffer buffer = new StringBuffer();
            PortletWindowRequestNavigationalState currentState = null;
            while ((position = this.decodeArgument(position, decodedParameters, buffer, '|')) != -1) {
                String parameter = buffer.toString();
                currentState = this.decodeParameter(this.windowAccessor, states, currentState, parameter);
            }
            if (log.isDebugEnabled()) {
                this.logDecode(states, buffer);
                if (buffer.length() > 0) {
                    buffer.append("]");
                    log.debug((Object)("navstate decoded=" + buffer.toString()));
                }
            }
        }
        return states;
    }

    private void logDecode(PortletWindowRequestNavigationalStates states, StringBuffer buffer) {
        buffer.setLength(0);
        String actionWindowId = states.getActionWindow() != null ? states.getActionWindow().getId().toString() : "";
        Iterator iter = states.getWindowIdIterator();
        while (iter.hasNext()) {
            if (buffer.length() == 0) {
                buffer.append("[[");
            } else {
                buffer.append(",[");
            }
            PortletWindowRequestNavigationalState currentState = states.getPortletWindowNavigationalState((String)iter.next());
            buffer.append("window:" + currentState.getWindowId());
            if (currentState.getWindowId().equals(actionWindowId)) {
                buffer.append(",action:true");
            }
            if (currentState.getPortletMode() != null) {
                buffer.append(",mode:" + currentState.getPortletMode());
            }
            if (currentState.getWindowState() != null) {
                buffer.append(",state:" + currentState.getWindowState());
            }
            if (!currentState.isClearParameters() && currentState.getParametersMap() != null) {
                buffer.append(",parameters:[");
                boolean first = true;
                Iterator parIter = currentState.getParametersMap().keySet().iterator();
                while (parIter.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(",");
                    }
                    String name = (String)parIter.next();
                    buffer.append(name + ":[");
                    String[] values = (String[])currentState.getParametersMap().get(name);
                    for (int i = 0; i < values.length; ++i) {
                        if (i > 0) {
                            buffer.append(",");
                        }
                        buffer.append(values[i]);
                    }
                    buffer.append("]");
                }
            }
            buffer.append("]");
        }
    }

    public String encode(PortletWindowRequestNavigationalStates states, PortletWindow window, PortletMode portletMode, WindowState windowState, boolean navParamsStateFull, boolean renderParamsStateFull) throws UnsupportedEncodingException {
        String windowId = window.getId().toString();
        PortletWindowRequestNavigationalState currentState = states.getPortletWindowNavigationalState(windowId);
        PortletWindowRequestNavigationalState targetState = new PortletWindowRequestNavigationalState(windowId);
        targetState.setPortletMode((PortletMode)(portletMode != null ? portletMode : (currentState != null ? currentState.getPortletMode() : null)));
        targetState.setWindowState((WindowState)(windowState != null ? windowState : (currentState != null ? currentState.getWindowState() : null)));
        if (currentState != null && !renderParamsStateFull && currentState.getParametersMap() != null) {
            Iterator parametersIter = currentState.getParametersMap().entrySet().iterator();
            while (parametersIter.hasNext()) {
                Map.Entry entry = parametersIter.next();
                targetState.setParameters((String)entry.getKey(), (String[])entry.getValue());
            }
        }
        return this.encode(states, windowId, targetState, false, navParamsStateFull, renderParamsStateFull);
    }

    public String encode(PortletWindowRequestNavigationalStates states, PortletWindow window, Map parameters, PortletMode portletMode, WindowState windowState, boolean action, boolean navParamsStateFull, boolean renderParamsStateFull) throws UnsupportedEncodingException {
        String windowId = window.getId().toString();
        PortletWindowRequestNavigationalState currentState = states.getPortletWindowNavigationalState(windowId);
        PortletWindowRequestNavigationalState targetState = new PortletWindowRequestNavigationalState(windowId);
        targetState.setPortletMode((PortletMode)(portletMode != null ? portletMode : (currentState != null ? currentState.getPortletMode() : null)));
        targetState.setWindowState((WindowState)(windowState != null ? windowState : (currentState != null ? currentState.getWindowState() : null)));
        Iterator parametersIter = parameters.entrySet().iterator();
        while (parametersIter.hasNext()) {
            Map.Entry entry = parametersIter.next();
            targetState.setParameters((String)entry.getKey(), (String[])entry.getValue());
        }
        if (renderParamsStateFull && targetState.getParametersMap() == null) {
            targetState.setClearParameters(true);
        }
        return this.encode(states, windowId, targetState, action, navParamsStateFull, renderParamsStateFull);
    }

    protected String encode(PortletWindowRequestNavigationalStates states, String targetWindowId, PortletWindowRequestNavigationalState targetState, boolean action, boolean navParamsStateFull, boolean renderParamsStateFull) throws UnsupportedEncodingException {
        String encodedState;
        StringBuffer buffer = new StringBuffer();
        boolean haveState = false;
        if (!navParamsStateFull || !renderParamsStateFull) {
            Iterator iter = states.getWindowIdIterator();
            while (iter.hasNext()) {
                String windowId = (String)iter.next();
                PortletWindowRequestNavigationalState pwfns = states.getPortletWindowNavigationalState(windowId);
                if (windowId.equals(targetWindowId) || (encodedState = this.encodePortletWindowNavigationalState(windowId, pwfns, false, navParamsStateFull, renderParamsStateFull)).length() <= 0) continue;
                if (!haveState) {
                    haveState = true;
                } else {
                    buffer.append('|');
                }
                buffer.append(encodedState);
            }
        }
        if ((encodedState = this.encodePortletWindowNavigationalState(targetWindowId, targetState, action, false, false)).length() > 0) {
            if (!haveState) {
                haveState = true;
            } else {
                buffer.append('|');
            }
            buffer.append(encodedState);
        }
        String encodedNavState = null;
        if (haveState) {
            encodedNavState = this.encodeParameters(buffer.toString(), states.getCharacterEncoding());
        }
        return encodedNavState;
    }

    protected String encodePortletWindowNavigationalState(String windowId, PortletWindowRequestNavigationalState state, boolean action, boolean navParamsStateFull, boolean renderParamsStateFull) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(action ? (char)'b' : 'a');
        buffer.append(windowId);
        boolean encoded = action;
        if (action || !navParamsStateFull) {
            if (state.getPortletMode() != null) {
                buffer.append('|');
                buffer.append('c');
                buffer.append(this.encodePortletMode(state.getPortletMode()));
                encoded = true;
            }
            if (state.getWindowState() != null) {
                buffer.append('|');
                buffer.append('d');
                buffer.append(this.encodeWindowState(state.getWindowState()));
                encoded = true;
            }
        }
        if (state.getParametersMap() != null && (action || !renderParamsStateFull)) {
            StringBuffer paramBuffer = new StringBuffer();
            Iterator iter = state.getParametersMap().entrySet().iterator();
            while (iter.hasNext()) {
                encoded = true;
                Map.Entry entry = iter.next();
                String parameterName = (String)entry.getKey();
                String[] parameterValues = (String[])entry.getValue();
                buffer.append('|');
                buffer.append('e');
                paramBuffer.setLength(0);
                paramBuffer.append(this.encodeArgument(parameterName, '='));
                paramBuffer.append('=');
                paramBuffer.append(parameterValues.length);
                for (int i = 0; i < parameterValues.length; ++i) {
                    paramBuffer.append('=');
                    paramBuffer.append(this.encodeArgument(parameterValues[i], '='));
                }
                buffer.append(this.encodeArgument(paramBuffer.toString(), '|'));
            }
        } else if (state.isClearParameters()) {
            buffer.append('|');
            buffer.append('f');
            encoded = true;
        }
        return encoded ? buffer.toString() : "";
    }

    protected PortletWindowRequestNavigationalState decodeParameter(PortletWindowAccessor accessor, PortletWindowRequestNavigationalStates states, PortletWindowRequestNavigationalState currentState, String parameter) {
        char parameterType = parameter.charAt(0);
        if (parameterType == 'a' || parameterType == 'b') {
            PortletWindow window;
            String windowId = parameter.substring(1);
            currentState = states.getPortletWindowNavigationalState(windowId);
            if (currentState == null && (window = accessor.getPortletWindow(windowId)) != null) {
                currentState = new PortletWindowRequestNavigationalState(windowId);
                states.addPortletWindowNavigationalState(windowId, currentState);
                if (parameterType == 'b') {
                    states.setActionWindow(window);
                }
            }
        } else if (currentState != null) {
            block0 : switch (parameterType) {
                case 'c': {
                    char c = parameter.charAt(1);
                    PortletMode portletMode = this.decodePortletMode(parameter.charAt(1));
                    if (portletMode == null) break;
                    currentState.setPortletMode(portletMode);
                    break;
                }
                case 'd': {
                    char c = parameter.charAt(1);
                    WindowState windowState = this.decodeWindowState(parameter.charAt(1));
                    if (windowState == null) break;
                    currentState.setWindowState(windowState);
                    if (!windowState.equals((Object)WindowState.MAXIMIZED)) break;
                    states.setMaximizedWindow(accessor.getPortletWindow(currentState.getWindowId()));
                    break;
                }
                case 'e': {
                    int position = 1;
                    StringBuffer buffer = new StringBuffer();
                    String parameterName = null;
                    int parameterValueCount = -1;
                    String[] parameterValues = null;
                    int parameterValueIndex = -1;
                    while ((position = this.decodeArgument(position, parameter, buffer, '=')) != -1) {
                        if (parameterName == null) {
                            parameterName = buffer.toString();
                            parameterValueCount = -1;
                            continue;
                        }
                        if (parameterValueCount == -1) {
                            parameterValueCount = Integer.parseInt(buffer.toString(), 16);
                            parameterValues = new String[parameterValueCount];
                            parameterValueIndex = 0;
                            continue;
                        }
                        parameterValues[parameterValueIndex++] = buffer.toString();
                        if (--parameterValueCount != 0) continue;
                        currentState.setParameters(parameterName, parameterValues);
                        break block0;
                    }
                    break;
                }
                case 'f': {
                    currentState.setClearParameters(true);
                }
            }
        }
        return currentState;
    }

    protected PortletMode decodePortletMode(char mode) {
        PortletMode portletMode = null;
        int index = keytable.indexOf(mode);
        if (index > -1 && index < this.portletModes.length) {
            portletMode = this.portletModes[index];
        }
        return portletMode;
    }

    protected char encodePortletMode(PortletMode portletMode) {
        for (int i = 0; i < this.portletModes.length; ++i) {
            if (!this.portletModes[i].equals((Object)portletMode)) continue;
            return keytable.charAt(i);
        }
        throw new IllegalArgumentException("Unsupported PortletMode: " + portletMode);
    }

    protected WindowState decodeWindowState(char state) {
        WindowState windowState = null;
        int index = keytable.indexOf(state);
        if (index > -1 && index < this.windowStates.length) {
            windowState = this.windowStates[index];
        }
        return windowState;
    }

    protected char encodeWindowState(WindowState windowState) {
        for (int i = 0; i < this.windowStates.length; ++i) {
            if (!this.windowStates[i].equals((Object)windowState)) continue;
            return keytable.charAt(i);
        }
        throw new IllegalArgumentException("Unsupported WindowState: " + windowState);
    }

    protected String decodeParameters(String value, String characterEncoding) throws UnsupportedEncodingException {
        value = StringUtils.replace((String)value, (String)"-", (String)"/");
        value = StringUtils.replace((String)value, (String)"_", (String)"=");
        if (characterEncoding != null) {
            return new String(Base64.decodeBase64((byte[])value.getBytes(characterEncoding)), characterEncoding);
        }
        return new String(Base64.decodeBase64((byte[])value.getBytes()));
    }

    protected String encodeParameters(String value, String characterEncoding) throws UnsupportedEncodingException {
        value = characterEncoding != null ? new String(Base64.encodeBase64((byte[])value.getBytes(characterEncoding))) : new String(Base64.encodeBase64((byte[])value.getBytes()));
        value = StringUtils.replace((String)value, (String)"/", (String)"-");
        value = StringUtils.replace((String)value, (String)"=", (String)"_");
        return value;
    }

    protected String encodeArgument(String argument, char escape) {
        int length = argument.length();
        StringBuffer buffer = new StringBuffer(length);
        buffer.setLength(0);
        for (int i = 0; i < length; ++i) {
            char c = argument.charAt(i);
            buffer.append(c);
            if (c != escape) continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    protected int decodeArgument(int position, String arguments, StringBuffer buffer, char escape) {
        int maxLength = arguments.length();
        buffer.setLength(0);
        while (position < maxLength) {
            char c = arguments.charAt(position);
            if (c != escape) {
                buffer.append(c);
            } else if (c == escape && position < maxLength - 1 && arguments.charAt(position + 1) == escape) {
                buffer.append(c);
                ++position;
            } else {
                ++position;
                break;
            }
            ++position;
        }
        return buffer.length() > 0 ? position : -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

